/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.csvserializer;

import io.dialob.api.form.Form;
import io.dialob.api.form.FormItem;
import io.dialob.api.form.FormValueSet;
import io.dialob.api.form.FormValueSetEntry;
import io.dialob.api.form.Variable;
import io.dialob.api.questionnaire.Answer;
import io.dialob.api.questionnaire.ContextValue;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.questionnaire.service.api.QuestionnaireDatabase;
import io.dialob.security.tenant.CurrentTenant;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVSerializer.class);
    private static final String LABEL_LANGUAGE = "en";
    private static final Map<String, Map<Boolean, String>> BOOLEAN_TRANSLATION = Map.of("en", Map.of(Boolean.TRUE, "Yes", Boolean.FALSE, "No"), "fi", Map.of(Boolean.TRUE, "Kyll\u00e4", Boolean.FALSE, "Ei"));
    private static final String MULTICHOICE_DELIMITER = ", ";
    private static final String[] IGNORED_TYPES = new String[]{"questionnaire", "page", "group", "note", "rowgroup", "surveygroup"};
    private final QuestionnaireDatabase questionnaireDatabase;
    private final CurrentTenant currentTenant;

    public CSVSerializer(QuestionnaireDatabase questionnaireDatabase, CurrentTenant currentTenant) {
        this.questionnaireDatabase = questionnaireDatabase;
        this.currentTenant = currentTenant;
    }

    private Optional<FormValueSetEntry> getChoice(Form form, String valueSetId, Object answer) {
        Optional<FormValueSet> valueSet = form.getValueSets().stream().filter(vs -> vs.getId().equals(valueSetId)).findFirst();
        if (valueSet.isPresent()) {
            return valueSet.get().getEntries().stream().filter(vse -> vse.getId().equals(answer)).findFirst();
        }
        return Optional.empty();
    }

    private String getValuesetAnswer(Form form, Questionnaire questionnaire, String valueSetId, String valueKey) {
        Optional<FormValueSetEntry> value = this.getChoice(form, valueSetId, valueKey);
        if (value.isPresent()) {
            return (String)value.get().getLabel().get(questionnaire.getMetadata().getLanguage());
        }
        return valueKey;
    }

    private Optional<Answer> getAnswer(Questionnaire questionnaire, String itemId) {
        return questionnaire.getAnswers().stream().filter(answer -> answer.getId().equals(itemId)).findFirst();
    }

    private String serializeBoolean(Boolean value, String language) {
        Map<Boolean, String> translation = BOOLEAN_TRANSLATION.get(language);
        if (translation == null) {
            translation = BOOLEAN_TRANSLATION.get(LABEL_LANGUAGE);
        }
        return translation.get(value);
    }

    private void serializeAnswer(Form form, Questionnaire questionnaire, FormItem formItem, String answerId, List<String> records, String language, String effectiveValueSetId) throws IOException {
        Optional<FormValueSet> valueSet;
        String valueSetId;
        Optional<Answer> a = this.getAnswer(questionnaire, answerId != null ? answerId : formItem.getId());
        String realValue = "";
        String valueKey = "";
        String string = valueSetId = formItem.getType().equals("survey") ? effectiveValueSetId : formItem.getValueSetId();
        if (null != valueSetId && (valueSet = form.getValueSets().stream().filter(vs -> vs.getId().equals(valueSetId)).findFirst()).isPresent() && formItem.getType().equals("multichoice")) {
            valueSet.get().getEntries().forEach(entry -> {
                Optional<String> matchingValue;
                String val = "0";
                String key = null;
                if (a.isPresent() && ((Answer)a.get()).getValue() != null && (matchingValue = ((Collection)((Answer)a.get()).getValue()).stream().filter(value -> value.equals(entry.getId())).findFirst()).isPresent()) {
                    val = "1";
                    key = entry.getId();
                }
                records.add(val);
                records.add(key);
            });
        }
        if (a.isPresent() && a.get().getValue() != null) {
            if (null != valueSetId) {
                if (a.get().getValue() instanceof Collection) {
                    realValue = ((Collection)a.get().getValue()).stream().map(key -> this.getValuesetAnswer(form, questionnaire, valueSetId, (String)key)).collect(Collectors.joining(MULTICHOICE_DELIMITER));
                    valueKey = ((Collection)a.get().getValue()).stream().collect(Collectors.joining(MULTICHOICE_DELIMITER));
                } else {
                    valueKey = a.get().getValue().toString();
                    realValue = this.getValuesetAnswer(form, questionnaire, valueSetId, valueKey);
                }
            } else if ("BOOLEAN".equals(a.get().getType())) {
                realValue = this.serializeBoolean(Boolean.valueOf((String)a.get().getValue()), language);
                valueKey = a.get().getValue().toString();
            } else {
                realValue = a.get().getValue().toString();
            }
        }
        records.add(realValue);
        records.add(valueKey);
    }

    private void serializeItem(Form form, Questionnaire questionnaire, FormItem formItem, String answerId, List<String> records, String language, String effectiveValueSetId) {
        try {
            Object exportFlag;
            Object object = exportFlag = formItem.getProps() != null ? (Object)formItem.getProps().get("export") : null;
            if (exportFlag != null && "false".equals(exportFlag.toString())) {
                return;
            }
            if ("surveygroup".equals(formItem.getType())) {
                String surveyGroupValueSet = formItem.getValueSetId();
                formItem.getItems().stream().map(itemId -> (FormItem)form.getData().get(itemId)).forEach(item -> this.serializeItem(form, questionnaire, (FormItem)item, null, records, language, surveyGroupValueSet));
                return;
            }
            if (ArrayUtils.contains((Object[])IGNORED_TYPES, (Object)formItem.getType())) {
                return;
            }
            if (null != formItem.getItems() && formItem.getItems().size() > 0) {
                if ("rowgroup".equals(formItem.getType())) {
                    List rows;
                    Optional<Answer> a = this.getAnswer(questionnaire, formItem.getId());
                    if (a.isPresent() && (rows = (List)a.get().getValue()) != null) {
                        if (rows.size() > 0) {
                            records.add((String)formItem.getLabel().get(LABEL_LANGUAGE));
                            records.add(formItem.getId());
                        }
                        rows.forEach(row -> formItem.getItems().stream().map(itemId -> (FormItem)form.getData().get(itemId)).forEach(item -> this.serializeItem(form, questionnaire, (FormItem)item, String.format("%s.%d.%s", formItem.getId(), row, item.getId()), records, language, null)));
                    }
                } else {
                    formItem.getItems().stream().map(itemId -> (FormItem)form.getData().get(itemId)).forEach(item -> this.serializeItem(form, questionnaire, (FormItem)item, null, records, language, null));
                }
            } else {
                if ("survey".equals(formItem.getType()) && effectiveValueSetId == null) {
                    return;
                }
                this.serializeAnswer(form, questionnaire, formItem, answerId, records, language, effectiveValueSetId);
            }
        }
        catch (IOException e) {
            LOGGER.error("CSV Serialization error", (Throwable)e);
        }
    }

    private void serializeContextValue(ContextValue cv, CSVPrinter printer) {
        try {
            printer.printRecord(new Object[]{cv.getId(), "", cv.getValue()});
        }
        catch (IOException e) {
            LOGGER.error("CSV Serialization Error", (Throwable)e);
        }
    }

    private String dedupLabel(String label, Map<String, Integer> labelDedups) {
        if (labelDedups.containsKey(label)) {
            Integer index = labelDedups.get(label) + 1;
            labelDedups.put((String)label, index);
            label = index.toString() + ". " + (String)label;
        } else {
            labelDedups.put((String)label, 0);
        }
        return label;
    }

    private void addHeaderFormItem(Form form, FormItem formItem, Map<String, Integer> labelDedups, List<String> result, String language) {
        Object exportFlag;
        Object object = exportFlag = formItem.getProps() != null ? (Object)formItem.getProps().get("export") : null;
        if (!(exportFlag != null && "false".equals(exportFlag.toString()) || ArrayUtils.contains((Object[])IGNORED_TYPES, (Object)formItem.getType()))) {
            String label = (String)formItem.getLabel().get(language);
            if (formItem.getType().equals("multichoice")) {
                String selectionId = formItem.getValueSetId();
                Optional<FormValueSet> values = form.getValueSets().stream().filter(valueSet -> valueSet.getId().equals(selectionId)).findFirst();
                if (values.isPresent()) {
                    values.get().getEntries().forEach(entry -> {
                        result.add(this.dedupLabel((String)entry.getLabel().get(language), labelDedups));
                        result.add(this.dedupLabel(entry.getId(), labelDedups));
                    });
                }
            }
            result.add(this.dedupLabel(label, labelDedups));
            result.add(formItem.getId());
        }
    }

    public String[] serializeHeader(Form form, String language) throws IOException {
        ArrayList result = new ArrayList();
        HashMap labelDedups = new HashMap();
        form.getData().values().forEach(formItem -> this.addHeaderFormItem(form, (FormItem)formItem, labelDedups, result, language));
        form.getVariables().forEach(variable -> {
            if (Boolean.TRUE.equals(variable.getContext())) {
                result.add(variable.getName());
            }
        });
        return (String[])result.stream().toArray(String[]::new);
    }

    private void serializeVariable(Variable variable, Questionnaire questionnaire, List<String> records) throws IOException {
        if (Boolean.TRUE.equals(variable.getContext())) {
            Optional<ContextValue> var = questionnaire.getContext().stream().filter(varValue -> variable.getName().equals(varValue.getId())).findFirst();
            if (var.isPresent()) {
                records.add(var.get().getValue().toString());
            } else {
                records.add("");
            }
        }
    }

    private void serialize(Questionnaire questionnaire, Form form, CSVPrinter printer, String language) throws IOException {
        ArrayList<String> records = new ArrayList<String>();
        form.getData().values().stream().forEach(item -> this.serializeItem(form, questionnaire, (FormItem)item, null, (List<String>)records, language, null));
        for (Variable variable : form.getVariables()) {
            this.serializeVariable(variable, questionnaire, records);
        }
        printer.printRecord(records);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serializeQuestionnaires(String[] sessionIds, Form form, String language) throws IOException {
        StringWriter out = new StringWriter();
        try (CSVPrinter printer = null;){
            printer = new CSVPrinter((Appendable)out, CSVFormat.DEFAULT.withHeader(this.serializeHeader(form, language)));
            for (String sessionId : sessionIds) {
                Questionnaire questionnaire = this.questionnaireDatabase.findOne(this.currentTenant.getId(), sessionId);
                this.serialize(questionnaire, form, printer, language);
            }
        }
        return out.toString();
    }
}

