/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service.rest;

import io.dialob.api.proto.ActionItem;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.questionnaire.Answer;
import io.dialob.api.questionnaire.Error;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.api.questionnaire.QuestionnaireListItem;
import io.dialob.api.rest.IdAndRevision;
import io.dialob.api.rest.Items;
import io.dialob.api.rest.Response;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(value={"${dialob.api.context-path:}/questionnaires"})
@OpenAPIDefinition(info=@Info(title="DialobQuestionnaireService"), tags={@Tag(name="dialob-questionnaire-service")})
public interface QuestionnairesRestService {
    @Operation(summary="Create a new questionnaire object")
    @PostMapping(produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<IdAndRevision> postQuestionnaire(@Parameter(name="questionnaire", required=true, description="New questionnaire object") @NonNull @RequestBody @Validated Questionnaire var1);

    @GetMapping(produces={"application/json"})
    public ResponseEntity<List<QuestionnaireListItem>> getQuestionnaires(@RequestParam(name="owner", required=false) String var1, @RequestParam(name="formId", required=false) String var2, @RequestParam(name="formName", required=false) String var3, @RequestParam(name="formTag", required=false) String var4, @RequestParam(name="status", required=false) Questionnaire.Metadata.Status var5);

    @GetMapping(produces={"text/csv"})
    public ResponseEntity<String> getCsv(@RequestParam(name="formId") Optional<String> var1, @RequestParam(name="formName") Optional<String> var2, @RequestParam(name="formTag") Optional<String> var3, @RequestParam(name="questionnaire") Optional<List<String>> var4, @RequestParam(name="language") Optional<String> var5, @RequestParam(name="from") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) Optional<LocalDateTime> var6, @RequestParam(name="to") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) Optional<LocalDateTime> var7);

    @Operation(summary="Retrieve a specific questionnaire", description="You can use the questionnaire ID to retrieve a specific questionnaire.")
    @GetMapping(path={"{questionnaireId}"}, produces={"application/json"})
    public ResponseEntity<Questionnaire> getQuestionnaire(@Parameter(description="The internal identifier of a questionnaire") @PathVariable(value="questionnaireId") String var1);

    @Operation(summary="Delete a specific questionnaire", description="You can use the questionnaire ID to delete a specific questionnaire.")
    @DeleteMapping(path={"{questionnaireId}"})
    public ResponseEntity<Response> deleteQuestionnaire(@Parameter(description="The internal identifier of a questionnaire") @PathVariable(value="questionnaireId") String var1);

    @Operation(summary="Update an existing questionnaire object", description="You can update an existing questionnaire object by questionnaire ID")
    @PutMapping(path={"{questionnaireId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Questionnaire> putQuestionnaire(@Parameter(description="The internal identifier of a questionnaire") @PathVariable(value="questionnaireId") String var1, @Parameter(name="questionnaire", required=true, description="Questionnaire object to replace existing state") @RequestBody @Validated Questionnaire var2);

    @Operation(summary="Return questionnaire status", description="Return the status of a questionnaire: NEW, OPEN, COMPLETED")
    @GetMapping(path={"{questionnaireId}/status"}, produces={"application/json"})
    public ResponseEntity<Questionnaire.Metadata.Status> getQuestionnaireStatus(@PathVariable(value="questionnaireId") @Parameter(description="The internal identifier of a questionnaire") String var1);

    @Operation(summary="Update a questionnaire status")
    @PutMapping(path={"{questionnaireId}/status"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Questionnaire.Metadata.Status> putQuestionnaireStatus(@PathVariable(value="questionnaireId") @Parameter(description="The internal identifier of a questionnaire") String var1, @Parameter(name="status", required=true, description="The new status for a questionnaire") @RequestBody Questionnaire.Metadata.Status var2);

    @Operation(summary="Return the answers from a questionnaire", description="This endpoint enables you to retrive a user's answers for a questionnaire in their original format")
    @GetMapping(path={"{questionnaireId}/answers"}, produces={"application/json"})
    public ResponseEntity<List<Answer>> getQuestionnaireAnswers(@Parameter(description="The internal identifier of a questionnaire") @PathVariable(value="questionnaireId") String var1);

    @Operation(summary="Return errors for a questionnaire", description="Return an array of error values by questionnaire ID")
    @GetMapping(path={"{questionnaireId}/errors"}, produces={"application/json"})
    public ResponseEntity<List<Error>> getQuestionnaireErrors(@Parameter(description="The internal identifier of a questionnaire") @PathVariable(value="questionnaireId") String var1);

    @Operation(summary="Create a new answer for a questionnaire")
    @PostMapping(path={"{questionnaireId}/answers"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<Error>> putQuestionnaireAnswers(@PathVariable(value="questionnaireId") @Parameter(description="The internal identifier of a questionnaire") String var1, @Parameter(name="answers", required=true, description="New answers for a questionnaire") @RequestBody List<Answer> var2);

    @Operation(summary="Update a single answer", description="Update a single answer on a questionnaire by questionnaire ID and answer ID")
    @PutMapping(path={"{questionnaireId}/answers/{answerId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<Error>> putQuestionnaireAnswer(@PathVariable(value="questionnaireId") @Parameter(description="The internal identifier of a questionnaire") String var1, @PathVariable(value="answerId") @Parameter(description="The unique identifier of an answer") String var2, @Parameter(name="answer", required=true, description="New answer value for a single question") @RequestBody Object var3);

    @Operation(summary="Delete a single answer", description="Delete a single answer on a questionnaire by questionnaire ID and answer ID")
    @DeleteMapping(path={"{questionnaireId}/answers/{answerId}"}, produces={"application/json"})
    public ResponseEntity<List<Error>> deleteQuestionnaireAnswer(@PathVariable(value="questionnaireId") @Parameter(description="The internal identifier of a questionnaire") String var1, @PathVariable(value="answerId") @Parameter(description="The unique identifier of an answer") String var2);

    @Operation(summary="Return a pages object for a questionnaire", description="Return an object outlining a questionnaire's pages, including page items, the active item (active page), and the available items (all available pages) by questionnaire ID.")
    @GetMapping(path={"{questionnaireId}/pages"}, produces={"application/json"})
    public ResponseEntity<Items> getQuestionnairePages(@PathVariable(value="questionnaireId") @Parameter(description="The internal identifier of a questionnaire") String var1);

    @Operation(summary="Update a questionnaire active page")
    @PutMapping(path={"{questionnaireId}/pages"}, produces={"application/json"})
    public ResponseEntity<Items> putQuestionnairePages(@NonNull @PathVariable(value="questionnaireId") @Parameter(description="The internal identifier of a questionnaire") String var1, @Parameter(name="pages", required=true, description="Pages object for use in updating a questionnaire active page") @RequestBody Items var2);

    @Operation(summary="Return all questionnaire items", description="With this endpoint, you can return an object which contains all of a questionnaire's items.")
    @GetMapping(path={"{questionnaireId}/items"}, produces={"application/json"})
    public ResponseEntity<List<ActionItem>> getQuestionnaireItems(@PathVariable(value="questionnaireId") @Parameter(description="The internal identifier of a questionnaire") String var1);

    @Operation(summary="Return a single questionnaire item", description="With this endpoint, you can return an object containing a single questionnaire item and its contents.")
    @GetMapping(path={"{questionnaireId}/items/{itemId}"}, produces={"application/json"})
    public ResponseEntity<ActionItem> getQuestionnaireItem(@PathVariable(value="questionnaireId") @Parameter(description="The internal identifier of an item") String var1, @PathVariable(value="itemId") String var2);

    @Operation(summary="Return array indexes and values of rowgroup items", description="This action returns an object containing the array indexes and values of row items within a particular rowgroup from a single questionnaire.")
    @GetMapping(path={"{questionnaireId}/items/{itemId}/rows"}, produces={"application/json"})
    public ResponseEntity<List<String>> getQuestionnaireItemRows(@PathVariable(value="questionnaireId") @Parameter(description="The internal identifier of a questionnaire") String var1, @PathVariable(value="itemId") @Parameter(description="The internal identifier of an item") String var2);

    @Operation(summary="Create a new row item", description="Using this action, you can create a new row item within a rowgroup type")
    @PostMapping(path={"{questionnaireId}/items/{itemId}/rows"}, produces={"application/json"})
    public ResponseEntity<List<String>> postQuestionnaireItemRow(@PathVariable(value="questionnaireId") @Parameter(description="The internal identifier of a questionnaire") String var1, @Parameter(description="The internal identifier of an item") @PathVariable(value="itemId") String var2);

    @Operation(summary="Delete a row item", description="Delete a particlar row item by item ID and row ID.")
    @DeleteMapping(path={"{questionnaireId}/items/{itemId}/rows/{rowId}"}, produces={"application/json"})
    public ResponseEntity<List<String>> deleteQuestionnaireItemRow(@PathVariable(value="questionnaireId") @Parameter(description="The internal identifier of a questionnaire") String var1, @Parameter(description="The internal identifier of an item") @PathVariable(value="itemId") String var2, @Parameter(description="The unique identifier of a row") @PathVariable(value="rowId") String var3);

    @Operation(summary="Return all lists and their key-value pairs", description="Return an object detailing a particular questionnaire's list(s) and key-value pairs for each list item")
    @GetMapping(path={"{questionnaireId}/valueSets"}, produces={"application/json"})
    public ResponseEntity<List<ValueSet>> getQuestionnaireValueSets(@PathVariable(value="questionnaireId") @Parameter(description="The internal identifier of a questionnaire") String var1);

    @Operation(summary="Return key-value pairs of a particular list", description="Return an object detailing the key-value pairs of a particular list on a questionnaire")
    @GetMapping(path={"{questionnaireId}/valueSets/{valueSetId}"}, produces={"application/json"})
    public ResponseEntity<ValueSet> getQuestionnaireValueSet(@PathVariable(value="questionnaireId") @Parameter(description="The internal identifier of a questionnaire") String var1, @PathVariable(value="valueSetId") @Parameter(description="The internal identifier of a value set") String var2);
}

