package io.dialob.questionnaire.service.api.event;

import io.dialob.integration.api.event.TenantScopedEvent;
import io.dialob.security.tenant.Tenant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link QuestionnaireCompletedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQuestionnaireCompletedEvent.builder()}.
 */
@Generated(from = "QuestionnaireCompletedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableQuestionnaireCompletedEvent
    implements QuestionnaireCompletedEvent {
  private final Tenant tenant;
  private final String questionnaireId;

  private ImmutableQuestionnaireCompletedEvent(Tenant tenant, String questionnaireId) {
    this.tenant = tenant;
    this.questionnaireId = questionnaireId;
  }

  /**
   * @return The value of the {@code tenant} attribute
   */
  @Override
  public Tenant getTenant() {
    return tenant;
  }

  /**
   * @return questionnaire id of event
   */
  @Override
  public String getQuestionnaireId() {
    return questionnaireId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireCompletedEvent#getTenant() tenant} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenant
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireCompletedEvent withTenant(Tenant value) {
    if (this.tenant == value) return this;
    Tenant newValue = Objects.requireNonNull(value, "tenant");
    return new ImmutableQuestionnaireCompletedEvent(newValue, this.questionnaireId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireCompletedEvent#getQuestionnaireId() questionnaireId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for questionnaireId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireCompletedEvent withQuestionnaireId(String value) {
    String newValue = Objects.requireNonNull(value, "questionnaireId");
    if (this.questionnaireId.equals(newValue)) return this;
    return new ImmutableQuestionnaireCompletedEvent(this.tenant, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQuestionnaireCompletedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQuestionnaireCompletedEvent
        && equalTo((ImmutableQuestionnaireCompletedEvent) another);
  }

  private boolean equalTo(ImmutableQuestionnaireCompletedEvent another) {
    return tenant.equals(another.tenant)
        && questionnaireId.equals(another.questionnaireId);
  }

  /**
   * Computes a hash code from attributes: {@code tenant}, {@code questionnaireId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + tenant.hashCode();
    h += (h << 5) + questionnaireId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code QuestionnaireCompletedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "QuestionnaireCompletedEvent{"
        + "tenant=" + tenant
        + ", questionnaireId=" + questionnaireId
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link QuestionnaireCompletedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable QuestionnaireCompletedEvent instance
   */
  public static ImmutableQuestionnaireCompletedEvent copyOf(QuestionnaireCompletedEvent instance) {
    if (instance instanceof ImmutableQuestionnaireCompletedEvent) {
      return (ImmutableQuestionnaireCompletedEvent) instance;
    }
    return ImmutableQuestionnaireCompletedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQuestionnaireCompletedEvent ImmutableQuestionnaireCompletedEvent}.
   * <pre>
   * ImmutableQuestionnaireCompletedEvent.builder()
   *    .tenant(io.dialob.security.tenant.Tenant) // required {@link QuestionnaireCompletedEvent#getTenant() tenant}
   *    .questionnaireId(String) // required {@link QuestionnaireCompletedEvent#getQuestionnaireId() questionnaireId}
   *    .build();
   * </pre>
   * @return A new ImmutableQuestionnaireCompletedEvent builder
   */
  public static ImmutableQuestionnaireCompletedEvent.Builder builder() {
    return new ImmutableQuestionnaireCompletedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQuestionnaireCompletedEvent ImmutableQuestionnaireCompletedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "QuestionnaireCompletedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TENANT = 0x1L;
    private static final long INIT_BIT_QUESTIONNAIRE_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Tenant tenant;
    private @Nullable String questionnaireId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.questionnaire.service.api.event.QuestionnaireEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(QuestionnaireEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.integration.api.event.TenantScopedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantScopedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.questionnaire.service.api.event.QuestionnaireCompletedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(QuestionnaireCompletedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof QuestionnaireEvent) {
        QuestionnaireEvent instance = (QuestionnaireEvent) object;
        questionnaireId(instance.getQuestionnaireId());
      }
      if (object instanceof TenantScopedEvent) {
        TenantScopedEvent instance = (TenantScopedEvent) object;
        tenant(instance.getTenant());
      }
    }

    /**
     * Initializes the value for the {@link QuestionnaireCompletedEvent#getTenant() tenant} attribute.
     * @param tenant The value for tenant 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tenant(Tenant tenant) {
      this.tenant = Objects.requireNonNull(tenant, "tenant");
      initBits &= ~INIT_BIT_TENANT;
      return this;
    }

    /**
     * Initializes the value for the {@link QuestionnaireCompletedEvent#getQuestionnaireId() questionnaireId} attribute.
     * @param questionnaireId The value for questionnaireId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder questionnaireId(String questionnaireId) {
      this.questionnaireId = Objects.requireNonNull(questionnaireId, "questionnaireId");
      initBits &= ~INIT_BIT_QUESTIONNAIRE_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableQuestionnaireCompletedEvent ImmutableQuestionnaireCompletedEvent}.
     * @return An immutable instance of QuestionnaireCompletedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQuestionnaireCompletedEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableQuestionnaireCompletedEvent(tenant, questionnaireId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TENANT) != 0) attributes.add("tenant");
      if ((initBits & INIT_BIT_QUESTIONNAIRE_ID) != 0) attributes.add("questionnaireId");
      return "Cannot build QuestionnaireCompletedEvent, some of required attributes are not set " + attributes;
    }
  }
}
