package io.dialob.questionnaire.service.api;

import io.dialob.api.questionnaire.Questionnaire;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link QuestionnaireDatabase.MetadataRow}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMetadataRow.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableMetadataRow.of()}.
 */
@Generated(from = "QuestionnaireDatabase.MetadataRow", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableMetadataRow
    implements QuestionnaireDatabase.MetadataRow {
  private final String id;
  private final Questionnaire.Metadata value;

  private ImmutableMetadataRow(String id, Questionnaire.Metadata value) {
    this.id = Objects.requireNonNull(id, "id");
    this.value = Objects.requireNonNull(value, "value");
  }

  private ImmutableMetadataRow(
      ImmutableMetadataRow original,
      String id,
      Questionnaire.Metadata value) {
    this.id = id;
    this.value = value;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public Questionnaire.Metadata getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireDatabase.MetadataRow#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMetadataRow withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableMetadataRow(this, newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireDatabase.MetadataRow#getValue() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMetadataRow withValue(Questionnaire.Metadata value) {
    if (this.value == value) return this;
    Questionnaire.Metadata newValue = Objects.requireNonNull(value, "value");
    return new ImmutableMetadataRow(this, this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMetadataRow} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMetadataRow
        && equalTo((ImmutableMetadataRow) another);
  }

  private boolean equalTo(ImmutableMetadataRow another) {
    return id.equals(another.id)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MetadataRow} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MetadataRow{"
        + "id=" + id
        + ", value=" + value
        + "}";
  }

  /**
   * Construct a new immutable {@code MetadataRow} instance.
   * @param id The value for the {@code id} attribute
   * @param value The value for the {@code value} attribute
   * @return An immutable MetadataRow instance
   */
  public static ImmutableMetadataRow of(String id, Questionnaire.Metadata value) {
    return new ImmutableMetadataRow(id, value);
  }

  /**
   * Creates an immutable copy of a {@link QuestionnaireDatabase.MetadataRow} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MetadataRow instance
   */
  public static ImmutableMetadataRow copyOf(QuestionnaireDatabase.MetadataRow instance) {
    if (instance instanceof ImmutableMetadataRow) {
      return (ImmutableMetadataRow) instance;
    }
    return ImmutableMetadataRow.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMetadataRow ImmutableMetadataRow}.
   * <pre>
   * ImmutableMetadataRow.builder()
   *    .id(String) // required {@link QuestionnaireDatabase.MetadataRow#getId() id}
   *    .value(io.dialob.api.questionnaire.Questionnaire.Metadata) // required {@link QuestionnaireDatabase.MetadataRow#getValue() value}
   *    .build();
   * </pre>
   * @return A new ImmutableMetadataRow builder
   */
  public static ImmutableMetadataRow.Builder builder() {
    return new ImmutableMetadataRow.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMetadataRow ImmutableMetadataRow}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "QuestionnaireDatabase.MetadataRow", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable Questionnaire.Metadata value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MetadataRow} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(QuestionnaireDatabase.MetadataRow instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      value(instance.getValue());
      return this;
    }

    /**
     * Initializes the value for the {@link QuestionnaireDatabase.MetadataRow#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link QuestionnaireDatabase.MetadataRow#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder value(Questionnaire.Metadata value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMetadataRow ImmutableMetadataRow}.
     * @return An immutable instance of MetadataRow
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMetadataRow build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMetadataRow(null, id, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build MetadataRow, some of required attributes are not set " + attributes;
    }
  }
}
