/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service.api.session;

import io.dialob.api.form.Form;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.questionnaire.Answer;
import io.dialob.api.questionnaire.ContextValue;
import io.dialob.api.questionnaire.ImmutableQuestionnaire;
import io.dialob.api.questionnaire.ImmutableQuestionnaireMetadata;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.db.spi.exceptions.DatabaseException;
import io.dialob.questionnaire.service.api.FormDataMissingException;
import io.dialob.questionnaire.service.api.session.FormFinder;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionBuilder;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseQuestionnaireSessionBuilder
implements QuestionnaireSessionBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseQuestionnaireSessionBuilder.class);
    public static final String LATEST_REV = "LATEST";
    private final FormFinder formFinder;
    private boolean createOnly;
    private Questionnaire questionnaire;
    private String formRev;
    private String activeItem;
    private String formId;
    private String creator;
    private String owner;
    private String submitUrl;
    private List<ContextValue> contextValues;
    private String language = "en";
    private List<Answer> answers;
    private List<ValueSet> valueSets;
    private Questionnaire.Metadata.Status status;
    private Map<String, Object> additionalProperties;

    protected BaseQuestionnaireSessionBuilder(@Nonnull FormFinder formFinder) {
        this.formFinder = formFinder;
    }

    @Override
    @Nonnull
    public QuestionnaireSessionBuilder setActiveItem(String activeItem) {
        this.activeItem = activeItem;
        return this;
    }

    @Override
    @Nonnull
    public QuestionnaireSessionBuilder setFormId(String formId) {
        this.formId = formId;
        return this;
    }

    @Override
    public QuestionnaireSessionBuilder setCreator(String creator) {
        this.creator = creator;
        return this;
    }

    @Override
    public QuestionnaireSessionBuilder setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    @Override
    @Nonnull
    public QuestionnaireSessionBuilder setFormRev(String formRev) {
        this.formRev = formRev;
        return this;
    }

    @Override
    @Nonnull
    public QuestionnaireSessionBuilder setSubmitUrl(String submitUrl) {
        this.submitUrl = submitUrl;
        return this;
    }

    @Override
    @Nonnull
    public QuestionnaireSessionBuilder setContextValues(List<ContextValue> contextValues) {
        this.contextValues = contextValues;
        return this;
    }

    @Override
    @Nonnull
    public QuestionnaireSessionBuilder setCreateOnly(boolean createOnly) {
        this.createOnly = createOnly;
        return this;
    }

    @Override
    @Nonnull
    public QuestionnaireSessionBuilder setLanguage(String language) {
        this.language = language;
        if (StringUtils.isBlank((CharSequence)language)) {
            this.language = "en";
        }
        return this;
    }

    @Override
    @Nonnull
    public QuestionnaireSessionBuilder setStatus(Questionnaire.Metadata.Status status) {
        this.status = status;
        return this;
    }

    @Override
    @Nonnull
    public QuestionnaireSessionBuilder setAnswers(List<Answer> answers) {
        this.answers = answers;
        return this;
    }

    @Override
    @Nonnull
    public QuestionnaireSessionBuilder setValueSets(List<ValueSet> valueSets) {
        this.valueSets = valueSets;
        return this;
    }

    @Override
    @Nonnull
    public QuestionnaireSessionBuilder setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    @Nonnull
    public QuestionnaireSessionBuilder setQuestionnaire(Questionnaire questionnaire) {
        this.questionnaire = questionnaire;
        if (this.questionnaire != null) {
            Questionnaire.Metadata metadata = this.questionnaire.getMetadata();
            if (this.activeItem == null) {
                this.setActiveItem(this.questionnaire.getActiveItem());
            }
            if (this.formId == null) {
                this.setFormId(metadata.getFormId());
            }
            if (this.formRev == null) {
                this.setFormRev(metadata.getFormRev());
            }
            if (this.owner == null) {
                this.setOwner(metadata.getOwner());
            }
            if (this.creator == null) {
                this.setCreator(metadata.getCreator());
            }
            if (this.additionalProperties == null) {
                this.setAdditionalProperties(metadata.getAdditionalProperties());
            }
            this.setLanguage(metadata.getLanguage());
        }
        return this;
    }

    @Nonnull
    protected Questionnaire createNewQuestionnaire(@Nonnull String formId, String formRev, String formName, String label, String submitUrl, String creator, String owner, Map<String, Object> additionalProperties, boolean useLatest) {
        ImmutableQuestionnaire.Builder questionnaire = ImmutableQuestionnaire.builder();
        ImmutableQuestionnaireMetadata.Builder metadata = ImmutableQuestionnaireMetadata.builder();
        if (additionalProperties != null) {
            metadata.putAllAdditionalProperties(additionalProperties);
        }
        metadata.formId(formId);
        metadata.formName(formName);
        metadata.label(label);
        metadata.creator(creator);
        metadata.owner(StringUtils.defaultString((String)owner, (String)creator));
        metadata.status(this.getStatus() != null ? this.getStatus() : Questionnaire.Metadata.Status.NEW);
        if (useLatest) {
            metadata.formRev(LATEST_REV);
        } else {
            metadata.formRev(formRev);
        }
        metadata.created(new Date());
        if (this.getSubmitUrl() != null) {
            metadata.submitUrl(this.getSubmitUrl());
        } else {
            metadata.submitUrl(submitUrl);
        }
        metadata.language(this.getLanguage());
        questionnaire.metadata((Questionnaire.Metadata)metadata.build());
        if (this.getContextValues() != null) {
            questionnaire.context(this.getContextValues());
        }
        if (this.getAnswers() != null) {
            questionnaire.answers(this.getAnswers());
        }
        if (this.getValueSets() != null) {
            questionnaire.valueSets(this.getValueSets());
        }
        questionnaire.activeItem(this.activeItem);
        return questionnaire.build();
    }

    @Nonnull
    protected abstract QuestionnaireSession createQuestionnaireSession(boolean var1, @Nonnull Form var2);

    @Override
    @Nonnull
    public QuestionnaireSession build() {
        Form formDocument;
        Objects.requireNonNull(this.getFormId(), "QuestionnaireSessionBuilder.formId is required");
        boolean useLatest = LATEST_REV.equals(this.getFormRev());
        boolean newSession = this.getQuestionnaire() == null;
        String formRev = null;
        if (!useLatest) {
            formRev = this.getFormRev();
        }
        try {
            formDocument = this.formFinder.findForm(this.getFormId(), formRev);
        }
        catch (DatabaseException e) {
            LOGGER.debug("Could not load form {}: {}", (Object)this.getFormId(), (Object)e.getMessage());
            throw new FormDataMissingException(this.getFormId(), formRev);
        }
        if (newSession) {
            Form.Metadata metadata = formDocument.getMetadata();
            String formId = formDocument.getId();
            String formName = null;
            if (!formId.equals(this.getFormId())) {
                formName = this.getFormId();
            }
            this.questionnaire = this.createNewQuestionnaire(formId, formDocument.getRev(), formName, metadata.getLabel(), metadata.getDefaultSubmitUrl(), this.creator, this.owner, this.additionalProperties, useLatest);
        }
        return this.createQuestionnaireSession(newSession, formDocument);
    }

    protected boolean isCreateOnly() {
        return this.createOnly;
    }

    protected Questionnaire getQuestionnaire() {
        return this.questionnaire;
    }

    protected String getFormRev() {
        return this.formRev;
    }

    protected String getActiveItem() {
        return this.activeItem;
    }

    protected String getFormId() {
        return this.formId;
    }

    protected String getSubmitUrl() {
        return this.submitUrl;
    }

    protected List<ContextValue> getContextValues() {
        return this.contextValues;
    }

    protected String getLanguage() {
        return this.language;
    }

    protected List<Answer> getAnswers() {
        return this.answers;
    }

    protected List<ValueSet> getValueSets() {
        return this.valueSets;
    }

    protected Questionnaire.Metadata.Status getStatus() {
        return this.status;
    }
}

