/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service.api.event;

import io.dialob.integration.api.event.TenantScopedEvent;
import io.dialob.questionnaire.service.api.event.QuestionnaireClientDisconnectedEvent;
import io.dialob.questionnaire.service.api.event.QuestionnaireEvent;
import io.dialob.security.tenant.Tenant;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="QuestionnaireClientDisconnectedEvent", generator="Immutables")
@Immutable
public final class ImmutableQuestionnaireClientDisconnectedEvent
implements QuestionnaireClientDisconnectedEvent {
    private final Tenant tenant;
    private final String questionnaireId;
    private final InetAddress client;
    private final int closeStatus;

    private ImmutableQuestionnaireClientDisconnectedEvent(Tenant tenant, String questionnaireId, InetAddress client, int closeStatus) {
        this.tenant = tenant;
        this.questionnaireId = questionnaireId;
        this.client = client;
        this.closeStatus = closeStatus;
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    @Override
    public String getQuestionnaireId() {
        return this.questionnaireId;
    }

    @Override
    public InetAddress getClient() {
        return this.client;
    }

    @Override
    public int getCloseStatus() {
        return this.closeStatus;
    }

    public final ImmutableQuestionnaireClientDisconnectedEvent withTenant(Tenant value) {
        if (this.tenant == value) {
            return this;
        }
        Tenant newValue = Objects.requireNonNull(value, "tenant");
        return new ImmutableQuestionnaireClientDisconnectedEvent(newValue, this.questionnaireId, this.client, this.closeStatus);
    }

    public final ImmutableQuestionnaireClientDisconnectedEvent withQuestionnaireId(String value) {
        String newValue = Objects.requireNonNull(value, "questionnaireId");
        if (this.questionnaireId.equals(newValue)) {
            return this;
        }
        return new ImmutableQuestionnaireClientDisconnectedEvent(this.tenant, newValue, this.client, this.closeStatus);
    }

    public final ImmutableQuestionnaireClientDisconnectedEvent withClient(InetAddress value) {
        if (this.client == value) {
            return this;
        }
        InetAddress newValue = Objects.requireNonNull(value, "client");
        return new ImmutableQuestionnaireClientDisconnectedEvent(this.tenant, this.questionnaireId, newValue, this.closeStatus);
    }

    public final ImmutableQuestionnaireClientDisconnectedEvent withCloseStatus(int value) {
        if (this.closeStatus == value) {
            return this;
        }
        return new ImmutableQuestionnaireClientDisconnectedEvent(this.tenant, this.questionnaireId, this.client, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQuestionnaireClientDisconnectedEvent && this.equalTo((ImmutableQuestionnaireClientDisconnectedEvent)another);
    }

    private boolean equalTo(ImmutableQuestionnaireClientDisconnectedEvent another) {
        return this.tenant.equals(another.tenant) && this.questionnaireId.equals(another.questionnaireId) && this.client.equals(another.client) && this.closeStatus == another.closeStatus;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.tenant.hashCode();
        h += (h << 5) + this.questionnaireId.hashCode();
        h += (h << 5) + this.client.hashCode();
        h += (h << 5) + this.closeStatus;
        return h;
    }

    public String toString() {
        return "QuestionnaireClientDisconnectedEvent{tenant=" + this.tenant + ", questionnaireId=" + this.questionnaireId + ", client=" + this.client + ", closeStatus=" + this.closeStatus + "}";
    }

    public static ImmutableQuestionnaireClientDisconnectedEvent copyOf(QuestionnaireClientDisconnectedEvent instance) {
        if (instance instanceof ImmutableQuestionnaireClientDisconnectedEvent) {
            return (ImmutableQuestionnaireClientDisconnectedEvent)instance;
        }
        return ImmutableQuestionnaireClientDisconnectedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="QuestionnaireClientDisconnectedEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TENANT = 1L;
        private static final long INIT_BIT_QUESTIONNAIRE_ID = 2L;
        private static final long INIT_BIT_CLIENT = 4L;
        private static final long INIT_BIT_CLOSE_STATUS = 8L;
        private long initBits = 15L;
        @Nullable
        private Tenant tenant;
        @Nullable
        private String questionnaireId;
        @Nullable
        private InetAddress client;
        private int closeStatus;

        private Builder() {
        }

        public final Builder from(QuestionnaireEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TenantScopedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(QuestionnaireClientDisconnectedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            QuestionnaireEvent instance;
            if (object instanceof QuestionnaireEvent) {
                instance = (QuestionnaireEvent)object;
                this.questionnaireId(instance.getQuestionnaireId());
            }
            if (object instanceof TenantScopedEvent) {
                instance = (TenantScopedEvent)object;
                this.tenant(instance.getTenant());
            }
            if (object instanceof QuestionnaireClientDisconnectedEvent) {
                instance = (QuestionnaireClientDisconnectedEvent)object;
                this.client(instance.getClient());
                this.closeStatus(instance.getCloseStatus());
            }
        }

        public final Builder tenant(Tenant tenant) {
            this.tenant = Objects.requireNonNull(tenant, "tenant");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder questionnaireId(String questionnaireId) {
            this.questionnaireId = Objects.requireNonNull(questionnaireId, "questionnaireId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder client(InetAddress client) {
            this.client = Objects.requireNonNull(client, "client");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder closeStatus(int closeStatus) {
            this.closeStatus = closeStatus;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableQuestionnaireClientDisconnectedEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQuestionnaireClientDisconnectedEvent(this.tenant, this.questionnaireId, this.client, this.closeStatus);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tenant");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("questionnaireId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("client");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("closeStatus");
            }
            return "Cannot build QuestionnaireClientDisconnectedEvent, some of required attributes are not set " + attributes;
        }
    }
}

