/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service.api.event;

import io.dialob.integration.api.event.TenantScopedEvent;
import io.dialob.questionnaire.service.api.event.QuestionnaireClientConnectedEvent;
import io.dialob.questionnaire.service.api.event.QuestionnaireEvent;
import io.dialob.security.tenant.Tenant;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="QuestionnaireClientConnectedEvent", generator="Immutables")
@Immutable
public final class ImmutableQuestionnaireClientConnectedEvent
implements QuestionnaireClientConnectedEvent {
    private final Tenant tenant;
    private final String questionnaireId;
    private final InetAddress client;

    private ImmutableQuestionnaireClientConnectedEvent(Tenant tenant, String questionnaireId, InetAddress client) {
        this.tenant = tenant;
        this.questionnaireId = questionnaireId;
        this.client = client;
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    @Override
    public String getQuestionnaireId() {
        return this.questionnaireId;
    }

    @Override
    public InetAddress getClient() {
        return this.client;
    }

    public final ImmutableQuestionnaireClientConnectedEvent withTenant(Tenant value) {
        if (this.tenant == value) {
            return this;
        }
        Tenant newValue = Objects.requireNonNull(value, "tenant");
        return new ImmutableQuestionnaireClientConnectedEvent(newValue, this.questionnaireId, this.client);
    }

    public final ImmutableQuestionnaireClientConnectedEvent withQuestionnaireId(String value) {
        String newValue = Objects.requireNonNull(value, "questionnaireId");
        if (this.questionnaireId.equals(newValue)) {
            return this;
        }
        return new ImmutableQuestionnaireClientConnectedEvent(this.tenant, newValue, this.client);
    }

    public final ImmutableQuestionnaireClientConnectedEvent withClient(InetAddress value) {
        if (this.client == value) {
            return this;
        }
        InetAddress newValue = Objects.requireNonNull(value, "client");
        return new ImmutableQuestionnaireClientConnectedEvent(this.tenant, this.questionnaireId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQuestionnaireClientConnectedEvent && this.equalTo((ImmutableQuestionnaireClientConnectedEvent)another);
    }

    private boolean equalTo(ImmutableQuestionnaireClientConnectedEvent another) {
        return this.tenant.equals(another.tenant) && this.questionnaireId.equals(another.questionnaireId) && this.client.equals(another.client);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.tenant.hashCode();
        h += (h << 5) + this.questionnaireId.hashCode();
        h += (h << 5) + this.client.hashCode();
        return h;
    }

    public String toString() {
        return "QuestionnaireClientConnectedEvent{tenant=" + this.tenant + ", questionnaireId=" + this.questionnaireId + ", client=" + this.client + "}";
    }

    public static ImmutableQuestionnaireClientConnectedEvent copyOf(QuestionnaireClientConnectedEvent instance) {
        if (instance instanceof ImmutableQuestionnaireClientConnectedEvent) {
            return (ImmutableQuestionnaireClientConnectedEvent)instance;
        }
        return ImmutableQuestionnaireClientConnectedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="QuestionnaireClientConnectedEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TENANT = 1L;
        private static final long INIT_BIT_QUESTIONNAIRE_ID = 2L;
        private static final long INIT_BIT_CLIENT = 4L;
        private long initBits = 7L;
        @Nullable
        private Tenant tenant;
        @Nullable
        private String questionnaireId;
        @Nullable
        private InetAddress client;

        private Builder() {
        }

        public final Builder from(QuestionnaireClientConnectedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(QuestionnaireEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TenantScopedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            QuestionnaireEvent instance;
            if (object instanceof QuestionnaireClientConnectedEvent) {
                instance = (QuestionnaireClientConnectedEvent)object;
                this.client(instance.getClient());
            }
            if (object instanceof QuestionnaireEvent) {
                instance = (QuestionnaireEvent)object;
                this.questionnaireId(instance.getQuestionnaireId());
            }
            if (object instanceof TenantScopedEvent) {
                instance = (TenantScopedEvent)object;
                this.tenant(instance.getTenant());
            }
        }

        public final Builder tenant(Tenant tenant) {
            this.tenant = Objects.requireNonNull(tenant, "tenant");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder questionnaireId(String questionnaireId) {
            this.questionnaireId = Objects.requireNonNull(questionnaireId, "questionnaireId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder client(InetAddress client) {
            this.client = Objects.requireNonNull(client, "client");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableQuestionnaireClientConnectedEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQuestionnaireClientConnectedEvent(this.tenant, this.questionnaireId, this.client);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tenant");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("questionnaireId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("client");
            }
            return "Cannot build QuestionnaireClientConnectedEvent, some of required attributes are not set " + attributes;
        }
    }
}

