package io.dialob.questionnaire.service.api.session;

import io.dialob.api.proto.Actions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code ImmutableQuestionnaireSession} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link QuestionnaireSession}.
 * @see ImmutableQuestionnaireSession.DispatchActionsResult
 */
@Generated(from = "QuestionnaireSession", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableQuestionnaireSession {
  private ImmutableQuestionnaireSession() {}

  /**
   * Immutable implementation of {@link QuestionnaireSession.DispatchActionsResult}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableQuestionnaireSession.DispatchActionsResult.builder()}.
   */
  @Generated(from = "QuestionnaireSession.DispatchActionsResult", generator = "Immutables")
  @Immutable
  public static final class DispatchActionsResult
      implements QuestionnaireSession.DispatchActionsResult {
    private final Actions actions;
    private final boolean isDidComplete;

    private DispatchActionsResult(Actions actions, boolean isDidComplete) {
      this.actions = actions;
      this.isDidComplete = isDidComplete;
    }

    /**
     * @return The value of the {@code actions} attribute
     */
    @Override
    public Actions getActions() {
      return actions;
    }

    /**
     * @return The value of the {@code isDidComplete} attribute
     */
    @Override
    public boolean isDidComplete() {
      return isDidComplete;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link QuestionnaireSession.DispatchActionsResult#getActions() actions} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for actions
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableQuestionnaireSession.DispatchActionsResult withActions(Actions value) {
      if (this.actions == value) return this;
      Actions newValue = Objects.requireNonNull(value, "actions");
      return new ImmutableQuestionnaireSession.DispatchActionsResult(newValue, this.isDidComplete);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link QuestionnaireSession.DispatchActionsResult#isDidComplete() isDidComplete} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for isDidComplete
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableQuestionnaireSession.DispatchActionsResult withIsDidComplete(boolean value) {
      if (this.isDidComplete == value) return this;
      return new ImmutableQuestionnaireSession.DispatchActionsResult(this.actions, value);
    }

    /**
     * This instance is equal to all instances of {@code DispatchActionsResult} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableQuestionnaireSession.DispatchActionsResult
          && equalTo((ImmutableQuestionnaireSession.DispatchActionsResult) another);
    }

    private boolean equalTo(ImmutableQuestionnaireSession.DispatchActionsResult another) {
      return actions.equals(another.actions)
          && isDidComplete == another.isDidComplete;
    }

    /**
     * Computes a hash code from attributes: {@code actions}, {@code isDidComplete}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + actions.hashCode();
      h += (h << 5) + Boolean.hashCode(isDidComplete);
      return h;
    }

    /**
     * Prints the immutable value {@code DispatchActionsResult} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "DispatchActionsResult{"
          + "actions=" + actions
          + ", isDidComplete=" + isDidComplete
          + "}";
    }

    /**
     * Creates an immutable copy of a {@link QuestionnaireSession.DispatchActionsResult} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable DispatchActionsResult instance
     */
    public static ImmutableQuestionnaireSession.DispatchActionsResult copyOf(QuestionnaireSession.DispatchActionsResult instance) {
      if (instance instanceof ImmutableQuestionnaireSession.DispatchActionsResult) {
        return (ImmutableQuestionnaireSession.DispatchActionsResult) instance;
      }
      return ImmutableQuestionnaireSession.DispatchActionsResult.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableQuestionnaireSession.DispatchActionsResult DispatchActionsResult}.
     * <pre>
     * ImmutableQuestionnaireSession.DispatchActionsResult.builder()
     *    .actions(io.dialob.api.proto.Actions) // required {@link QuestionnaireSession.DispatchActionsResult#getActions() actions}
     *    .isDidComplete(boolean) // required {@link QuestionnaireSession.DispatchActionsResult#isDidComplete() isDidComplete}
     *    .build();
     * </pre>
     * @return A new DispatchActionsResult builder
     */
    public static ImmutableQuestionnaireSession.DispatchActionsResult.Builder builder() {
      return new ImmutableQuestionnaireSession.DispatchActionsResult.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableQuestionnaireSession.DispatchActionsResult DispatchActionsResult}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "QuestionnaireSession.DispatchActionsResult", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_ACTIONS = 0x1L;
      private static final long INIT_BIT_IS_DID_COMPLETE = 0x2L;
      private long initBits = 0x3L;

      private @Nullable Actions actions;
      private boolean isDidComplete;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code DispatchActionsResult} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(QuestionnaireSession.DispatchActionsResult instance) {
        Objects.requireNonNull(instance, "instance");
        actions(instance.getActions());
        isDidComplete(instance.isDidComplete());
        return this;
      }

      /**
       * Initializes the value for the {@link QuestionnaireSession.DispatchActionsResult#getActions() actions} attribute.
       * @param actions The value for actions 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder actions(Actions actions) {
        this.actions = Objects.requireNonNull(actions, "actions");
        initBits &= ~INIT_BIT_ACTIONS;
        return this;
      }

      /**
       * Initializes the value for the {@link QuestionnaireSession.DispatchActionsResult#isDidComplete() isDidComplete} attribute.
       * @param isDidComplete The value for isDidComplete 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder isDidComplete(boolean isDidComplete) {
        this.isDidComplete = isDidComplete;
        initBits &= ~INIT_BIT_IS_DID_COMPLETE;
        return this;
      }

      /**
       * Builds a new {@link ImmutableQuestionnaireSession.DispatchActionsResult DispatchActionsResult}.
       * @return An immutable instance of DispatchActionsResult
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableQuestionnaireSession.DispatchActionsResult build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableQuestionnaireSession.DispatchActionsResult(actions, isDidComplete);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_ACTIONS) != 0) attributes.add("actions");
        if ((initBits & INIT_BIT_IS_DID_COMPLETE) != 0) attributes.add("isDidComplete");
        return "Cannot build DispatchActionsResult, some of required attributes are not set " + attributes;
      }
    }
  }
}
