package io.dialob.questionnaire.service.api.event;

import io.dialob.api.proto.Actions;
import io.dialob.integration.api.event.TenantScopedEvent;
import io.dialob.security.tenant.Tenant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link QuestionnaireActionsEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQuestionnaireActionsEvent.builder()}.
 */
@Generated(from = "QuestionnaireActionsEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableQuestionnaireActionsEvent
    implements QuestionnaireActionsEvent {
  private final Tenant tenant;
  private final String questionnaireId;
  private final Actions actions;

  private ImmutableQuestionnaireActionsEvent(
      Tenant tenant,
      String questionnaireId,
      Actions actions) {
    this.tenant = tenant;
    this.questionnaireId = questionnaireId;
    this.actions = actions;
  }

  /**
   * @return The value of the {@code tenant} attribute
   */
  @Override
  public Tenant getTenant() {
    return tenant;
  }

  /**
   * @return questionnaire id of event
   */
  @Override
  public String getQuestionnaireId() {
    return questionnaireId;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @Override
  public Actions getActions() {
    return actions;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireActionsEvent#getTenant() tenant} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenant
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireActionsEvent withTenant(Tenant value) {
    if (this.tenant == value) return this;
    Tenant newValue = Objects.requireNonNull(value, "tenant");
    return new ImmutableQuestionnaireActionsEvent(newValue, this.questionnaireId, this.actions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireActionsEvent#getQuestionnaireId() questionnaireId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for questionnaireId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireActionsEvent withQuestionnaireId(String value) {
    String newValue = Objects.requireNonNull(value, "questionnaireId");
    if (this.questionnaireId.equals(newValue)) return this;
    return new ImmutableQuestionnaireActionsEvent(this.tenant, newValue, this.actions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireActionsEvent#getActions() actions} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for actions
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireActionsEvent withActions(Actions value) {
    if (this.actions == value) return this;
    Actions newValue = Objects.requireNonNull(value, "actions");
    return new ImmutableQuestionnaireActionsEvent(this.tenant, this.questionnaireId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQuestionnaireActionsEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQuestionnaireActionsEvent
        && equalTo((ImmutableQuestionnaireActionsEvent) another);
  }

  private boolean equalTo(ImmutableQuestionnaireActionsEvent another) {
    return tenant.equals(another.tenant)
        && questionnaireId.equals(another.questionnaireId)
        && actions.equals(another.actions);
  }

  /**
   * Computes a hash code from attributes: {@code tenant}, {@code questionnaireId}, {@code actions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + tenant.hashCode();
    h += (h << 5) + questionnaireId.hashCode();
    h += (h << 5) + actions.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code QuestionnaireActionsEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "QuestionnaireActionsEvent{"
        + "tenant=" + tenant
        + ", questionnaireId=" + questionnaireId
        + ", actions=" + actions
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link QuestionnaireActionsEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable QuestionnaireActionsEvent instance
   */
  public static ImmutableQuestionnaireActionsEvent copyOf(QuestionnaireActionsEvent instance) {
    if (instance instanceof ImmutableQuestionnaireActionsEvent) {
      return (ImmutableQuestionnaireActionsEvent) instance;
    }
    return ImmutableQuestionnaireActionsEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQuestionnaireActionsEvent ImmutableQuestionnaireActionsEvent}.
   * <pre>
   * ImmutableQuestionnaireActionsEvent.builder()
   *    .tenant(io.dialob.security.tenant.Tenant) // required {@link QuestionnaireActionsEvent#getTenant() tenant}
   *    .questionnaireId(String) // required {@link QuestionnaireActionsEvent#getQuestionnaireId() questionnaireId}
   *    .actions(io.dialob.api.proto.Actions) // required {@link QuestionnaireActionsEvent#getActions() actions}
   *    .build();
   * </pre>
   * @return A new ImmutableQuestionnaireActionsEvent builder
   */
  public static ImmutableQuestionnaireActionsEvent.Builder builder() {
    return new ImmutableQuestionnaireActionsEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQuestionnaireActionsEvent ImmutableQuestionnaireActionsEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "QuestionnaireActionsEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TENANT = 0x1L;
    private static final long INIT_BIT_QUESTIONNAIRE_ID = 0x2L;
    private static final long INIT_BIT_ACTIONS = 0x4L;
    private long initBits = 0x7L;

    private @Nullable Tenant tenant;
    private @Nullable String questionnaireId;
    private @Nullable Actions actions;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.questionnaire.service.api.event.QuestionnaireActionsEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(QuestionnaireActionsEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.questionnaire.service.api.event.QuestionnaireEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(QuestionnaireEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.integration.api.event.TenantScopedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantScopedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof QuestionnaireActionsEvent) {
        QuestionnaireActionsEvent instance = (QuestionnaireActionsEvent) object;
        actions(instance.getActions());
      }
      if (object instanceof QuestionnaireEvent) {
        QuestionnaireEvent instance = (QuestionnaireEvent) object;
        questionnaireId(instance.getQuestionnaireId());
      }
      if (object instanceof TenantScopedEvent) {
        TenantScopedEvent instance = (TenantScopedEvent) object;
        tenant(instance.getTenant());
      }
    }

    /**
     * Initializes the value for the {@link QuestionnaireActionsEvent#getTenant() tenant} attribute.
     * @param tenant The value for tenant 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tenant(Tenant tenant) {
      this.tenant = Objects.requireNonNull(tenant, "tenant");
      initBits &= ~INIT_BIT_TENANT;
      return this;
    }

    /**
     * Initializes the value for the {@link QuestionnaireActionsEvent#getQuestionnaireId() questionnaireId} attribute.
     * @param questionnaireId The value for questionnaireId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder questionnaireId(String questionnaireId) {
      this.questionnaireId = Objects.requireNonNull(questionnaireId, "questionnaireId");
      initBits &= ~INIT_BIT_QUESTIONNAIRE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link QuestionnaireActionsEvent#getActions() actions} attribute.
     * @param actions The value for actions 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder actions(Actions actions) {
      this.actions = Objects.requireNonNull(actions, "actions");
      initBits &= ~INIT_BIT_ACTIONS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableQuestionnaireActionsEvent ImmutableQuestionnaireActionsEvent}.
     * @return An immutable instance of QuestionnaireActionsEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQuestionnaireActionsEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableQuestionnaireActionsEvent(tenant, questionnaireId, actions);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TENANT) != 0) attributes.add("tenant");
      if ((initBits & INIT_BIT_QUESTIONNAIRE_ID) != 0) attributes.add("questionnaireId");
      if ((initBits & INIT_BIT_ACTIONS) != 0) attributes.add("actions");
      return "Cannot build QuestionnaireActionsEvent, some of required attributes are not set " + attributes;
    }
  }
}
