package io.dialob.questionnaire.service.api.event;

import io.dialob.integration.api.event.TenantScopedEvent;
import io.dialob.security.tenant.Tenant;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link QuestionnaireClientDisconnectedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQuestionnaireClientDisconnectedEvent.builder()}.
 */
@Generated(from = "QuestionnaireClientDisconnectedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableQuestionnaireClientDisconnectedEvent
    implements QuestionnaireClientDisconnectedEvent {
  private final Tenant tenant;
  private final String questionnaireId;
  private final InetAddress client;
  private final int closeStatus;

  private ImmutableQuestionnaireClientDisconnectedEvent(
      Tenant tenant,
      String questionnaireId,
      InetAddress client,
      int closeStatus) {
    this.tenant = tenant;
    this.questionnaireId = questionnaireId;
    this.client = client;
    this.closeStatus = closeStatus;
  }

  /**
   * @return The value of the {@code tenant} attribute
   */
  @Override
  public Tenant getTenant() {
    return tenant;
  }

  /**
   * @return questionnaire id of event
   */
  @Override
  public String getQuestionnaireId() {
    return questionnaireId;
  }

  /**
   * @return The value of the {@code client} attribute
   */
  @Override
  public InetAddress getClient() {
    return client;
  }

  /**
   * @return The value of the {@code closeStatus} attribute
   */
  @Override
  public int getCloseStatus() {
    return closeStatus;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireClientDisconnectedEvent#getTenant() tenant} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenant
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireClientDisconnectedEvent withTenant(Tenant value) {
    if (this.tenant == value) return this;
    Tenant newValue = Objects.requireNonNull(value, "tenant");
    return new ImmutableQuestionnaireClientDisconnectedEvent(newValue, this.questionnaireId, this.client, this.closeStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireClientDisconnectedEvent#getQuestionnaireId() questionnaireId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for questionnaireId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireClientDisconnectedEvent withQuestionnaireId(String value) {
    String newValue = Objects.requireNonNull(value, "questionnaireId");
    if (this.questionnaireId.equals(newValue)) return this;
    return new ImmutableQuestionnaireClientDisconnectedEvent(this.tenant, newValue, this.client, this.closeStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireClientDisconnectedEvent#getClient() client} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for client
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireClientDisconnectedEvent withClient(InetAddress value) {
    if (this.client == value) return this;
    InetAddress newValue = Objects.requireNonNull(value, "client");
    return new ImmutableQuestionnaireClientDisconnectedEvent(this.tenant, this.questionnaireId, newValue, this.closeStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireClientDisconnectedEvent#getCloseStatus() closeStatus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for closeStatus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireClientDisconnectedEvent withCloseStatus(int value) {
    if (this.closeStatus == value) return this;
    return new ImmutableQuestionnaireClientDisconnectedEvent(this.tenant, this.questionnaireId, this.client, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQuestionnaireClientDisconnectedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQuestionnaireClientDisconnectedEvent
        && equalTo((ImmutableQuestionnaireClientDisconnectedEvent) another);
  }

  private boolean equalTo(ImmutableQuestionnaireClientDisconnectedEvent another) {
    return tenant.equals(another.tenant)
        && questionnaireId.equals(another.questionnaireId)
        && client.equals(another.client)
        && closeStatus == another.closeStatus;
  }

  /**
   * Computes a hash code from attributes: {@code tenant}, {@code questionnaireId}, {@code client}, {@code closeStatus}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + tenant.hashCode();
    h += (h << 5) + questionnaireId.hashCode();
    h += (h << 5) + client.hashCode();
    h += (h << 5) + closeStatus;
    return h;
  }

  /**
   * Prints the immutable value {@code QuestionnaireClientDisconnectedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "QuestionnaireClientDisconnectedEvent{"
        + "tenant=" + tenant
        + ", questionnaireId=" + questionnaireId
        + ", client=" + client
        + ", closeStatus=" + closeStatus
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link QuestionnaireClientDisconnectedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable QuestionnaireClientDisconnectedEvent instance
   */
  public static ImmutableQuestionnaireClientDisconnectedEvent copyOf(QuestionnaireClientDisconnectedEvent instance) {
    if (instance instanceof ImmutableQuestionnaireClientDisconnectedEvent) {
      return (ImmutableQuestionnaireClientDisconnectedEvent) instance;
    }
    return ImmutableQuestionnaireClientDisconnectedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQuestionnaireClientDisconnectedEvent ImmutableQuestionnaireClientDisconnectedEvent}.
   * <pre>
   * ImmutableQuestionnaireClientDisconnectedEvent.builder()
   *    .tenant(io.dialob.security.tenant.Tenant) // required {@link QuestionnaireClientDisconnectedEvent#getTenant() tenant}
   *    .questionnaireId(String) // required {@link QuestionnaireClientDisconnectedEvent#getQuestionnaireId() questionnaireId}
   *    .client(java.net.InetAddress) // required {@link QuestionnaireClientDisconnectedEvent#getClient() client}
   *    .closeStatus(int) // required {@link QuestionnaireClientDisconnectedEvent#getCloseStatus() closeStatus}
   *    .build();
   * </pre>
   * @return A new ImmutableQuestionnaireClientDisconnectedEvent builder
   */
  public static ImmutableQuestionnaireClientDisconnectedEvent.Builder builder() {
    return new ImmutableQuestionnaireClientDisconnectedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQuestionnaireClientDisconnectedEvent ImmutableQuestionnaireClientDisconnectedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "QuestionnaireClientDisconnectedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TENANT = 0x1L;
    private static final long INIT_BIT_QUESTIONNAIRE_ID = 0x2L;
    private static final long INIT_BIT_CLIENT = 0x4L;
    private static final long INIT_BIT_CLOSE_STATUS = 0x8L;
    private long initBits = 0xfL;

    private @Nullable Tenant tenant;
    private @Nullable String questionnaireId;
    private @Nullable InetAddress client;
    private int closeStatus;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.questionnaire.service.api.event.QuestionnaireEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(QuestionnaireEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.integration.api.event.TenantScopedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantScopedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.questionnaire.service.api.event.QuestionnaireClientDisconnectedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(QuestionnaireClientDisconnectedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof QuestionnaireEvent) {
        QuestionnaireEvent instance = (QuestionnaireEvent) object;
        questionnaireId(instance.getQuestionnaireId());
      }
      if (object instanceof TenantScopedEvent) {
        TenantScopedEvent instance = (TenantScopedEvent) object;
        tenant(instance.getTenant());
      }
      if (object instanceof QuestionnaireClientDisconnectedEvent) {
        QuestionnaireClientDisconnectedEvent instance = (QuestionnaireClientDisconnectedEvent) object;
        client(instance.getClient());
        closeStatus(instance.getCloseStatus());
      }
    }

    /**
     * Initializes the value for the {@link QuestionnaireClientDisconnectedEvent#getTenant() tenant} attribute.
     * @param tenant The value for tenant 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tenant(Tenant tenant) {
      this.tenant = Objects.requireNonNull(tenant, "tenant");
      initBits &= ~INIT_BIT_TENANT;
      return this;
    }

    /**
     * Initializes the value for the {@link QuestionnaireClientDisconnectedEvent#getQuestionnaireId() questionnaireId} attribute.
     * @param questionnaireId The value for questionnaireId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder questionnaireId(String questionnaireId) {
      this.questionnaireId = Objects.requireNonNull(questionnaireId, "questionnaireId");
      initBits &= ~INIT_BIT_QUESTIONNAIRE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link QuestionnaireClientDisconnectedEvent#getClient() client} attribute.
     * @param client The value for client 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder client(InetAddress client) {
      this.client = Objects.requireNonNull(client, "client");
      initBits &= ~INIT_BIT_CLIENT;
      return this;
    }

    /**
     * Initializes the value for the {@link QuestionnaireClientDisconnectedEvent#getCloseStatus() closeStatus} attribute.
     * @param closeStatus The value for closeStatus 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder closeStatus(int closeStatus) {
      this.closeStatus = closeStatus;
      initBits &= ~INIT_BIT_CLOSE_STATUS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableQuestionnaireClientDisconnectedEvent ImmutableQuestionnaireClientDisconnectedEvent}.
     * @return An immutable instance of QuestionnaireClientDisconnectedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQuestionnaireClientDisconnectedEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableQuestionnaireClientDisconnectedEvent(tenant, questionnaireId, client, closeStatus);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TENANT) != 0) attributes.add("tenant");
      if ((initBits & INIT_BIT_QUESTIONNAIRE_ID) != 0) attributes.add("questionnaireId");
      if ((initBits & INIT_BIT_CLIENT) != 0) attributes.add("client");
      if ((initBits & INIT_BIT_CLOSE_STATUS) != 0) attributes.add("closeStatus");
      return "Cannot build QuestionnaireClientDisconnectedEvent, some of required attributes are not set " + attributes;
    }
  }
}
