package io.dialob.questionnaire.service.api.event;

import io.dialob.integration.api.event.TenantScopedEvent;
import io.dialob.security.tenant.Tenant;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link QuestionnaireClientConnectedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQuestionnaireClientConnectedEvent.builder()}.
 */
@Generated(from = "QuestionnaireClientConnectedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableQuestionnaireClientConnectedEvent
    implements QuestionnaireClientConnectedEvent {
  private final Tenant tenant;
  private final String questionnaireId;
  private final InetAddress client;

  private ImmutableQuestionnaireClientConnectedEvent(
      Tenant tenant,
      String questionnaireId,
      InetAddress client) {
    this.tenant = tenant;
    this.questionnaireId = questionnaireId;
    this.client = client;
  }

  /**
   * @return The value of the {@code tenant} attribute
   */
  @Override
  public Tenant getTenant() {
    return tenant;
  }

  /**
   * @return questionnaire id of event
   */
  @Override
  public String getQuestionnaireId() {
    return questionnaireId;
  }

  /**
   * @return The value of the {@code client} attribute
   */
  @Override
  public InetAddress getClient() {
    return client;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireClientConnectedEvent#getTenant() tenant} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenant
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireClientConnectedEvent withTenant(Tenant value) {
    if (this.tenant == value) return this;
    Tenant newValue = Objects.requireNonNull(value, "tenant");
    return new ImmutableQuestionnaireClientConnectedEvent(newValue, this.questionnaireId, this.client);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireClientConnectedEvent#getQuestionnaireId() questionnaireId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for questionnaireId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireClientConnectedEvent withQuestionnaireId(String value) {
    String newValue = Objects.requireNonNull(value, "questionnaireId");
    if (this.questionnaireId.equals(newValue)) return this;
    return new ImmutableQuestionnaireClientConnectedEvent(this.tenant, newValue, this.client);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireClientConnectedEvent#getClient() client} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for client
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireClientConnectedEvent withClient(InetAddress value) {
    if (this.client == value) return this;
    InetAddress newValue = Objects.requireNonNull(value, "client");
    return new ImmutableQuestionnaireClientConnectedEvent(this.tenant, this.questionnaireId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQuestionnaireClientConnectedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQuestionnaireClientConnectedEvent
        && equalTo((ImmutableQuestionnaireClientConnectedEvent) another);
  }

  private boolean equalTo(ImmutableQuestionnaireClientConnectedEvent another) {
    return tenant.equals(another.tenant)
        && questionnaireId.equals(another.questionnaireId)
        && client.equals(another.client);
  }

  /**
   * Computes a hash code from attributes: {@code tenant}, {@code questionnaireId}, {@code client}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + tenant.hashCode();
    h += (h << 5) + questionnaireId.hashCode();
    h += (h << 5) + client.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code QuestionnaireClientConnectedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "QuestionnaireClientConnectedEvent{"
        + "tenant=" + tenant
        + ", questionnaireId=" + questionnaireId
        + ", client=" + client
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link QuestionnaireClientConnectedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable QuestionnaireClientConnectedEvent instance
   */
  public static ImmutableQuestionnaireClientConnectedEvent copyOf(QuestionnaireClientConnectedEvent instance) {
    if (instance instanceof ImmutableQuestionnaireClientConnectedEvent) {
      return (ImmutableQuestionnaireClientConnectedEvent) instance;
    }
    return ImmutableQuestionnaireClientConnectedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQuestionnaireClientConnectedEvent ImmutableQuestionnaireClientConnectedEvent}.
   * <pre>
   * ImmutableQuestionnaireClientConnectedEvent.builder()
   *    .tenant(io.dialob.security.tenant.Tenant) // required {@link QuestionnaireClientConnectedEvent#getTenant() tenant}
   *    .questionnaireId(String) // required {@link QuestionnaireClientConnectedEvent#getQuestionnaireId() questionnaireId}
   *    .client(java.net.InetAddress) // required {@link QuestionnaireClientConnectedEvent#getClient() client}
   *    .build();
   * </pre>
   * @return A new ImmutableQuestionnaireClientConnectedEvent builder
   */
  public static ImmutableQuestionnaireClientConnectedEvent.Builder builder() {
    return new ImmutableQuestionnaireClientConnectedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQuestionnaireClientConnectedEvent ImmutableQuestionnaireClientConnectedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "QuestionnaireClientConnectedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TENANT = 0x1L;
    private static final long INIT_BIT_QUESTIONNAIRE_ID = 0x2L;
    private static final long INIT_BIT_CLIENT = 0x4L;
    private long initBits = 0x7L;

    private @Nullable Tenant tenant;
    private @Nullable String questionnaireId;
    private @Nullable InetAddress client;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.questionnaire.service.api.event.QuestionnaireClientConnectedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(QuestionnaireClientConnectedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.questionnaire.service.api.event.QuestionnaireEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(QuestionnaireEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.integration.api.event.TenantScopedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantScopedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof QuestionnaireClientConnectedEvent) {
        QuestionnaireClientConnectedEvent instance = (QuestionnaireClientConnectedEvent) object;
        client(instance.getClient());
      }
      if (object instanceof QuestionnaireEvent) {
        QuestionnaireEvent instance = (QuestionnaireEvent) object;
        questionnaireId(instance.getQuestionnaireId());
      }
      if (object instanceof TenantScopedEvent) {
        TenantScopedEvent instance = (TenantScopedEvent) object;
        tenant(instance.getTenant());
      }
    }

    /**
     * Initializes the value for the {@link QuestionnaireClientConnectedEvent#getTenant() tenant} attribute.
     * @param tenant The value for tenant 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tenant(Tenant tenant) {
      this.tenant = Objects.requireNonNull(tenant, "tenant");
      initBits &= ~INIT_BIT_TENANT;
      return this;
    }

    /**
     * Initializes the value for the {@link QuestionnaireClientConnectedEvent#getQuestionnaireId() questionnaireId} attribute.
     * @param questionnaireId The value for questionnaireId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder questionnaireId(String questionnaireId) {
      this.questionnaireId = Objects.requireNonNull(questionnaireId, "questionnaireId");
      initBits &= ~INIT_BIT_QUESTIONNAIRE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link QuestionnaireClientConnectedEvent#getClient() client} attribute.
     * @param client The value for client 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder client(InetAddress client) {
      this.client = Objects.requireNonNull(client, "client");
      initBits &= ~INIT_BIT_CLIENT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableQuestionnaireClientConnectedEvent ImmutableQuestionnaireClientConnectedEvent}.
     * @return An immutable instance of QuestionnaireClientConnectedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQuestionnaireClientConnectedEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableQuestionnaireClientConnectedEvent(tenant, questionnaireId, client);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TENANT) != 0) attributes.add("tenant");
      if ((initBits & INIT_BIT_QUESTIONNAIRE_ID) != 0) attributes.add("questionnaireId");
      if ((initBits & INIT_BIT_CLIENT) != 0) attributes.add("client");
      return "Cannot build QuestionnaireClientConnectedEvent, some of required attributes are not set " + attributes;
    }
  }
}
