/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service.api.session;

import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.questionnaire.service.api.QuestionnaireDatabase;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionBuilderFactory;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionService;
import io.dialob.security.tenant.CurrentTenant;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuestionnaireSessionService
implements QuestionnaireSessionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractQuestionnaireSessionService.class);
    private final QuestionnaireDatabase questionnaireDatabase;
    private final QuestionnaireSessionBuilderFactory questionnaireSessionBuilderFactory;
    private final CurrentTenant currentTenant;

    protected AbstractQuestionnaireSessionService(@Nonnull QuestionnaireDatabase questionnaireDatabase, @Nonnull QuestionnaireSessionBuilderFactory questionnaireSessionBuilderFactory, CurrentTenant currentTenant) {
        this.questionnaireDatabase = questionnaireDatabase;
        this.questionnaireSessionBuilderFactory = questionnaireSessionBuilderFactory;
        this.currentTenant = currentTenant;
    }

    protected QuestionnaireSession restore(String questionnaireDocumentId) {
        return this.restore(this.questionnaireDatabase.findOne(this.currentTenant.getId(), questionnaireDocumentId));
    }

    protected QuestionnaireSession restore(Questionnaire questionnaire) {
        return this.questionnaireSessionBuilderFactory.createQuestionnaireSessionBuilder().setQuestionnaire(questionnaire).build();
    }

    @Override
    public QuestionnaireSession findOne(@Nonnull String questionnaireId, boolean openIfClosed) {
        if (openIfClosed) {
            return this.restore(questionnaireId);
        }
        return null;
    }
}

