/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service.api.test;

import io.dialob.api.proto.Action;
import io.dialob.api.proto.Actions;
import io.dialob.api.proto.ImmutableAction;
import io.dialob.api.proto.ImmutableActions;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.integration.api.event.Event;
import io.dialob.integration.api.event.EventPublisher;
import io.dialob.questionnaire.service.api.FormActions;
import io.dialob.questionnaire.service.api.FormActionsUpdatesCallback;
import io.dialob.questionnaire.service.api.event.QuestionnaireActionsEvent;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionBuilder;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Provider;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;

public class FillAssertionBuilder {
    int expectedEventCount = 1;
    boolean expectCreated = true;
    private List<ValidationEntry> validationEntries = new ArrayList<ValidationEntry>();
    private QuestionnaireSessionService questionnaireSessionService;
    private Provider<QuestionnaireSessionBuilder> questionnaireSessionBuilderFactory;
    private String formId;
    private Questionnaire questionnaire;
    private EventPublisher questionnaireSessionEventPublisher;

    public FillAssertionBuilder(QuestionnaireSessionService questionnaireSessionService, EventPublisher questionnaireSessionEventPublisher, String formId) {
        this.questionnaireSessionService = questionnaireSessionService;
        this.questionnaireSessionEventPublisher = questionnaireSessionEventPublisher;
        this.formId = formId;
    }

    public FillAssertionBuilder(QuestionnaireSessionService questionnaireSessionService, EventPublisher questionnaireSessionEventPublisher, Questionnaire questionnaire) {
        this.questionnaireSessionService = questionnaireSessionService;
        this.questionnaireSessionEventPublisher = questionnaireSessionEventPublisher;
        this.questionnaire = questionnaire;
        if (this.questionnaire.getMetadata().getStatus() == Questionnaire.Metadata.Status.OPEN) {
            --this.expectedEventCount;
            this.expectCreated = false;
        }
    }

    public FillAssertionBuilder assertState(Consumer<AbstractListAssert<?, ? extends List<? extends Action>, Action, ? extends AbstractAssert<?, Action>>> consumer) {
        ValidationEntry validationEntry = new ValidationEntry();
        validationEntry.assertter = consumer;
        this.validationEntries.add(validationEntry);
        return this;
    }

    public FillAssertionBuilder answer(String questionId, Object answer) {
        ImmutableAction action = ImmutableAction.builder().type(Action.Type.ANSWER).id(questionId).answer(answer).build();
        ValidationEntry validationEntry = new ValidationEntry();
        validationEntry.action = action;
        this.validationEntries.add(validationEntry);
        ++this.expectedEventCount;
        return this;
    }

    public FillAssertionBuilder nextPage() {
        ImmutableAction action = ImmutableAction.builder().type(Action.Type.NEXT).build();
        ValidationEntry validationEntry = new ValidationEntry();
        validationEntry.action = action;
        this.validationEntries.add(validationEntry);
        ++this.expectedEventCount;
        return this;
    }

    public FillAssertionBuilder previousPage() {
        ImmutableAction action = ImmutableAction.builder().type(Action.Type.PREVIOUS).build();
        ValidationEntry validationEntry = new ValidationEntry();
        validationEntry.action = action;
        this.validationEntries.add(validationEntry);
        ++this.expectedEventCount;
        return this;
    }

    public FillAssertionBuilder complete() {
        ImmutableAction action = ImmutableAction.builder().type(Action.Type.COMPLETE).build();
        ValidationEntry validationEntry = new ValidationEntry();
        validationEntry.action = action;
        this.validationEntries.add(validationEntry);
        this.expectedEventCount += 2;
        return this;
    }

    public FillAssertionBuilder assertThat(Consumer<AbstractListAssert<?, ? extends List<? extends Action>, Action, ? extends AbstractAssert<?, Action>>> consumer) {
        this.validationEntries.get((int)(this.validationEntries.size() - 1)).assertter = consumer;
        return this;
    }

    public void apply() {
        this.apply(true);
    }

    public void apply(boolean verify) {
        QuestionnaireSessionBuilder questionnaireSessionBuilder = (QuestionnaireSessionBuilder)this.questionnaireSessionBuilderFactory.get();
        if (this.questionnaire != null) {
            questionnaireSessionBuilder = questionnaireSessionBuilder.setQuestionnaire(this.questionnaire);
        } else if (this.formId != null) {
            questionnaireSessionBuilder = questionnaireSessionBuilder.setFormId(this.formId);
        } else {
            org.junit.jupiter.api.Assertions.fail((String)"define formId or questionnaire");
        }
        QuestionnaireSession session = questionnaireSessionBuilder.build();
        for (ValidationEntry validationEntry : this.validationEntries) {
            if (validationEntry.action != null) {
                validationEntry.actions = session.dispatchActions(session.getRevision(), Arrays.asList(validationEntry.action)).getActions();
                continue;
            }
            FormActions formActions = new FormActions();
            session.buildFullForm((QuestionnaireSession.UpdatesCallback)new FormActionsUpdatesCallback(formActions));
            validationEntry.actions = ImmutableActions.builder().actions((Iterable)formActions.getActions()).build();
        }
        session.close();
        if (verify) {
            ArgumentCaptor questionnaireActionsEventsCaptor = ArgumentCaptor.forClass(QuestionnaireActionsEvent.class);
            ((EventPublisher)Mockito.verify((Object)this.questionnaireSessionEventPublisher, (VerificationMode)VerificationModeFactory.times((int)this.expectedEventCount))).publish((Event)questionnaireActionsEventsCaptor.capture());
            this.assertEvents(questionnaireActionsEventsCaptor.getAllValues());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.questionnaireSessionEventPublisher});
        }
    }

    public void assertEvents(List<QuestionnaireActionsEvent> events) {
        Iterator<ValidationEntry> ai = this.validationEntries.iterator();
        while (ai.hasNext()) {
            ValidationEntry validationEntry = ai.next();
            validationEntry.assertter.accept((AbstractListAssert<?, List<Action>, Action, AbstractAssert<?, Action>>)Assertions.assertThat((List)validationEntry.actions.getActions()));
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ai.hasNext());
    }

    static class ValidationEntry {
        Action action;
        Consumer<AbstractListAssert<?, ? extends List<? extends Action>, Action, ? extends AbstractAssert<?, Action>>> assertter;
        public Actions actions;

        ValidationEntry() {
        }
    }
}

