/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.integration.redis;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.GenericMessage;

public class JsonMessageConverter<T>
implements MessageConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonMessageConverter.class);
    private final ObjectMapper mapper;
    private final Class<T> type;

    public JsonMessageConverter(ObjectMapper mapper, Class<T> type) {
        this.mapper = mapper;
        this.type = type;
    }

    public Object fromMessage(@NonNull Message<?> message, @NonNull Class<?> targetClass) {
        try {
            return this.mapper.writeValueAsString(message.getPayload());
        }
        catch (JsonProcessingException e) {
            LOGGER.debug("Could not parse message payload. Ignoring message ", (Throwable)e);
            return null;
        }
    }

    public Message<?> toMessage(@NonNull Object payload, MessageHeaders headers) {
        try {
            return new GenericMessage(this.mapper.readValue((String)payload, this.type));
        }
        catch (IOException e) {
            LOGGER.debug("Could not create message. Skipping message.", (Throwable)e);
            return null;
        }
    }
}

