/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.integration.queue;

import io.dialob.integration.api.ImmutableNodeId;
import io.dialob.integration.api.NodeId;
import io.dialob.integration.queue.redis.DistributedEventBridge;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.messaging.MessageChannel;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(name={"io.dialob.integration.redis.DialobIntegrationRedisAutoConfiguration"})
public class DialobIntegrationQueueAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobIntegrationQueueAutoConfiguration.class);

    @Bean
    public NodeId nodeId(ServerProperties serverProperties) throws UnknownHostException {
        String host = InetAddress.getLocalHost().getHostName();
        ImmutableNodeId nodeId = ImmutableNodeId.builder().id(UUID.randomUUID().toString()).host(host).port(serverProperties.getPort().intValue()).build();
        LOGGER.info("Created node : {}", (Object)nodeId);
        return nodeId;
    }

    @Bean
    @ConditionalOnBean(name={"dialobEventsDistributionChannel"})
    public DistributedEventBridge distributedEventBridge(@Named(value="dialobEventsDistributionChannel") MessageChannel messageChannel, ApplicationEventPublisher publisher, MessageBuilderFactory messageBuilderFactory, NodeId nodeId) {
        return new DistributedEventBridge(messageChannel, publisher, messageBuilderFactory, nodeId);
    }
}

