/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.integration.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.integration.api.NodeId;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="NodeId", generator="Immutables")
@Immutable
public final class ImmutableNodeId
implements NodeId {
    private final String id;
    private final String host;
    private final int port;

    private ImmutableNodeId(String id, String host, int port) {
        this.id = id;
        this.host = host;
        this.port = port;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    @Override
    @JsonProperty(value="port")
    public int getPort() {
        return this.port;
    }

    public final ImmutableNodeId withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableNodeId(newValue, this.host, this.port);
    }

    public final ImmutableNodeId withHost(String value) {
        String newValue = Objects.requireNonNull(value, "host");
        if (this.host.equals(newValue)) {
            return this;
        }
        return new ImmutableNodeId(this.id, newValue, this.port);
    }

    public final ImmutableNodeId withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableNodeId(this.id, this.host, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeId && this.equalTo((ImmutableNodeId)another);
    }

    private boolean equalTo(ImmutableNodeId another) {
        return this.id.equals(another.id) && this.host.equals(another.host) && this.port == another.port;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.host.hashCode();
        h += (h << 5) + this.port;
        return h;
    }

    public String toString() {
        return "NodeId{id=" + this.id + ", host=" + this.host + ", port=" + this.port + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNodeId fromJson(Json json) {
        Builder builder = ImmutableNodeId.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.host != null) {
            builder.host(json.host);
        }
        if (json.portIsSet) {
            builder.port(json.port);
        }
        return builder.build();
    }

    public static ImmutableNodeId copyOf(NodeId instance) {
        if (instance instanceof ImmutableNodeId) {
            return (ImmutableNodeId)instance;
        }
        return ImmutableNodeId.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NodeId", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_HOST = 2L;
        private static final long INIT_BIT_PORT = 4L;
        private long initBits = 7L;
        @Nullable
        private String id;
        @Nullable
        private String host;
        private int port;

        private Builder() {
        }

        public final Builder from(NodeId instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.host(instance.getHost());
            this.port(instance.getPort());
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="host")
        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="port")
        public final Builder port(int port) {
            this.port = port;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableNodeId build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeId(this.id, this.host, this.port);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("host");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("port");
            }
            return "Cannot build NodeId, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NodeId", generator="Immutables")
    static final class Json
    implements NodeId {
        @Nullable
        String id;
        @Nullable
        String host;
        int port;
        boolean portIsSet;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="host")
        public void setHost(String host) {
            this.host = host;
        }

        @JsonProperty(value="port")
        public void setPort(int port) {
            this.port = port;
            this.portIsSet = true;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPort() {
            throw new UnsupportedOperationException();
        }
    }
}

