/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.integration.api.event;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.integration.api.event.DistributedEvent;
import io.dialob.integration.api.event.Event;
import io.dialob.integration.api.event.FormEvent;
import io.dialob.integration.api.event.FormUpdatedEvent;
import io.dialob.integration.api.event.TenantScopedEvent;
import io.dialob.security.tenant.Tenant;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FormUpdatedEvent", generator="Immutables")
@Immutable
public final class ImmutableFormUpdatedEvent
implements FormUpdatedEvent {
    private final Tenant tenant;
    private final String formId;
    private final String source;
    private final String revision;

    private ImmutableFormUpdatedEvent(Tenant tenant, String formId, String source, String revision) {
        this.tenant = tenant;
        this.formId = formId;
        this.source = source;
        this.revision = revision;
    }

    @Override
    @JsonProperty(value="tenant")
    public Tenant getTenant() {
        return this.tenant;
    }

    @Override
    @JsonProperty(value="formId")
    public String getFormId() {
        return this.formId;
    }

    @Override
    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @Override
    @JsonProperty(value="revision")
    public String getRevision() {
        return this.revision;
    }

    public final ImmutableFormUpdatedEvent withTenant(Tenant value) {
        if (this.tenant == value) {
            return this;
        }
        Tenant newValue = Objects.requireNonNull(value, "tenant");
        return new ImmutableFormUpdatedEvent(newValue, this.formId, this.source, this.revision);
    }

    public final ImmutableFormUpdatedEvent withFormId(String value) {
        String newValue = Objects.requireNonNull(value, "formId");
        if (this.formId.equals(newValue)) {
            return this;
        }
        return new ImmutableFormUpdatedEvent(this.tenant, newValue, this.source, this.revision);
    }

    public final ImmutableFormUpdatedEvent withSource(String value) {
        String newValue = Objects.requireNonNull(value, "source");
        if (this.source.equals(newValue)) {
            return this;
        }
        return new ImmutableFormUpdatedEvent(this.tenant, this.formId, newValue, this.revision);
    }

    public final ImmutableFormUpdatedEvent withRevision(String value) {
        String newValue = Objects.requireNonNull(value, "revision");
        if (this.revision.equals(newValue)) {
            return this;
        }
        return new ImmutableFormUpdatedEvent(this.tenant, this.formId, this.source, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormUpdatedEvent && this.equalTo((ImmutableFormUpdatedEvent)another);
    }

    private boolean equalTo(ImmutableFormUpdatedEvent another) {
        return this.tenant.equals(another.tenant) && this.formId.equals(another.formId) && this.source.equals(another.source) && this.revision.equals(another.revision);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.tenant.hashCode();
        h += (h << 5) + this.formId.hashCode();
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.revision.hashCode();
        return h;
    }

    public String toString() {
        return "FormUpdatedEvent{tenant=" + this.tenant + ", formId=" + this.formId + ", source=" + this.source + ", revision=" + this.revision + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFormUpdatedEvent fromJson(Json json) {
        Builder builder = ImmutableFormUpdatedEvent.builder();
        if (json.tenant != null) {
            builder.tenant(json.tenant);
        }
        if (json.formId != null) {
            builder.formId(json.formId);
        }
        if (json.source != null) {
            builder.source(json.source);
        }
        if (json.revision != null) {
            builder.revision(json.revision);
        }
        return builder.build();
    }

    public static ImmutableFormUpdatedEvent copyOf(FormUpdatedEvent instance) {
        if (instance instanceof ImmutableFormUpdatedEvent) {
            return (ImmutableFormUpdatedEvent)instance;
        }
        return ImmutableFormUpdatedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FormUpdatedEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TENANT = 1L;
        private static final long INIT_BIT_FORM_ID = 2L;
        private static final long INIT_BIT_SOURCE = 4L;
        private static final long INIT_BIT_REVISION = 8L;
        private long initBits = 15L;
        @Nullable
        private Tenant tenant;
        @Nullable
        private String formId;
        @Nullable
        private String source;
        @Nullable
        private String revision;

        private Builder() {
        }

        public final Builder from(DistributedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TenantScopedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FormUpdatedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FormEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Event instance;
            if (object instanceof DistributedEvent) {
                instance = (DistributedEvent)object;
                this.source(instance.getSource());
            }
            if (object instanceof TenantScopedEvent) {
                instance = (TenantScopedEvent)object;
                this.tenant(instance.getTenant());
            }
            if (object instanceof FormUpdatedEvent) {
                instance = (FormUpdatedEvent)object;
                this.revision(instance.getRevision());
            }
            if (object instanceof FormEvent) {
                instance = (FormEvent)object;
                this.formId(instance.getFormId());
            }
        }

        @JsonProperty(value="tenant")
        public final Builder tenant(Tenant tenant) {
            this.tenant = Objects.requireNonNull(tenant, "tenant");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="formId")
        public final Builder formId(String formId) {
            this.formId = Objects.requireNonNull(formId, "formId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="source")
        public final Builder source(String source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="revision")
        public final Builder revision(String revision) {
            this.revision = Objects.requireNonNull(revision, "revision");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableFormUpdatedEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFormUpdatedEvent(this.tenant, this.formId, this.source, this.revision);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tenant");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("formId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("source");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("revision");
            }
            return "Cannot build FormUpdatedEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FormUpdatedEvent", generator="Immutables")
    static final class Json
    implements FormUpdatedEvent {
        @Nullable
        Tenant tenant;
        @Nullable
        String formId;
        @Nullable
        String source;
        @Nullable
        String revision;

        Json() {
        }

        @JsonProperty(value="tenant")
        public void setTenant(Tenant tenant) {
            this.tenant = tenant;
        }

        @JsonProperty(value="formId")
        public void setFormId(String formId) {
            this.formId = formId;
        }

        @JsonProperty(value="source")
        public void setSource(String source) {
            this.source = source;
        }

        @JsonProperty(value="revision")
        public void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public Tenant getTenant() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getFormId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRevision() {
            throw new UnsupportedOperationException();
        }
    }
}

