package io.dialob.integration.api.event;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.security.tenant.Tenant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FormTaggedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormTaggedEvent.builder()}.
 */
@Generated(from = "FormTaggedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableFormTaggedEvent implements FormTaggedEvent {
  private final Tenant tenant;
  private final String formId;
  private final String source;
  private final String formName;
  private final String tagName;
  private final @Nullable String refName;

  private ImmutableFormTaggedEvent(
      Tenant tenant,
      String formId,
      String source,
      String formName,
      String tagName,
      @Nullable String refName) {
    this.tenant = tenant;
    this.formId = formId;
    this.source = source;
    this.formName = formName;
    this.tagName = tagName;
    this.refName = refName;
  }

  /**
   * @return The value of the {@code tenant} attribute
   */
  @JsonProperty("tenant")
  @Override
  public Tenant getTenant() {
    return tenant;
  }

  /**
   * @return The value of the {@code formId} attribute
   */
  @JsonProperty("formId")
  @Override
  public String getFormId() {
    return formId;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @JsonProperty("source")
  @Override
  public String getSource() {
    return source;
  }

  /**
   * @return The value of the {@code formName} attribute
   */
  @JsonProperty("formName")
  @Override
  public String getFormName() {
    return formName;
  }

  /**
   * @return The value of the {@code tagName} attribute
   */
  @JsonProperty("tagName")
  @Override
  public String getTagName() {
    return tagName;
  }

  /**
   * @return The value of the {@code refName} attribute
   */
  @JsonProperty("refName")
  @Override
  public @Nullable String getRefName() {
    return refName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormTaggedEvent#getTenant() tenant} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenant
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormTaggedEvent withTenant(Tenant value) {
    if (this.tenant == value) return this;
    Tenant newValue = Objects.requireNonNull(value, "tenant");
    return new ImmutableFormTaggedEvent(newValue, this.formId, this.source, this.formName, this.tagName, this.refName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormTaggedEvent#getFormId() formId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormTaggedEvent withFormId(String value) {
    String newValue = Objects.requireNonNull(value, "formId");
    if (this.formId.equals(newValue)) return this;
    return new ImmutableFormTaggedEvent(this.tenant, newValue, this.source, this.formName, this.tagName, this.refName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormTaggedEvent#getSource() source} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormTaggedEvent withSource(String value) {
    String newValue = Objects.requireNonNull(value, "source");
    if (this.source.equals(newValue)) return this;
    return new ImmutableFormTaggedEvent(this.tenant, this.formId, newValue, this.formName, this.tagName, this.refName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormTaggedEvent#getFormName() formName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormTaggedEvent withFormName(String value) {
    String newValue = Objects.requireNonNull(value, "formName");
    if (this.formName.equals(newValue)) return this;
    return new ImmutableFormTaggedEvent(this.tenant, this.formId, this.source, newValue, this.tagName, this.refName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormTaggedEvent#getTagName() tagName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tagName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormTaggedEvent withTagName(String value) {
    String newValue = Objects.requireNonNull(value, "tagName");
    if (this.tagName.equals(newValue)) return this;
    return new ImmutableFormTaggedEvent(this.tenant, this.formId, this.source, this.formName, newValue, this.refName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormTaggedEvent#getRefName() refName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for refName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormTaggedEvent withRefName(@Nullable String value) {
    if (Objects.equals(this.refName, value)) return this;
    return new ImmutableFormTaggedEvent(this.tenant, this.formId, this.source, this.formName, this.tagName, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormTaggedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormTaggedEvent
        && equalTo((ImmutableFormTaggedEvent) another);
  }

  private boolean equalTo(ImmutableFormTaggedEvent another) {
    return tenant.equals(another.tenant)
        && formId.equals(another.formId)
        && source.equals(another.source)
        && formName.equals(another.formName)
        && tagName.equals(another.tagName)
        && Objects.equals(refName, another.refName);
  }

  /**
   * Computes a hash code from attributes: {@code tenant}, {@code formId}, {@code source}, {@code formName}, {@code tagName}, {@code refName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + tenant.hashCode();
    h += (h << 5) + formId.hashCode();
    h += (h << 5) + source.hashCode();
    h += (h << 5) + formName.hashCode();
    h += (h << 5) + tagName.hashCode();
    h += (h << 5) + Objects.hashCode(refName);
    return h;
  }

  /**
   * Prints the immutable value {@code FormTaggedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FormTaggedEvent{"
        + "tenant=" + tenant
        + ", formId=" + formId
        + ", source=" + source
        + ", formName=" + formName
        + ", tagName=" + tagName
        + ", refName=" + refName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "FormTaggedEvent", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FormTaggedEvent {
    @Nullable Tenant tenant;
    @Nullable String formId;
    @Nullable String source;
    @Nullable String formName;
    @Nullable String tagName;
    @Nullable String refName;
    @JsonProperty("tenant")
    public void setTenant(Tenant tenant) {
      this.tenant = tenant;
    }
    @JsonProperty("formId")
    public void setFormId(String formId) {
      this.formId = formId;
    }
    @JsonProperty("source")
    public void setSource(String source) {
      this.source = source;
    }
    @JsonProperty("formName")
    public void setFormName(String formName) {
      this.formName = formName;
    }
    @JsonProperty("tagName")
    public void setTagName(String tagName) {
      this.tagName = tagName;
    }
    @JsonProperty("refName")
    public void setRefName(@Nullable String refName) {
      this.refName = refName;
    }
    @Override
    public Tenant getTenant() { throw new UnsupportedOperationException(); }
    @Override
    public String getFormId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSource() { throw new UnsupportedOperationException(); }
    @Override
    public String getFormName() { throw new UnsupportedOperationException(); }
    @Override
    public String getTagName() { throw new UnsupportedOperationException(); }
    @Override
    public String getRefName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormTaggedEvent fromJson(Json json) {
    ImmutableFormTaggedEvent.Builder builder = ImmutableFormTaggedEvent.builder();
    if (json.tenant != null) {
      builder.tenant(json.tenant);
    }
    if (json.formId != null) {
      builder.formId(json.formId);
    }
    if (json.source != null) {
      builder.source(json.source);
    }
    if (json.formName != null) {
      builder.formName(json.formName);
    }
    if (json.tagName != null) {
      builder.tagName(json.tagName);
    }
    if (json.refName != null) {
      builder.refName(json.refName);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FormTaggedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormTaggedEvent instance
   */
  public static ImmutableFormTaggedEvent copyOf(FormTaggedEvent instance) {
    if (instance instanceof ImmutableFormTaggedEvent) {
      return (ImmutableFormTaggedEvent) instance;
    }
    return ImmutableFormTaggedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormTaggedEvent ImmutableFormTaggedEvent}.
   * <pre>
   * ImmutableFormTaggedEvent.builder()
   *    .tenant(io.dialob.security.tenant.Tenant) // required {@link FormTaggedEvent#getTenant() tenant}
   *    .formId(String) // required {@link FormTaggedEvent#getFormId() formId}
   *    .source(String) // required {@link FormTaggedEvent#getSource() source}
   *    .formName(String) // required {@link FormTaggedEvent#getFormName() formName}
   *    .tagName(String) // required {@link FormTaggedEvent#getTagName() tagName}
   *    .refName(String | null) // nullable {@link FormTaggedEvent#getRefName() refName}
   *    .build();
   * </pre>
   * @return A new ImmutableFormTaggedEvent builder
   */
  public static ImmutableFormTaggedEvent.Builder builder() {
    return new ImmutableFormTaggedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormTaggedEvent ImmutableFormTaggedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FormTaggedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TENANT = 0x1L;
    private static final long INIT_BIT_FORM_ID = 0x2L;
    private static final long INIT_BIT_SOURCE = 0x4L;
    private static final long INIT_BIT_FORM_NAME = 0x8L;
    private static final long INIT_BIT_TAG_NAME = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable Tenant tenant;
    private @Nullable String formId;
    private @Nullable String source;
    private @Nullable String formName;
    private @Nullable String tagName;
    private @Nullable String refName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.integration.api.event.DistributedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DistributedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.integration.api.event.TenantScopedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantScopedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.integration.api.event.FormEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FormEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.integration.api.event.FormTaggedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FormTaggedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof DistributedEvent) {
        DistributedEvent instance = (DistributedEvent) object;
        source(instance.getSource());
      }
      if (object instanceof TenantScopedEvent) {
        TenantScopedEvent instance = (TenantScopedEvent) object;
        tenant(instance.getTenant());
      }
      if (object instanceof FormEvent) {
        FormEvent instance = (FormEvent) object;
        formId(instance.getFormId());
      }
      if (object instanceof FormTaggedEvent) {
        FormTaggedEvent instance = (FormTaggedEvent) object;
        tagName(instance.getTagName());
        @Nullable String refNameValue = instance.getRefName();
        if (refNameValue != null) {
          refName(refNameValue);
        }
        formName(instance.getFormName());
      }
    }

    /**
     * Initializes the value for the {@link FormTaggedEvent#getTenant() tenant} attribute.
     * @param tenant The value for tenant 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tenant")
    public final Builder tenant(Tenant tenant) {
      this.tenant = Objects.requireNonNull(tenant, "tenant");
      initBits &= ~INIT_BIT_TENANT;
      return this;
    }

    /**
     * Initializes the value for the {@link FormTaggedEvent#getFormId() formId} attribute.
     * @param formId The value for formId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("formId")
    public final Builder formId(String formId) {
      this.formId = Objects.requireNonNull(formId, "formId");
      initBits &= ~INIT_BIT_FORM_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link FormTaggedEvent#getSource() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("source")
    public final Builder source(String source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link FormTaggedEvent#getFormName() formName} attribute.
     * @param formName The value for formName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("formName")
    public final Builder formName(String formName) {
      this.formName = Objects.requireNonNull(formName, "formName");
      initBits &= ~INIT_BIT_FORM_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link FormTaggedEvent#getTagName() tagName} attribute.
     * @param tagName The value for tagName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tagName")
    public final Builder tagName(String tagName) {
      this.tagName = Objects.requireNonNull(tagName, "tagName");
      initBits &= ~INIT_BIT_TAG_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link FormTaggedEvent#getRefName() refName} attribute.
     * @param refName The value for refName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("refName")
    public final Builder refName(@Nullable String refName) {
      this.refName = refName;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormTaggedEvent ImmutableFormTaggedEvent}.
     * @return An immutable instance of FormTaggedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormTaggedEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFormTaggedEvent(tenant, formId, source, formName, tagName, refName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TENANT) != 0) attributes.add("tenant");
      if ((initBits & INIT_BIT_FORM_ID) != 0) attributes.add("formId");
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      if ((initBits & INIT_BIT_FORM_NAME) != 0) attributes.add("formName");
      if ((initBits & INIT_BIT_TAG_NAME) != 0) attributes.add("tagName");
      return "Cannot build FormTaggedEvent, some of required attributes are not set " + attributes;
    }
  }
}
