/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.integration.api.event;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.integration.api.event.DistributedEvent;
import io.dialob.integration.api.event.Event;
import io.dialob.integration.api.event.FormDeletedEvent;
import io.dialob.integration.api.event.FormEvent;
import io.dialob.integration.api.event.TenantScopedEvent;
import io.dialob.security.tenant.Tenant;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FormDeletedEvent", generator="Immutables")
@Immutable
public final class ImmutableFormDeletedEvent
implements FormDeletedEvent {
    private final Tenant tenant;
    private final String formId;
    private final String source;

    private ImmutableFormDeletedEvent(Tenant tenant, String formId, String source) {
        this.tenant = tenant;
        this.formId = formId;
        this.source = source;
    }

    @Override
    @JsonProperty(value="tenant")
    public Tenant getTenant() {
        return this.tenant;
    }

    @Override
    @JsonProperty(value="formId")
    public String getFormId() {
        return this.formId;
    }

    @Override
    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    public final ImmutableFormDeletedEvent withTenant(Tenant value) {
        if (this.tenant == value) {
            return this;
        }
        Tenant newValue = Objects.requireNonNull(value, "tenant");
        return new ImmutableFormDeletedEvent(newValue, this.formId, this.source);
    }

    public final ImmutableFormDeletedEvent withFormId(String value) {
        String newValue = Objects.requireNonNull(value, "formId");
        if (this.formId.equals(newValue)) {
            return this;
        }
        return new ImmutableFormDeletedEvent(this.tenant, newValue, this.source);
    }

    public final ImmutableFormDeletedEvent withSource(String value) {
        String newValue = Objects.requireNonNull(value, "source");
        if (this.source.equals(newValue)) {
            return this;
        }
        return new ImmutableFormDeletedEvent(this.tenant, this.formId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormDeletedEvent && this.equalTo((ImmutableFormDeletedEvent)another);
    }

    private boolean equalTo(ImmutableFormDeletedEvent another) {
        return this.tenant.equals(another.tenant) && this.formId.equals(another.formId) && this.source.equals(another.source);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.tenant.hashCode();
        h += (h << 5) + this.formId.hashCode();
        h += (h << 5) + this.source.hashCode();
        return h;
    }

    public String toString() {
        return "FormDeletedEvent{tenant=" + this.tenant + ", formId=" + this.formId + ", source=" + this.source + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFormDeletedEvent fromJson(Json json) {
        Builder builder = ImmutableFormDeletedEvent.builder();
        if (json.tenant != null) {
            builder.tenant(json.tenant);
        }
        if (json.formId != null) {
            builder.formId(json.formId);
        }
        if (json.source != null) {
            builder.source(json.source);
        }
        return builder.build();
    }

    public static ImmutableFormDeletedEvent copyOf(FormDeletedEvent instance) {
        if (instance instanceof ImmutableFormDeletedEvent) {
            return (ImmutableFormDeletedEvent)instance;
        }
        return ImmutableFormDeletedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FormDeletedEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TENANT = 1L;
        private static final long INIT_BIT_FORM_ID = 2L;
        private static final long INIT_BIT_SOURCE = 4L;
        private long initBits = 7L;
        @Nullable
        private Tenant tenant;
        @Nullable
        private String formId;
        @Nullable
        private String source;

        private Builder() {
        }

        public final Builder from(DistributedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TenantScopedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FormEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FormDeletedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Event instance;
            if (object instanceof DistributedEvent) {
                instance = (DistributedEvent)object;
                this.source(instance.getSource());
            }
            if (object instanceof TenantScopedEvent) {
                instance = (TenantScopedEvent)object;
                this.tenant(instance.getTenant());
            }
            if (object instanceof FormEvent) {
                instance = (FormEvent)object;
                this.formId(instance.getFormId());
            }
        }

        @JsonProperty(value="tenant")
        public final Builder tenant(Tenant tenant) {
            this.tenant = Objects.requireNonNull(tenant, "tenant");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="formId")
        public final Builder formId(String formId) {
            this.formId = Objects.requireNonNull(formId, "formId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="source")
        public final Builder source(String source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableFormDeletedEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFormDeletedEvent(this.tenant, this.formId, this.source);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tenant");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("formId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("source");
            }
            return "Cannot build FormDeletedEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FormDeletedEvent", generator="Immutables")
    static final class Json
    implements FormDeletedEvent {
        @Nullable
        Tenant tenant;
        @Nullable
        String formId;
        @Nullable
        String source;

        Json() {
        }

        @JsonProperty(value="tenant")
        public void setTenant(Tenant tenant) {
            this.tenant = tenant;
        }

        @JsonProperty(value="formId")
        public void setFormId(String formId) {
            this.formId = formId;
        }

        @JsonProperty(value="source")
        public void setSource(String source) {
            this.source = source;
        }

        @Override
        public Tenant getTenant() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getFormId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSource() {
            throw new UnsupportedOperationException();
        }
    }
}

