/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.groovy;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import io.dialob.groovy.DialobDDRLFunction;
import io.dialob.rule.parser.function.FunctionRegistry;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;

public class GroovyFunctionRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyFunctionRegistry.class);
    private final FunctionRegistry functionRegistry;
    private List<String> groovyFunctions = new ArrayList<String>();
    private final GroovyClassLoader groovyClassLoader;
    private final ApplicationContext applicationContext;
    private String codePackage = "io.dialob.groovy";

    public GroovyFunctionRegistry(ApplicationContext applicationContext, FunctionRegistry functionRegistry) {
        this(applicationContext, functionRegistry, Thread.currentThread().getContextClassLoader());
    }

    public GroovyFunctionRegistry(ApplicationContext applicationContext, FunctionRegistry functionRegistry, ClassLoader classLoader) {
        this(applicationContext, functionRegistry, new GroovyClassLoader(classLoader));
    }

    public GroovyFunctionRegistry(ApplicationContext applicationContext, FunctionRegistry functionRegistry, GroovyClassLoader groovyClassLoader) {
        this.applicationContext = applicationContext;
        this.functionRegistry = functionRegistry;
        this.groovyClassLoader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public void setGroovyFunctions(List<String> groovyFunctions) {
        this.groovyFunctions = groovyFunctions;
    }

    private void compileScript(@NonNull Resource resource, String codePackage) {
        LOGGER.info("Compiling groovy resource {}", (Object)resource);
        try {
            String externalForm = resource.getURL().toExternalForm();
            LOGGER.debug("Resource location: {}", (Object)externalForm);
            GroovyCodeSource codeSource = new GroovyCodeSource((Reader)new InputStreamReader(resource.getInputStream()), externalForm, codePackage);
            Class groovyClass = this.groovyClassLoader.parseClass(codeSource);
            for (Method method : groovyClass.getMethods()) {
                DialobDDRLFunction asyncAnnotation;
                if (!Modifier.isStatic(method.getModifiers()) || (asyncAnnotation = method.getAnnotation(DialobDDRLFunction.class)) == null) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(" - registering {} function: {}.{} as {}", new Object[]{asyncAnnotation.async() ? "async" : "sync", groovyClass.getName(), method.getName(), method.getName()});
                }
                this.functionRegistry.configureFunction(method.getName(), groovyClass, asyncAnnotation.async());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @PostConstruct
    void registerGroovyFunctions() {
        this.groovyFunctions.forEach(resource -> this.compileScript(this.applicationContext.getResource(resource), this.codePackage));
    }
}

