/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.function;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.function.ConfiguredFunction;
import io.dialob.function.ImmutableConfiguredFunction;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.rule.parser.api.VariableNotDefinedException;
import io.dialob.rule.parser.function.FunctionRegistry;
import io.dialob.rule.parser.function.FunctionRegistryException;
import io.dialob.security.tenant.CurrentTenant;
import io.dialob.security.tenant.Tenant;
import io.dialob.security.tenant.TenantContextHolderCurrentTenant;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.Generated;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.TaskRejectedException;

@Value.Enclosing
class FunctionRegistryImpl
implements FunctionRegistry {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FunctionRegistryImpl.class);
    private final CurrentTenant currentTenant;
    private final TaskExecutor taskExecutor;
    private final ListMultimap<String, ConfiguredFunction> configuredFunctions = Multimaps.newListMultimap(new HashMap(), ArrayList::new);
    private static final Predicate<ValueType[]> MATCH_OBJECT_ARRAY = args -> ((ValueType[])args).length == 1 && args[0].isArray();

    FunctionRegistryImpl(@NonNull TaskExecutor taskExecutor, CurrentTenant currentTenant) {
        this.taskExecutor = Objects.requireNonNull(taskExecutor);
        this.currentTenant = currentTenant;
    }

    @NonNull
    public ValueType returnTypeOf(@NonNull String functionName, ValueType ... argTypes) throws VariableNotDefinedException {
        for (ConfiguredFunction configuredFunction : this.configuredFunctions.get((Object)functionName)) {
            if (configuredFunction == null || !configuredFunction.getArgumentMatcher().test(argTypes)) continue;
            return configuredFunction.getReturnType();
        }
        throw new VariableNotDefinedException(functionName);
    }

    public boolean isAsyncFunction(String functionName) {
        for (ConfiguredFunction configuredFunction : this.configuredFunctions.get((Object)functionName)) {
            if (!configuredFunction.isAsync()) continue;
            return true;
        }
        return false;
    }

    public void configureFunction(@NonNull String functionName, @NonNull Class<?> implementationClass, boolean async) {
        this.configureFunction(functionName, functionName, implementationClass, async);
    }

    public void configureFunction(@NonNull String functionName, @NonNull String implementationName, @NonNull Class<?> implementationClass, boolean async) {
        try {
            for (Method method : implementationClass.getMethods()) {
                if (!method.getName().equals(implementationName) || !this.isPublicAndStatic(method)) continue;
                ValueType returnType = ValueType.valueTypeOf(method.getReturnType());
                ArrayList<ValueType> argumentTypes = new ArrayList<ValueType>();
                LOGGER.debug("Try register method {} as {}[]", (Object)method, (Object)functionName);
                Predicate<ValueType[]> argumentMatcher = null;
                for (Class<?> argType : method.getParameterTypes()) {
                    if (argType == Object[].class) {
                        argumentMatcher = MATCH_OBJECT_ARRAY;
                        continue;
                    }
                    ValueType valueType = ValueType.valueTypeOf(argType);
                    if (valueType == null) {
                        LOGGER.warn("Failed to map {}", argType);
                    }
                    argumentTypes.add(valueType);
                }
                if (!argumentTypes.contains(null)) {
                    ImmutableConfiguredFunction.Builder builder = ImmutableConfiguredFunction.builder();
                    if (argumentMatcher != null) {
                        builder.argumentMatcher(argumentMatcher);
                    }
                    this.configuredFunctions.put((Object)functionName, (Object)builder.functionName(functionName).staticMethodName(implementationName).returnType(returnType).addAllArgumentValueTypes(argumentTypes).argumentTypes(method.getParameterTypes()).functionImplementationClass(implementationClass).isAsync(async).build());
                    return;
                }
                LOGGER.warn("Could not map function '{}' argument types to fact types. Registration skipped.", (Object)functionName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new FunctionRegistryException("Could not find function public static " + implementationClass.getCanonicalName() + "." + implementationName);
    }

    private boolean isPublicAndStatic(Method method) {
        return Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers());
    }

    public void invokeFunction(FunctionRegistry.FunctionCallback callback, @NonNull String functionName, Object ... args) {
        Object failure;
        try {
            ConfiguredFunction configuredFunction = this.findConfiguredFunction(functionName, args);
            Method method = this.findMethod(configuredFunction);
            if (method != null) {
                Object out = method.invoke(null, args);
                callback.succeeded(configuredFunction.getReturnType().getTypeClass().cast(out));
                return;
            }
            failure = "Can't find function " + functionName;
        }
        catch (InvocationTargetException e) {
            failure = e.getTargetException().getMessage();
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't invoke function " + functionName, (Throwable)e);
            failure = e.getMessage();
        }
        callback.failed((String)failure);
    }

    protected ConfiguredFunction findConfiguredFunction(String canonicalFunctionName, Object ... args) {
        String functionName = canonicalFunctionName.substring(canonicalFunctionName.lastIndexOf(46) + 1);
        for (ConfiguredFunction configuredFunction : this.configuredFunctions.get((Object)functionName)) {
            if (!configuredFunction.doesMatch(canonicalFunctionName, args)) continue;
            return configuredFunction;
        }
        return null;
    }

    private Method findMethod(ConfiguredFunction configuredFunction) throws NoSuchMethodException {
        if (configuredFunction == null) {
            return null;
        }
        Class implClass = configuredFunction.getFunctionImplementationClass();
        return implClass.getMethod(configuredFunction.getStaticMethodName(), configuredFunction.getArgumentTypes());
    }

    public void invokeFunctionAsync(FunctionRegistry.FunctionCallback callback, @NonNull String functionName, Object ... args) {
        Tenant tenant = this.currentTenant.get();
        try {
            this.taskExecutor.execute(() -> TenantContextHolderCurrentTenant.runInTenantContext((Tenant)tenant, () -> this.invokeFunction(callback, functionName, args)));
        }
        catch (TaskRejectedException taskRejectedException) {
            LOGGER.warn("Function evaluation failed: {}", (Object)taskRejectedException.getMessage());
            callback.failed(taskRejectedException.getMessage());
        }
    }
}

