/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.pgsql.migration;

import io.dialob.api.form.Form;
import io.dialob.api.form.ImmutableForm;
import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobErrorHandler;
import io.dialob.client.api.ImmutableFormDocument;
import io.dialob.client.api.ImmutableFormReleaseDocument;
import io.dialob.client.api.ImmutableFormReleaseValueDocument;
import io.dialob.client.api.ImmutableFormRevisionDocument;
import io.dialob.client.api.ImmutableFormRevisionEntryDocument;
import io.dialob.client.spi.exceptions.ErrorMsgBuilder;
import io.dialob.client.spi.migration.MigrationSupport;
import io.dialob.client.spi.support.OidUtils;
import io.dialob.client.spi.support.Sha2;
import io.vertx.mutiny.sqlclient.Row;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class MigrationVisitor {
    private final DialobClient.TypesMapper mapper;
    private final Map<String, DialobDocument.FormRevisionDocument> revisions = new LinkedHashMap<String, DialobDocument.FormRevisionDocument>();
    private final Collection<String> unresolvedFormDocuments = new HashSet<String>();
    private final Map<String, FormDocumentWrapper> resolvedFormDocuments = new HashMap<String, FormDocumentWrapper>();
    private final Map<String, FormDocumentWrapper> resolvedWithMissingRevs = new HashMap<String, FormDocumentWrapper>();
    private final Map<String, FormDocumentWrapper> resolvedWithConflictingIds = new HashMap<String, FormDocumentWrapper>();

    public void visitFormRev(Row row) {
        String form_name = row.getString("form_name");
        String name = row.getString("name");
        String form_document_id = row.getUUID("form_document_id").toString();
        String description = row.getString("description");
        LocalDateTime created = row.getLocalDateTime("created");
        LocalDateTime updated = row.getLocalDateTime("updated");
        ImmutableFormRevisionEntryDocument entry = ImmutableFormRevisionEntryDocument.builder().id(OidUtils.gen()).formId(form_document_id).description(description).revisionName(name).created(created).updated(updated).build();
        if (!this.revisions.containsKey(form_name)) {
            throw new DialobErrorHandler.DocumentNotFoundException(new ErrorMsgBuilder("Revision document not found!").field("form_name", form_name).field("name", name).build());
        }
        ImmutableFormRevisionDocument.Builder revision = ImmutableFormRevisionDocument.builder().from(this.revisions.get(form_name));
        this.revisions.put(form_name, (DialobDocument.FormRevisionDocument)revision.addEntries((DialobDocument.FormRevisionEntryDocument)entry).build());
        this.unresolvedFormDocuments.add(form_document_id);
    }

    public void visitForm(Row row) {
        String label = row.getString("label");
        String name = row.getString("name");
        String latest_form_id = row.getUUID("latest_form_id").toString();
        LocalDateTime created = row.getLocalDateTime("created");
        LocalDateTime updated = row.getLocalDateTime("updated");
        ImmutableFormRevisionDocument revision = ImmutableFormRevisionDocument.builder().id(name).name(label).created(created).updated(updated).head(latest_form_id).build();
        this.unresolvedFormDocuments.add(latest_form_id);
        this.revisions.put(name, (DialobDocument.FormRevisionDocument)revision);
    }

    public void visitFormDocument(Row row) {
        String id = row.getUUID("id").toString();
        Integer rev = row.getInteger("rev");
        String data = row.getString("data");
        LocalDateTime created = row.getLocalDateTime("created");
        LocalDateTime updated = row.getLocalDateTime("updated");
        ImmutableForm form = ImmutableForm.builder().from(this.mapper.readForm(data)).id(null).rev(null).build();
        FormDocumentWrapper document = FormDocumentWrapper.builder().id(id).version(rev.toString()).created(created).updated(updated).data(this.mapper.toJson((Object)form)).build();
        if (!this.unresolvedFormDocuments.contains(id)) {
            this.resolvedWithMissingRevs.put(id, document);
        } else if (this.resolvedFormDocuments.containsKey(id)) {
            this.resolvedWithConflictingIds.put(id, document);
        } else {
            this.resolvedFormDocuments.put(id, document);
        }
    }

    private final Form clean(String data) {
        Form form = this.mapper.readForm(data);
        return ImmutableForm.builder().from(form).id(null).rev(null).build();
    }

    private void createMissing() {
        for (FormDocumentWrapper wrapper : this.resolvedWithMissingRevs.values()) {
            Form data = this.clean(wrapper.getData());
            ImmutableFormRevisionDocument revision = ImmutableFormRevisionDocument.builder().id(OidUtils.gen()).name(data.getMetadata().getLabel()).created(LocalDateTime.ofInstant(data.getMetadata().getCreated().toInstant(), ZoneId.systemDefault())).updated(LocalDateTime.ofInstant(data.getMetadata().getLastSaved().toInstant(), ZoneId.systemDefault())).head(wrapper.getId()).description("MISSING_FORM_REV").build();
            this.revisions.put(revision.getId(), (DialobDocument.FormRevisionDocument)revision);
            this.resolvedFormDocuments.put(wrapper.getId(), wrapper);
        }
    }

    public MigrationSupport.Migration build() {
        this.createMissing();
        ArrayList<ImmutableFormReleaseValueDocument> values = new ArrayList<ImmutableFormReleaseValueDocument>();
        ArrayList<ImmutableFormDocument> docs = new ArrayList<ImmutableFormDocument>();
        for (FormDocumentWrapper wrapper : this.resolvedFormDocuments.values()) {
            ImmutableFormDocument document = ImmutableFormDocument.builder().id(wrapper.getId()).version(wrapper.getVersion()).created(wrapper.getCreated()).updated(wrapper.getUpdated()).data(this.clean(wrapper.getData())).build();
            docs.add(document);
            String commands = this.mapper.toJson((Object)document);
            values.add(ImmutableFormReleaseValueDocument.builder().bodyType(DialobDocument.DocumentType.FORM).commands(commands).hash(Sha2.blob((String)commands)).build());
        }
        for (DialobDocument.FormRevisionDocument revision : this.revisions.values()) {
            String commands = this.mapper.toJson((Object)revision);
            values.add(ImmutableFormReleaseValueDocument.builder().bodyType(DialobDocument.DocumentType.FORM_REV).commands(commands).hash(Sha2.blob((String)commands)).build());
        }
        this.unresolvedFormDocuments.removeAll(this.resolvedFormDocuments.keySet());
        if (!this.unresolvedFormDocuments.isEmpty()) {
            throw new DialobErrorHandler.DocumentNotFoundException(new ErrorMsgBuilder("Form revision data not found!").field("form id-s:", String.join((CharSequence)", ", this.unresolvedFormDocuments)).build());
        }
        String log = this.log();
        ImmutableFormReleaseDocument rel = ImmutableFormReleaseDocument.builder().name("migration").created(LocalDateTime.now()).addAllValues(values).build();
        return MigrationSupport.Migration.builder().log(log).release((DialobDocument.FormReleaseDocument)rel).build();
    }

    private String log() {
        StringBuilder log = new StringBuilder("Found " + this.revisions.keySet().size() + " revisions: ").append(", with missing revision: ").append(this.resolvedWithMissingRevs.keySet().size()).append(System.lineSeparator());
        for (DialobDocument.FormRevisionDocument rev : this.revisions.values()) {
            log.append(System.lineSeparator()).append("  - form id: ").append(rev.getId()).append(System.lineSeparator()).append("  - form name: '").append(rev.getName()).append("'").append(System.lineSeparator()).append("  - form desc: '").append(rev.getDescription()).append("'").append(System.lineSeparator()).append("  - form created: ").append(rev.getCreated()).append(System.lineSeparator()).append("  - form head: ").append(rev.getHead()).append(System.lineSeparator());
            for (DialobDocument.FormRevisionEntryDocument entry : rev.getEntries()) {
                log.append("    - ").append(entry.getRevisionName()).append(": ").append(entry.getFormId()).append(System.lineSeparator());
            }
        }
        log.append(System.lineSeparator()).append("Conflicting id: " + this.resolvedWithConflictingIds.keySet().size()).append(System.lineSeparator());
        for (FormDocumentWrapper conflict : this.resolvedWithConflictingIds.values()) {
            log.append(new ErrorMsgBuilder("Form document id already in use!").field("id", conflict.getId()).field("name", conflict.getData()).build());
        }
        return log.toString();
    }

    public MigrationVisitor(DialobClient.TypesMapper mapper) {
        this.mapper = mapper;
    }

    private static class FormDocumentWrapper {
        final String id;
        final String version;
        final String data;
        final LocalDateTime created;
        final LocalDateTime updated;

        FormDocumentWrapper(String id, String version, String data, LocalDateTime created, LocalDateTime updated) {
            this.id = id;
            this.version = version;
            this.data = data;
            this.created = created;
            this.updated = updated;
        }

        public static FormDocumentWrapperBuilder builder() {
            return new FormDocumentWrapperBuilder();
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public String getData() {
            return this.data;
        }

        public LocalDateTime getCreated() {
            return this.created;
        }

        public LocalDateTime getUpdated() {
            return this.updated;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FormDocumentWrapper)) {
                return false;
            }
            FormDocumentWrapper other = (FormDocumentWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            LocalDateTime this$created = this.getCreated();
            LocalDateTime other$created = other.getCreated();
            if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
                return false;
            }
            LocalDateTime this$updated = this.getUpdated();
            LocalDateTime other$updated = other.getUpdated();
            return !(this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FormDocumentWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            LocalDateTime $created = this.getCreated();
            result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
            LocalDateTime $updated = this.getUpdated();
            result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
            return result;
        }

        public String toString() {
            return "MigrationVisitor.FormDocumentWrapper(id=" + this.getId() + ", version=" + this.getVersion() + ", data=" + this.getData() + ", created=" + this.getCreated() + ", updated=" + this.getUpdated() + ")";
        }

        public static class FormDocumentWrapperBuilder {
            private String id;
            private String version;
            private String data;
            private LocalDateTime created;
            private LocalDateTime updated;

            FormDocumentWrapperBuilder() {
            }

            public FormDocumentWrapperBuilder id(String id) {
                this.id = id;
                return this;
            }

            public FormDocumentWrapperBuilder version(String version) {
                this.version = version;
                return this;
            }

            public FormDocumentWrapperBuilder data(String data) {
                this.data = data;
                return this;
            }

            public FormDocumentWrapperBuilder created(LocalDateTime created) {
                this.created = created;
                return this;
            }

            public FormDocumentWrapperBuilder updated(LocalDateTime updated) {
                this.updated = updated;
                return this;
            }

            public FormDocumentWrapper build() {
                return new FormDocumentWrapper(this.id, this.version, this.data, this.created, this.updated);
            }

            public String toString() {
                return "MigrationVisitor.FormDocumentWrapper.FormDocumentWrapperBuilder(id=" + this.id + ", version=" + this.version + ", data=" + this.data + ", created=" + this.created + ", updated=" + this.updated + ")";
            }
        }
    }
}

