/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.pgsql.migration;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.pgsql.migration.MigrationVisitor;
import io.dialob.client.spi.DialobTypesMapperImpl;
import io.dialob.client.spi.migration.MigrationSupport;
import io.resys.thena.docdb.spi.pgsql.PgErrors;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.sqlclient.Pool;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowIterator;
import io.vertx.mutiny.sqlclient.Tuple;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class MigrationClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationClient.class);
    private final ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    private final Pool pool;
    private static final Map<String, String> PROPS = new HashMap<String, String>();
    private static final DialobTypesMapperImpl MAPPER;

    private void setupTables(String ... versions) {
        try {
            for (String version : versions) {
                ArrayList<Sql> sqls = new ArrayList<Sql>();
                Resource resource = this.resolver.getResource("classpath:migration_postgresql/" + version);
                int index = 1;
                String content = new String(resource.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
                String splitOn = content.indexOf("@") > 1 ? "@" : ";";
                for (String statement : content.split(splitOn)) {
                    if (statement.trim().isEmpty()) continue;
                    Sql sql = Sql.builder().id(resource.getFilename().substring(0, 4) + ": " + index++).value(statement).build();
                    sqls.add(sql);
                }
                for (Sql sql : sqls) {
                    this.pool.preparedQuery(sql.getValue()).execute().onItem().transformToUni(data -> Uni.createFrom().voidItem()).onFailure().invoke(e -> new PgErrors().deadEnd("Can't migrate: " + sql.getId() + " sql:'" + sql.getValue() + "'!", e)).await().atMost(Duration.ofSeconds(5L));
                }
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2.getMessage(), e2);
        }
    }

    public static Map<String, String> withProfile(Map<String, String> props) {
        PROPS.putAll(props);
        return PROPS;
    }

    public void createDB() {
        this.setupTables("V1_0__init.sql", "V1_1__label.sql", "V1_2__tenant.sql", "V1_3__delete-label.sql", "V1_4__questionnaire_owner.sql", "V1_5__raise_form_name_length_to_128.sql", "V1_6__add_form_name_view.sql", "V1_7__add_tag_comment_field.sql", "V1_8__add_tag_type_field.sql", "V1_9__extend_owner_column_to_64.sql");
        LOGGER.error("DB created." + System.lineSeparator() + "  - Use terminal to import dump." + System.lineSeparator() + "  - In terminal: psql -p 5432 -d postgres -U postgres -h localhost -f dbdump.sql");
    }

    public DialobTypesMapperImpl getMapper() {
        return MAPPER;
    }

    public MigrationSupport.Migration getRelease(String tenant) {
        DialobTypesMapperImpl mapper = this.getMapper();
        MigrationVisitor visitor = new MigrationVisitor((DialobClient.TypesMapper)mapper);
        this.pool.preparedQuery("SELECT name, label, created, updated, latest_form_id FROM form where tenant_id = $1  ORDER BY name, created ").execute(Tuple.of((Object)tenant)).onItem().transform(rowset -> {
            ArrayList revs = new ArrayList();
            RowIterator iterator = rowset.iterator();
            while (iterator.hasNext()) {
                visitor.visitForm((Row)iterator.next());
            }
            return revs;
        }).await().atMost(Duration.ofSeconds(5L));
        this.pool.preparedQuery("SELECT form_name, name, created, updated, form_document_id, description FROM form_rev where tenant_id = $1  ORDER BY form_name, created ").execute(Tuple.of((Object)tenant)).onItem().transform(rowset -> {
            ArrayList revs = new ArrayList();
            RowIterator iterator = rowset.iterator();
            while (iterator.hasNext()) {
                visitor.visitFormRev((Row)iterator.next());
            }
            return revs;
        }).await().atMost(Duration.ofSeconds(5L));
        this.pool.preparedQuery("SELECT id, rev, created, updated, CAST(data AS TEXT) FROM form_document where tenant_id = $1  ORDER BY id, created ").execute(Tuple.of((Object)tenant)).onItem().transform(rowset -> {
            ArrayList revs = new ArrayList();
            RowIterator iterator = rowset.iterator();
            while (iterator.hasNext()) {
                visitor.visitFormDocument((Row)iterator.next());
            }
            return revs;
        }).await().atMost(Duration.ofSeconds(30L));
        return visitor.build();
    }

    public void write(MigrationSupport.Migration migration, OutputStream output) {
        new MigrationSupport((DialobClient.TypesMapper)MAPPER).write(migration, output);
    }

    public DialobDocument.FormReleaseDocument read(InputStream input) {
        return new MigrationSupport((DialobClient.TypesMapper)MAPPER).read(input).getRelease();
    }

    public MigrationClient(Pool pool) {
        this.pool = pool;
    }

    static {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new GuavaModule());
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new Jdk8Module());
        MAPPER = new DialobTypesMapperImpl(objectMapper);
    }

    private static class Sql {
        private String id;
        private String value;

        Sql(String id, String value) {
            this.id = id;
            this.value = value;
        }

        public static SqlBuilder builder() {
            return new SqlBuilder();
        }

        public String getId() {
            return this.id;
        }

        public String getValue() {
            return this.value;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sql)) {
                return false;
            }
            Sql other = (Sql)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Sql;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "MigrationClient.Sql(id=" + this.getId() + ", value=" + this.getValue() + ")";
        }

        public static class SqlBuilder {
            private String id;
            private String value;

            SqlBuilder() {
            }

            public SqlBuilder id(String id) {
                this.id = id;
                return this;
            }

            public SqlBuilder value(String value) {
                this.value = value;
                return this;
            }

            public Sql build() {
                return new Sql(this.id, this.value);
            }

            public String toString() {
                return "MigrationClient.Sql.SqlBuilder(id=" + this.id + ", value=" + this.value + ")";
            }
        }
    }
}

