/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.pgsql;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableStoreEntity;
import io.dialob.client.spi.DialobStoreTemplate;
import io.dialob.client.spi.store.BlobDeserializer;
import io.dialob.client.spi.store.DialobStoreConfig;
import io.dialob.client.spi.store.ImmutableDialobStoreConfig;
import io.dialob.client.spi.support.DialobAssert;
import io.dialob.client.spi.support.OidUtils;
import io.resys.thena.docdb.api.DocDB;
import io.resys.thena.docdb.spi.ErrorHandler;
import io.resys.thena.docdb.spi.pgsql.PgErrors;
import io.resys.thena.docdb.sql.DocDBFactorySql;
import io.vertx.mutiny.pgclient.PgPool;
import io.vertx.mutiny.sqlclient.Pool;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.sqlclient.PoolOptions;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgSqlDialobStore
extends DialobStoreTemplate
implements DialobStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(PgSqlDialobStore.class);

    public PgSqlDialobStore(DialobStoreConfig config) {
        super(config);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String repoName;
        private String headName;
        private ObjectMapper objectMapper;
        private DialobStoreConfig.GidProvider gidProvider;
        private DialobStoreConfig.AuthorProvider authorProvider;
        private PgPool pgPool;
        private String pgHost;
        private String pgDb;
        private Integer pgPort;
        private String pgUser;
        private String pgPass;
        private Integer pgPoolSize;

        public Builder repoName(String repoName) {
            this.repoName = repoName;
            return this;
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder gidProvider(DialobStoreConfig.GidProvider gidProvider) {
            this.gidProvider = gidProvider;
            return this;
        }

        public Builder authorProvider(DialobStoreConfig.AuthorProvider authorProvider) {
            this.authorProvider = authorProvider;
            return this;
        }

        public Builder pgPool(PgPool pgPool) {
            this.pgPool = pgPool;
            return this;
        }

        public Builder headName(String headName) {
            this.headName = headName;
            return this;
        }

        public Builder pgHost(String pgHost) {
            this.pgHost = pgHost;
            return this;
        }

        public Builder pgDb(String pgDb) {
            this.pgDb = pgDb;
            return this;
        }

        public Builder pgPort(Integer pgPort) {
            this.pgPort = pgPort;
            return this;
        }

        public Builder pgUser(String pgUser) {
            this.pgUser = pgUser;
            return this;
        }

        public Builder pgPass(String pgPass) {
            this.pgPass = pgPass;
            return this;
        }

        public Builder pgPoolSize(Integer pgPoolSize) {
            this.pgPoolSize = pgPoolSize;
            return this;
        }

        private DialobStoreConfig.GidProvider getGidProvider() {
            return this.gidProvider == null ? type -> OidUtils.gen() : this.gidProvider;
        }

        private DialobStoreConfig.AuthorProvider getAuthorProvider() {
            return this.authorProvider == null ? () -> "not-configured" : this.authorProvider;
        }

        private ObjectMapper getObjectMapper() {
            if (this.objectMapper == null) {
                return this.objectMapper;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.registerModule((Module)new GuavaModule());
            objectMapper.registerModule((Module)new JavaTimeModule());
            objectMapper.registerModule((Module)new Jdk8Module());
            return objectMapper;
        }

        public PgSqlDialobStore build() {
            DocDB thena;
            String headName;
            DialobAssert.notNull((Object)this.repoName, () -> "repoName must be defined!");
            String string = headName = this.headName == null ? "main" : this.headName;
            if (LOGGER.isDebugEnabled()) {
                StringBuilder log = new StringBuilder().append(System.lineSeparator()).append("Configuring Thena: ").append(System.lineSeparator()).append("  repoName: '").append(this.repoName).append("'").append(System.lineSeparator()).append("  headName: '").append(headName).append("'").append(System.lineSeparator()).append("  objectMapper: '").append(this.objectMapper == null ? "configuring" : "provided").append("'").append(System.lineSeparator()).append("  gidProvider: '").append(this.gidProvider == null ? "configuring" : "provided").append("'").append(System.lineSeparator()).append("  authorProvider: '").append(this.authorProvider == null ? "configuring" : "provided").append("'").append(System.lineSeparator()).append("  pgPool: '").append(this.pgPool == null ? "configuring" : "provided").append("'").append(System.lineSeparator()).append("  pgPoolSize: '").append(this.pgPoolSize).append("'").append(System.lineSeparator()).append("  pgHost: '").append(this.pgHost).append("'").append(System.lineSeparator()).append("  pgPort: '").append(this.pgPort).append("'").append(System.lineSeparator()).append("  pgDb: '").append(this.pgDb).append("'").append(System.lineSeparator()).append("  pgUser: '").append(this.pgUser == null ? "null" : "***").append("'").append(System.lineSeparator()).append("  pgPass: '").append(this.pgPass == null ? "null" : "***").append("'").append(System.lineSeparator());
                LOGGER.debug(log.toString());
            }
            if (this.pgPool == null) {
                DialobAssert.notNull((Object)this.pgHost, () -> "pgHost must be defined!");
                DialobAssert.notNull((Object)this.pgPort, () -> "pgPort must be defined!");
                DialobAssert.notNull((Object)this.pgDb, () -> "pgDb must be defined!");
                DialobAssert.notNull((Object)this.pgUser, () -> "pgUser must be defined!");
                DialobAssert.notNull((Object)this.pgPass, () -> "pgPass must be defined!");
                DialobAssert.notNull((Object)this.pgPoolSize, () -> "pgPoolSize must be defined!");
                PgConnectOptions connectOptions = new PgConnectOptions().setHost(this.pgHost).setPort(this.pgPort.intValue()).setDatabase(this.pgDb).setUser(this.pgUser).setPassword(this.pgPass);
                PoolOptions poolOptions = new PoolOptions().setMaxSize(this.pgPoolSize.intValue());
                PgPool pgPool = PgPool.pool((PgConnectOptions)connectOptions, (PoolOptions)poolOptions);
                thena = DocDBFactorySql.create().client((Pool)pgPool).db(this.repoName).errorHandler((ErrorHandler)new PgErrors()).build();
            } else {
                thena = DocDBFactorySql.create().client((Pool)this.pgPool).db(this.repoName).errorHandler((ErrorHandler)new PgErrors()).build();
            }
            ObjectMapper objectMapper = this.getObjectMapper();
            ImmutableDialobStoreConfig config = ImmutableDialobStoreConfig.builder().client(thena).repoName(this.repoName).headName(headName).gidProvider(this.getGidProvider()).serializer(entity -> {
                try {
                    return objectMapper.writeValueAsString((Object)ImmutableStoreEntity.builder().from(entity).build());
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }).deserializer((DialobStoreConfig.Deserializer)new BlobDeserializer(objectMapper)).authorProvider(this.getAuthorProvider()).build();
            return new PgSqlDialobStore((DialobStoreConfig)config);
        }
    }
}

