/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.form.service;

import io.dialob.api.form.Form;
import io.dialob.api.form.FormItem;
import io.dialob.api.form.FormValidationError;
import io.dialob.api.form.FormValueSet;
import io.dialob.api.form.ImmutableForm;
import io.dialob.api.form.ImmutableFormItem;
import io.dialob.api.form.ImmutableFormValidationError;
import io.dialob.api.form.ImmutableFormValueSet;
import io.dialob.form.service.api.validation.FormIdRenamer;
import io.dialob.form.service.api.validation.FormItemCopier;
import io.dialob.rule.parser.api.RuleExpressionCompiler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class DialobFormItemCopier
implements FormItemCopier {
    private final RuleExpressionCompiler compiler;
    private final FormIdRenamer renamerService;

    public DialobFormItemCopier(RuleExpressionCompiler compiler, FormIdRenamer renamerService) {
        this.compiler = compiler;
        this.renamerService = renamerService;
    }

    private String findNextID(Map<String, FormItem> formData, String id) {
        String nextID;
        int suffix = 0;
        do {
            nextID = id + ++suffix;
        } while (formData.keySet().contains(nextID));
        return nextID;
    }

    private String findNextValuesetId(Form form, String id) {
        String nextID;
        int suffix = 0;
        while (this.findValueSet(form, nextID = id + ++suffix) != null) {
        }
        return nextID;
    }

    private FormValueSet findValueSet(Form form, String valueSetId) {
        return form.getValueSets().stream().filter(vs -> vs.getId().equals(valueSetId)).findFirst().orElse(null);
    }

    private Optional<FormItem> findContainerItem(Form form, String itemId) {
        return form.getData().values().stream().filter(i -> i.getItems().contains(itemId)).findFirst();
    }

    private String copySingleItem(ImmutableForm.Builder formBuilder, Form form, Map<String, String> idRenameMap, FormItem sourceItem) {
        Map formData = form.getData();
        String nextID = this.findNextID(formData, sourceItem.getId());
        ImmutableFormItem.Builder builder = ImmutableFormItem.builder().from(sourceItem).id(nextID);
        idRenameMap.put(sourceItem.getId(), nextID);
        builder.items((Iterable)sourceItem.getItems().stream().map(childId -> this.copySingleItem(formBuilder, form, idRenameMap, (FormItem)formData.get(childId))).collect(Collectors.toList()));
        if (sourceItem.getValueSetId() != null) {
            String newValueSetId = this.findNextValuesetId(form, sourceItem.getValueSetId());
            FormValueSet sourceValueSet = this.findValueSet(form, sourceItem.getValueSetId());
            ImmutableFormValueSet newValueSet = ImmutableFormValueSet.builder().from(sourceValueSet).id(newValueSetId).build();
            builder.valueSetId(newValueSetId);
            formBuilder.addValueSets((FormValueSet)newValueSet);
        }
        formBuilder.putData(nextID, (FormItem)builder.build());
        return nextID;
    }

    private void idRenamerSingleItem(Map<String, FormItem> renameItems, Form form, String sourceItemId, Map<String, String> idRenameMap) {
        idRenameMap.forEach((key, value) -> {
            UnaryOperator idRenamer = this.compiler.createIdRenamer(key, value);
            FormItem renamedItem = this.renamerService.renameAttributes((FormItem)renameItems.get(sourceItemId), idRenamer, key, value);
            renameItems.put(renamedItem.getId(), renamedItem);
            renamedItem.getItems().forEach(childId -> this.idRenamerSingleItem(renameItems, form, (String)childId, idRenameMap));
        });
    }

    public Pair<Form, List<FormValidationError>> copyFormItem(Form form, String idToCopy) {
        ImmutableForm.Builder formBuilder = ImmutableForm.builder().from(form);
        ArrayList<ImmutableFormValidationError> errors = new ArrayList<ImmutableFormValidationError>();
        Map formData = form.getData();
        FormItem sourceItem = (FormItem)formData.get(idToCopy);
        if (sourceItem == null) {
            errors.add(ImmutableFormValidationError.builder().itemId(idToCopy).message("FORM_SOURCE_ITEM_NOT_FOUND").type(FormValidationError.Type.GENERAL).build());
            return Pair.of((Object)form, errors);
        }
        HashMap<String, String> idRenameMap = new HashMap<String, String>();
        String newId = this.copySingleItem(formBuilder, form, idRenameMap, sourceItem);
        this.findContainerItem(form, idToCopy).ifPresent(containerItem -> {
            ImmutableFormItem.Builder formItemBuilder = ImmutableFormItem.builder().from(containerItem);
            int index = containerItem.getItems().indexOf(idToCopy);
            ArrayList<String> itemList = new ArrayList<String>(containerItem.getItems());
            itemList.add(index + 1, newId);
            formItemBuilder.items(itemList);
            formBuilder.putData(containerItem.getId(), (FormItem)formItemBuilder.build());
        });
        HashMap<String, FormItem> renamedItems = new HashMap<String, FormItem>();
        ImmutableForm build = formBuilder.build();
        renamedItems.putAll(build.getData());
        this.idRenamerSingleItem(renamedItems, (Form)build, newId, idRenameMap);
        formBuilder.data(renamedItems);
        return Pair.of((Object)formBuilder.build(), errors);
    }
}

