/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.form.service;

import io.dialob.api.form.Form;
import io.dialob.api.form.FormItem;
import io.dialob.api.form.FormValidationError;
import io.dialob.api.form.ImmutableForm;
import io.dialob.api.form.ImmutableFormItem;
import io.dialob.api.form.ImmutableFormValidationError;
import io.dialob.api.form.ImmutableValidation;
import io.dialob.api.form.ImmutableVariable;
import io.dialob.form.service.api.validation.FormIdRenamer;
import io.dialob.rule.parser.DialobRuleLexer;
import io.dialob.rule.parser.api.RuleExpressionCompiler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.Vocabulary;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.lang.NonNull;

public class DialobFormIdRenamer
implements FormIdRenamer {
    private final RuleExpressionCompiler compiler;
    private final List<String> reservedWords;

    public DialobFormIdRenamer(@NonNull RuleExpressionCompiler compiler) {
        String w;
        this.compiler = compiler;
        this.reservedWords = new ArrayList<String>();
        DialobRuleLexer lexer = new DialobRuleLexer((CharStream)CharStreams.fromString((String)""));
        Vocabulary vocabulary = lexer.getVocabulary();
        int i = 0;
        while ((w = vocabulary.getLiteralName(++i)) != null) {
            this.reservedWords.add(w.substring(1, w.length() - 1));
        }
    }

    public List<FormValidationError> validateRename(@NonNull Form formDocument, @NonNull String oldId, @NonNull String newId) {
        ArrayList<FormValidationError> errors = new ArrayList<FormValidationError>();
        if (!newId.matches("^[a-zA-Z_][a-zA-Z\\d_]*$")) {
            errors.add(this.createRenamerExpressionCompilerError(oldId, "FORM_NEW_VAR_FORMAT"));
        }
        this.reservedWords.forEach(t -> {
            if (t.equals(newId)) {
                errors.add(this.createRenamerExpressionCompilerError(oldId, "FORM_NEW_VAR_CLASH"));
            }
        });
        Map formData = formDocument.getData();
        if (formData.containsKey(newId) || formDocument.getVariables().stream().anyMatch(v -> v.getName().equals(newId))) {
            errors.add(this.createRenamerExpressionCompilerError(oldId, "FORM_NEW_VAR_CLASH"));
        }
        return errors;
    }

    private FormItem renameItemAndAttributes(FormItem item, UnaryOperator<String> idRenamer, String oldId, String newId) {
        ImmutableFormItem.Builder builder = ImmutableFormItem.builder().from(this.renameAttributes(item, idRenamer, oldId, newId));
        if (oldId.equals(item.getId())) {
            builder.id(newId);
        }
        return builder.build();
    }

    public FormItem renameAttributes(@NonNull FormItem item, @NonNull UnaryOperator<String> idRenamer, @NonNull String oldId, @NonNull String newId) {
        ImmutableFormItem.Builder builder = ImmutableFormItem.builder().from(item);
        if (item.getActiveWhen() != null) {
            builder.activeWhen((String)idRenamer.apply(item.getActiveWhen()));
        }
        if (item.getRequired() != null) {
            builder.required((String)idRenamer.apply(item.getRequired()));
        }
        List validations = item.getValidations().stream().map(validation -> ImmutableValidation.builder().from(validation).rule((String)idRenamer.apply(validation.getRule())).build()).collect(Collectors.toList());
        builder.validations(validations);
        int index = item.getItems().indexOf(oldId);
        if (index > -1) {
            ArrayList<String> newItems = new ArrayList<String>();
            newItems.addAll(item.getItems());
            newItems.set(index, newId);
            builder.items(newItems);
        }
        if (!item.getLabel().isEmpty()) {
            item.getLabel().forEach((l, m) -> {
                String newLabel = m.replaceAll("\\{(" + oldId + ")}", "{" + newId + "}");
                builder.putLabel(l, newLabel);
            });
        }
        return builder.build();
    }

    public Pair<Form, List<FormValidationError>> renameIdentifiers(@NonNull Form form, @NonNull String oldId, @NonNull String newId) {
        List<FormValidationError> errors = this.validateRename(form, oldId, newId);
        if (!errors.isEmpty()) {
            return Pair.of((Object)form, errors);
        }
        UnaryOperator idRenamer = this.compiler.createIdRenamer(oldId, newId);
        ImmutableForm.Builder formBuilder = ImmutableForm.builder().from(form);
        formBuilder.data(form.getData().entrySet().stream().map(itemEntry -> this.renameItemAndAttributes((FormItem)itemEntry.getValue(), idRenamer, oldId, newId)).collect(Collectors.toMap(FormItem::getId, item -> item)));
        ArrayList updatedVariables = new ArrayList();
        form.getVariables().forEach(v -> {
            ImmutableVariable.Builder builder = ImmutableVariable.builder().from(v);
            if (!Boolean.TRUE.equals(v.getContext())) {
                builder.expression((String)idRenamer.apply(v.getExpression()));
            }
            if (v.getName().equals(oldId)) {
                builder.name(newId);
            }
            updatedVariables.add(builder.build());
        });
        formBuilder.variables(updatedVariables);
        return Pair.of((Object)formBuilder.build(), errors);
    }

    private FormValidationError createRenamerExpressionCompilerError(String oldId, String message) {
        return ImmutableFormValidationError.builder().type(FormValidationError.Type.GENERAL).itemId(oldId).message(message).build();
    }
}

