/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.form.service.rest;

import io.dialob.api.form.Form;
import io.dialob.api.form.FormPutResponse;
import io.dialob.api.form.FormTag;
import io.dialob.api.rest.Response;
import io.dialob.form.service.api.repository.FormListItem;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(value={"${dialob.api.context-path:}/forms"})
@OpenAPIDefinition(info=@Info(title="DialobFormService"), tags={@Tag(name="dialob-form-service")})
public interface FormsRestService {
    @GetMapping(produces={"application/json"})
    public ResponseEntity<List<FormListItem>> getForms(@RequestParam(name="metadata", required=false) String var1);

    @PostMapping(path={"/actions/itemCopy"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FormPutResponse> itemCopy(@RequestParam(name="itemId") String var1, @Validated @RequestBody Form var2);

    @Operation(summary="Create a new form", description="You can create a new form within your tenant with a form object in .JSON format.")
    @PostMapping(produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Form> postForm(@Parameter(description="New form", name="form", required=true) @RequestBody Form var1);

    @Operation(summary="Update an existing form by form ID", description="With this endpoint, you can edit a particular form. You have the option to choose whether or not you want to create a new revision number for the form. You can also force an update which ignores the form revision number check. ")
    @PutMapping(path={"{formId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FormPutResponse> putForm(@PathVariable(value="formId") @Parameter(description="Internal identifier for a form") String var1, @Parameter(description="The name of the old identifier") @RequestParam(name="oldId", required=false) String var2, @Parameter(description="The new name to assign to the identifer") @RequestParam(name="newId", required=false) String var3, @RequestParam(name="force", required=false, defaultValue="false") @Parameter(description="A forced update will ignore form revision number check. The form ID and request body must match.") boolean var4, @RequestParam(name="dryRun", required=false, defaultValue="false") @Parameter(description="dryRun is useful for testing purposes. If dryRun is set to true, a new revision number will not be created upon opening a form for editing") boolean var5, @Parameter(description="New form data", name="form", required=true) @Validated @NotNull @RequestBody Form var6);

    @Operation(summary="Delete a form by form ID", description="The form ID is used to identify and delete a form from the tenant's form database.")
    @DeleteMapping(path={"{formId}"})
    public ResponseEntity<Response> deleteForm(@Parameter(description="Internal identifier for a form") @PathVariable(value="formId") String var1);

    @Operation(summary="Return a form by form ID", description="In order to find specific forms within the tenant, you can perform queries based on two properties: form ID, and the form revision number: rev")
    @GetMapping(path={"{formId}"}, produces={"application/json"})
    public ResponseEntity<Form> getForm(@Parameter(description="Internal identifier for a form") @PathVariable(value="formId") String var1, @Parameter(description="Form revision number") @RequestParam(name="rev", required=false) String var2);

    @Operation(summary="Return a list of tags associated with a given form ID", description="The form ID is used to identify a specific form and return an array of tag values for that form")
    @GetMapping(path={"{formId}/tags"}, produces={"application/json"})
    public ResponseEntity<List<FormTag>> getFormTags(@Parameter(description="Internal identifier for a form") @PathVariable(value="formId") String var1);

    @Operation(summary="Return a tag by form ID and tag name", description="Return a form tag using two properties: form ID and tag name")
    @GetMapping(path={"{formId}/tags/{tagName}"}, produces={"application/json"})
    public ResponseEntity<FormTag> getFormTag(@Parameter(description="Internal identifier for a form") @PathVariable(value="formId") String var1, @Parameter(description="Name of the tag") @PathVariable(value="tagName") String var2);

    @Operation(summary="Create a new form tag for a form by form ID", description="This endpoint will create a new tag for the latest revision of a form.")
    @PostMapping(path={"{formId}/tags"}, produces={"application/json"})
    public ResponseEntity<Response> postFormTag(@PathVariable(value="formId") @Parameter(description="Internal identifier for a form") String var1, @RequestParam(name="rev", required=false) @Parameter(description="Form revision number") String var2, @RequestParam(name="snapshot", required=false, defaultValue="false") @Parameter(description="If snapshot is set to true, a copy of the current form will be created as a snapshot version with a different form ID, to which the new tag will point") boolean var3, @Parameter(name="tag", required=true, description="Form tag object") @RequestBody FormTag var4);

    @Operation(summary="Update a form tag to 'LATEST' tag", description="Use one of a form's existing tags to create a 'LATEST' tag. A LATEST TAG is mutable, but the all the previous tags are immutable. To do this, you can use the form ID and tag properties.")
    @PutMapping(path={"{formId}/tags/latest"}, produces={"application/json"})
    public ResponseEntity<Response> putFormTagLatest(@PathVariable(value="formId") @Parameter(description="Internal identifier for a form") String var1, @Parameter(name="tag", required=true, description="Form tag object") @RequestBody FormTag var2);

    @PutMapping(path={"{formId}/tags/{tagName}"}, produces={"application/json"})
    public ResponseEntity<Response> putFormTag(@PathVariable(value="formId") String var1, @PathVariable(value="tagName") String var2, @Parameter(description="Updated tag", name="tag", required=true) @RequestBody FormTag var3);
}

