/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.form.service.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.api.form.Form;
import io.dialob.api.form.FormPutResponse;
import io.dialob.api.form.FormTag;
import io.dialob.api.form.ImmutableForm;
import io.dialob.api.form.ImmutableFormMetadata;
import io.dialob.api.form.ImmutableFormPutResponse;
import io.dialob.api.form.ImmutableFormTag;
import io.dialob.api.rest.ImmutableResponse;
import io.dialob.api.rest.Response;
import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import io.dialob.form.service.api.FormDatabase;
import io.dialob.form.service.api.FormVersionControlDatabase;
import io.dialob.form.service.api.repository.FormListItem;
import io.dialob.form.service.api.validation.FormIdRenamer;
import io.dialob.form.service.api.validation.FormItemCopier;
import io.dialob.form.service.rest.FormTagsRestService;
import io.dialob.form.service.rest.FormsRestService;
import io.dialob.form.service.rest.InvalidMetadataQueryException;
import io.dialob.integration.api.NodeId;
import io.dialob.integration.api.event.ImmutableFormDeletedEvent;
import io.dialob.integration.api.event.ImmutableFormTaggedEvent;
import io.dialob.integration.api.event.ImmutableFormUpdatedEvent;
import io.dialob.security.tenant.CurrentTenant;
import io.dialob.security.tenant.ImmutableTenant;
import io.dialob.security.tenant.Tenant;
import io.dialob.security.user.CurrentUserProvider;
import io.dialob.session.engine.program.FormValidatorExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
public class FormsRestServiceController
implements FormsRestService,
FormTagsRestService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormsRestServiceController.class);
    public static final String TEMPLATE_FORM_ID = "00000000000000000000000000000000";
    private static final ResponseEntity OK = ResponseEntity.ok((Object)ImmutableResponse.builder().ok(Boolean.valueOf(true)).build());
    public static final ResponseEntity<Response> NOT_MODIFIED_RESPONSE = ResponseEntity.status((HttpStatus)HttpStatus.NOT_MODIFIED).body((Object)ImmutableResponse.builder().ok(Boolean.valueOf(false)).build());
    public static final ResponseEntity<Response> OK_RESPONSE = FormsRestServiceController.ok(Response.class);
    private Form templateForm;
    private final ApplicationEventPublisher eventPublisher;
    private final FormDatabase formDatabase;
    private final Optional<FormVersionControlDatabase> formVersionControlDatabase;
    private final FormValidatorExecutor validator;
    private final FormIdRenamer renamer;
    private final ObjectMapper objectMapper;
    private final NodeId nodeId;
    private final FormItemCopier formItemCopier;
    private final CurrentTenant currentTenant;
    private final CurrentUserProvider currentUserProvider;
    private final Clock clock;

    private static <T> ResponseEntity<T> ok() {
        return OK;
    }

    private static <T> ResponseEntity<T> ok(Class<T> type) {
        return OK;
    }

    public FormsRestServiceController(ApplicationEventPublisher eventPublisher, FormDatabase formDatabase, Optional<FormVersionControlDatabase> formVersionControlDatabase, FormValidatorExecutor validator, FormIdRenamer renamer, ObjectMapper objectMapper, NodeId nodeId, FormItemCopier formItemCopier, CurrentTenant currentTenant, CurrentUserProvider currentUserProvider, Clock clock) {
        this.eventPublisher = eventPublisher;
        this.formDatabase = formDatabase;
        this.formVersionControlDatabase = formVersionControlDatabase;
        this.validator = validator;
        this.renamer = renamer;
        this.objectMapper = objectMapper;
        this.nodeId = nodeId;
        this.formItemCopier = formItemCopier;
        this.currentTenant = currentTenant;
        this.currentUserProvider = currentUserProvider;
        this.clock = clock;
    }

    @Override
    public ResponseEntity<List<FormListItem>> getForms(String metadata) {
        LOGGER.debug("getForms");
        ArrayList result = new ArrayList();
        Form.Metadata formMetadata = null;
        if (StringUtils.isNotBlank((CharSequence)metadata)) {
            try {
                formMetadata = (Form.Metadata)this.objectMapper.readValue(metadata, Form.Metadata.class);
            }
            catch (JsonProcessingException e) {
                throw new InvalidMetadataQueryException(e);
            }
        }
        this.formDatabase.findAllMetadata(this.currentTenant.getId(), formMetadata, row -> result.add(new FormListItem(row.getId(), row.getValue())));
        return ResponseEntity.ok(result);
    }

    @Override
    public ResponseEntity<FormPutResponse> itemCopy(@RequestParam(name="itemId") String itemId, @Validated @RequestBody Form form) {
        if (form == null) {
            return ResponseEntity.badRequest().body(null);
        }
        Pair resultPair = this.formItemCopier.copyFormItem(form, itemId);
        ImmutableFormPutResponse.Builder putResponseBuilder = ImmutableFormPutResponse.builder().id(form.getId()).rev(form.getRev()).ok(Boolean.valueOf(true));
        if (!((List)resultPair.getRight()).isEmpty()) {
            ((List)resultPair.getRight()).forEach(arg_0 -> ((ImmutableFormPutResponse.Builder)putResponseBuilder).addErrors(arg_0));
        }
        putResponseBuilder.form((Form)resultPair.getLeft());
        return ResponseEntity.ok((Object)putResponseBuilder.build());
    }

    @Override
    public ResponseEntity<Form> postForm(@Valid @RequestBody Form formDocument) {
        Form form = this.updateMetadata(formDocument);
        form = ImmutableForm.builder().from(form).id(null).rev(null).build();
        Form savedForm = this.formDatabase.save(this.currentTenant.getId(), form);
        URI uri = ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").buildAndExpand(new Object[]{savedForm.getId()}).toUri();
        return ResponseEntity.created((URI)uri).body((Object)savedForm);
    }

    @Override
    public ResponseEntity<FormPutResponse> putForm(@PathVariable(value="formId") String formId, @RequestParam(name="oldId", required=false) String oldId, @RequestParam(name="newId", required=false) String newId, @RequestParam(name="force", required=false, defaultValue="false") boolean forced, @RequestParam(name="dryRun", required=false, defaultValue="false") boolean dryRun, @Validated @NotNull @RequestBody Form formBody) {
        Form updatedForm;
        if (this.isTemplateFormId(formId)) {
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body(null);
        }
        Form form = this.updateMetadata(formBody);
        if (formId.equals(formBody.getName())) {
            String formName = formId;
            formId = (String)this.formVersionControlDatabase.flatMap(formVersionControlDatabase1 -> formVersionControlDatabase1.findTag(this.currentTenant.getId(), formName, "LATEST").map(FormTag::getFormId)).orElseThrow(() -> new DocumentNotFoundException("No form document \"" + formName + "\""));
        }
        if (forced) {
            Form existingForm = this.formDatabase.findOne(this.currentTenant.getId(), formId);
            form = ImmutableForm.builder().from(form).id(formId).rev(existingForm.getRev()).build();
        } else if (!formId.equals(formBody.getId())) {
            return ResponseEntity.badRequest().body((Object)ImmutableFormPutResponse.builder().ok(Boolean.valueOf(false)).error("INCONSISTENT_ID").reason("_id does not match with resource " + formId).build());
        }
        String prevRev = form.getRev();
        boolean includeForm = false;
        ArrayList errors = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)oldId) && StringUtils.isNotBlank((CharSequence)newId)) {
            Pair resultPair = this.renamer.renameIdentifiers(form, oldId, newId);
            form = (Form)resultPair.getLeft();
            errors.addAll((Collection)resultPair.getRight());
            includeForm = true;
        }
        errors.addAll(this.validator.validate(form));
        if (!dryRun) {
            updatedForm = this.formDatabase.save(this.currentTenant.getId(), (Form)ImmutableForm.builder().from(form).metadata((Form.Metadata)ImmutableFormMetadata.builder().from(form.getMetadata()).valid(Boolean.valueOf(errors.isEmpty())).build()).build());
            this.eventPublisher.publishEvent((Object)ImmutableFormUpdatedEvent.builder().source(this.getNodeId().getId()).tenant((Tenant)ImmutableTenant.of((String)updatedForm.getMetadata().getTenantId(), Optional.empty())).formId(formId).revision(updatedForm.getRev()).build());
        } else {
            updatedForm = form;
        }
        ImmutableFormPutResponse.Builder putResponse = ImmutableFormPutResponse.builder().id(updatedForm.getId()).rev(updatedForm.getRev());
        if (!errors.isEmpty()) {
            putResponse.ok(Boolean.valueOf(false));
            errors.forEach(arg_0 -> ((ImmutableFormPutResponse.Builder)putResponse).addErrors(arg_0));
        } else {
            putResponse.ok(Boolean.valueOf(true));
        }
        if (includeForm) {
            putResponse.form(updatedForm);
        }
        return ResponseEntity.ok((Object)putResponse.build());
    }

    private Form updateMetadata(Form form) {
        Date now = new Date(this.clock.millis());
        ImmutableFormMetadata.Builder builder = ImmutableFormMetadata.builder().from(form.getMetadata());
        builder.lastSaved(now);
        builder.tenantId(this.currentTenant.getId());
        String userId = this.currentUserProvider.getUserId();
        builder.savedBy(userId);
        if (form.getRev() == null) {
            builder.created(now);
            builder.creator(userId);
        }
        return ImmutableForm.builder().from(form).metadata((Form.Metadata)builder.build()).build();
    }

    @Override
    public ResponseEntity<Response> deleteForm(@PathVariable(value="formId") String formId) {
        if (this.isTemplateFormId(formId)) {
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body(null);
        }
        this.formDatabase.delete(this.currentTenant.getId(), formId);
        this.eventPublisher.publishEvent((Object)ImmutableFormDeletedEvent.builder().source(this.getNodeId().getId()).tenant(this.currentTenant.get()).formId(formId).build());
        return FormsRestServiceController.ok();
    }

    @Override
    public ResponseEntity<Form> getForm(@PathVariable(value="formId") String formId, @RequestParam(name="rev", required=false) String rev) {
        if (this.isTemplateFormId(formId)) {
            return ResponseEntity.ok((Object)this.getTemplateForm());
        }
        Form formDocument = this.formDatabase.findOne(this.currentTenant.getId(), formId, rev);
        return ResponseEntity.ok((Object)formDocument);
    }

    @Override
    public ResponseEntity<List<FormTag>> getFormTags(String formId) {
        return this.formVersionControlDatabase.map(versionControlDatabase -> ResponseEntity.ok((Object)versionControlDatabase.findTags(this.currentTenant.getId(), formId, null))).orElse(ResponseEntity.notFound().build());
    }

    @Override
    public ResponseEntity<FormTag> getFormTag(String formId, String tagName) {
        return this.formVersionControlDatabase.flatMap(versionControlDatabase -> versionControlDatabase.findTag(this.currentTenant.getId(), formId, tagName).map(ResponseEntity::ok)).orElse(ResponseEntity.notFound().build());
    }

    @Override
    public ResponseEntity<Response> putFormTagLatest(String formId, FormTag tag) {
        return this.formVersionControlDatabase.map(versionControlDatabase -> {
            if (versionControlDatabase.updateLatest(this.currentTenant.getId(), formId, tag)) {
                return this.fireFormTaggedEvent(Optional.of(ImmutableFormTag.builder().from(tag).formId(StringUtils.defaultString((String)formId)).build()));
            }
            return NOT_MODIFIED_RESPONSE;
        }).orElse(ResponseEntity.notFound().build());
    }

    @Override
    public ResponseEntity<Response> postFormTag(String formId, String rev, boolean snapshot, FormTag tag) {
        return this.formVersionControlDatabase.map(versionControlDatabase -> {
            String formName = tag.getFormName();
            String tagName = tag.getName();
            String formDocumentId = formId;
            if (versionControlDatabase.isName(this.currentTenant.getId(), formDocumentId)) {
                formDocumentId = tag.getFormId();
            }
            Optional formTag = formDocumentId == null ? versionControlDatabase.createTagOnLatest(this.currentTenant.getId(), formName, tagName, tag.getDescription(), snapshot) : versionControlDatabase.createTag(this.currentTenant.getId(), formName, tagName, tag.getDescription(), formDocumentId, tag.getType());
            return this.fireFormTaggedEvent(formTag);
        }).orElse(ResponseEntity.notFound().build());
    }

    @Override
    public ResponseEntity<Response> putFormTag(String formId, String tagName, FormTag requestTag) {
        if (StringUtils.isBlank((CharSequence)requestTag.getRefName())) {
            return ResponseEntity.badRequest().body((Object)ImmutableFormPutResponse.builder().ok(Boolean.valueOf(false)).error("INCOMPLETE").reason("ref_name is required field").build());
        }
        return this.formVersionControlDatabase.map(versionControlDatabase -> {
            String formName = formId;
            if (!versionControlDatabase.isName(this.currentTenant.getId(), formName)) {
                Form form = versionControlDatabase.getFormDatabase().findOne(this.currentTenant.getId(), formId);
                formName = form.getName();
            }
            ImmutableFormTag updateTag = ImmutableFormTag.builder().from(requestTag).formName(formName).name(tagName).build();
            Optional formTag = versionControlDatabase.moveTag(this.currentTenant.getId(), (FormTag)updateTag);
            return this.fireFormTaggedEvent(formTag);
        }).orElse(ResponseEntity.notFound().build());
    }

    protected ResponseEntity<Response> fireFormTaggedEvent(Optional<FormTag> formTag) {
        return formTag.map(newTag -> {
            this.eventPublisher.publishEvent((Object)ImmutableFormTaggedEvent.builder().tenant(this.currentTenant.get()).source(this.getNodeId().getId()).formName(newTag.getFormName()).tagName(newTag.getName()).formId(newTag.getFormId()).refName(newTag.getRefName()).build());
            return OK_RESPONSE;
        }).orElse(NOT_MODIFIED_RESPONSE);
    }

    protected boolean isTemplateFormId(String formId) {
        return TEMPLATE_FORM_ID.equals(formId);
    }

    protected Form getTemplateForm() {
        if (this.templateForm != null) {
            return this.templateForm;
        }
        try {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("forms/00000000000000000000000000000000.json");
            this.templateForm = (Form)this.objectMapper.readValue(inputStream, Form.class);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't read template form.", (Throwable)e);
        }
        return this.templateForm;
    }

    private NodeId getNodeId() {
        return this.nodeId;
    }

    @Override
    public ResponseEntity<List<FormTag>> getTags(String formName, String formId, String name) {
        return this.formVersionControlDatabase.map(versionControlDatabase -> ResponseEntity.ok((Object)versionControlDatabase.queryTags(this.currentTenant.getId(), formName, formId, name, FormTag.Type.NORMAL))).orElse(ResponseEntity.notFound().build());
    }
}

