/*
 * Copyright © 2015 - 2021 ReSys (info@dialob.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.dialob.form.service.api.validation;

import io.dialob.api.form.Form;
import io.dialob.api.form.FormItem;
import io.dialob.api.form.FormValidationError;
import org.apache.commons.lang3.tuple.Pair;

import javax.annotation.Nonnull;
import java.util.List;
import java.util.function.UnaryOperator;

public interface FormIdRenamer {
  List<FormValidationError> validateRename(@Nonnull Form formDocument, @Nonnull String oldId, @Nonnull String newId);

  FormItem renameAttributes(@Nonnull FormItem item, @Nonnull UnaryOperator<String> idRenamer, @Nonnull String oldId, @Nonnull String newId);

  Pair<Form, List<FormValidationError>> renameIdentifiers(@Nonnull Form form, @Nonnull String oldId, @Nonnull String newId);
}
