/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.spi.spring;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.data.annotation.Id;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ReflectionEntityInformation<T, ID extends Serializable>
extends AbstractEntityInformation<T, ID> {
    private static final Class<Id> DEFAULT_ID_ANNOTATION = Id.class;
    private Field field;
    private Method method;

    public ReflectionEntityInformation(Class<T> domainClass) {
        this(domainClass, DEFAULT_ID_ANNOTATION);
    }

    public ReflectionEntityInformation(Class<T> domainClass, Class<? extends Annotation> annotation) {
        super(domainClass);
        Assert.notNull(annotation, (String)"Annotation must not be null!");
        ReflectionUtils.doWithFields(domainClass, field -> {
            if (field.getAnnotation(annotation) != null) {
                this.field = field;
            }
        });
        ReflectionUtils.doWithMethods(domainClass, method -> {
            if (method.getAnnotation(annotation) != null && method.getReturnType() != Void.class) {
                this.method = method;
            }
        });
        if (this.field == null && this.method == null) {
            Assert.notNull((Object)this.field, (String)String.format("No field or method annotated with %s found!", annotation.toString()));
        }
        if (this.field != null) {
            ReflectionUtils.makeAccessible((Field)this.field);
        }
        if (this.method != null) {
            ReflectionUtils.makeAccessible((Method)this.method);
        }
    }

    @Nullable
    public ID getId(@NonNull Object entity) {
        if (this.field != null) {
            return (ID)((Serializable)ReflectionUtils.getField((Field)this.field, (Object)entity));
        }
        return (ID)((Serializable)ReflectionUtils.invokeMethod((Method)this.method, (Object)entity));
    }

    @NonNull
    public Class<ID> getIdType() {
        if (this.field != null) {
            return this.field.getType();
        }
        return this.method.getReturnType();
    }
}

