/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.spi.spring;

import io.dialob.db.spi.spring.ReflectionEntityInformation;
import org.springframework.data.annotation.Version;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractDocumentDatabase<T> {
    private final Class<? extends T> documentClass;
    private final ReflectionEntityInformation idEntityInformation;
    private final ReflectionEntityInformation revEntityInformation;

    protected AbstractDocumentDatabase(@NonNull Class<? extends T> documentClass) {
        this.documentClass = documentClass;
        this.idEntityInformation = new ReflectionEntityInformation(documentClass);
        this.revEntityInformation = new ReflectionEntityInformation(documentClass, Version.class);
        Assert.isTrue((this.idEntityInformation.getIdType() == String.class ? 1 : 0) != 0, (String)("id type is not String on type " + documentClass.getCanonicalName()));
        Assert.isTrue((this.revEntityInformation.getIdType() == String.class ? 1 : 0) != 0, (String)("version type is not String on type " + documentClass.getCanonicalName()));
    }

    public Class<? extends T> getDocumentClass() {
        return this.documentClass;
    }

    @Nullable
    protected String id(@NonNull T document) {
        return (String)this.idEntityInformation.getId(document);
    }

    @Nullable
    protected String rev(@NonNull T document) {
        return (String)this.revEntityInformation.getId(document);
    }

    @NonNull
    protected abstract T updateDocumentId(@NonNull T var1, String var2);

    @NonNull
    protected abstract T updateDocumentRev(@NonNull T var1, String var2);
}

