/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.spi.spring;

import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import io.dialob.api.rest.Errors;
import io.dialob.api.rest.ImmutableErrors;
import io.dialob.db.spi.exceptions.DatabaseException;
import io.dialob.db.spi.exceptions.DatabaseServiceDownException;
import io.dialob.db.spi.exceptions.DatabaseUnauthorizedException;
import io.dialob.db.spi.exceptions.DocumentConflictException;
import io.dialob.db.spi.exceptions.DocumentCorruptedException;
import io.dialob.db.spi.exceptions.DocumentForbiddenException;
import io.dialob.db.spi.exceptions.DocumentLockedException;
import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import io.dialob.db.spi.exceptions.TenantContextRequiredException;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class DatabaseExceptionMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseExceptionMapper.class);

    @ExceptionHandler
    public ResponseEntity handleDocumentNotFoundException(DocumentNotFoundException exception) {
        return this.buildResponse(HttpStatus.NOT_FOUND, exception.getMessage());
    }

    @ExceptionHandler
    public ResponseEntity handleDatabaseUnauthorizedException(DatabaseUnauthorizedException exception) {
        return this.buildResponse(HttpStatus.UNAUTHORIZED, exception.getMessage());
    }

    @ExceptionHandler
    public ResponseEntity handleDocumentForbiddenException(DocumentForbiddenException exception) {
        return this.buildResponse(HttpStatus.FORBIDDEN, exception.getMessage());
    }

    @ExceptionHandler
    public ResponseEntity handleDocumentConflictException(DocumentConflictException exception) {
        return this.buildResponse(HttpStatus.CONFLICT, exception.getMessage());
    }

    @ExceptionHandler
    public ResponseEntity handleDocumentLockedException(DocumentLockedException exception) {
        return this.buildResponse(HttpStatus.LOCKED, exception.getMessage());
    }

    @ExceptionHandler
    public ResponseEntity invalidDefinitionException(InvalidDefinitionException exception) {
        if (exception.getCause() instanceof ConstraintViolationException) {
            ConstraintViolationException constraintViolationException = (ConstraintViolationException)exception.getCause();
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body((Object)ImmutableErrors.builder().error(HttpStatus.BAD_REQUEST.getReasonPhrase()).status(Integer.valueOf(HttpStatus.BAD_REQUEST.value())).message(constraintViolationException.getMessage()).errors(constraintViolationException.getConstraintViolations().stream().map(constraintViolation -> ImmutableErrors.Error.builder().error(constraintViolation.getMessage()).rejectedValue(constraintViolation.getInvalidValue()).context(constraintViolation.getPropertyPath().toString()).build())::iterator).build());
        }
        return this.buildResponse(HttpStatus.BAD_REQUEST, exception.getMessage());
    }

    @ExceptionHandler
    public ResponseEntity handleDatabaseServiceDownException(DatabaseServiceDownException exception) {
        return this.buildResponse(HttpStatus.SERVICE_UNAVAILABLE, exception.getMessage());
    }

    @ExceptionHandler
    public ResponseEntity handleDocumentCorruptedException(DocumentCorruptedException exception) {
        LOGGER.error("Data corrupt exception: {}", (Object)exception.getMessage(), (Object)exception);
        return this.buildResponse(HttpStatus.UNPROCESSABLE_ENTITY, exception.getMessage());
    }

    @ExceptionHandler
    public ResponseEntity handleTenantContextRequiredException(TenantContextRequiredException exception) {
        return this.buildResponse(HttpStatus.NOT_FOUND, exception.getMessage());
    }

    @ExceptionHandler
    public ResponseEntity handleDatabaseException(DatabaseException exception) {
        return this.buildResponse(HttpStatus.INTERNAL_SERVER_ERROR, exception.getMessage());
    }

    protected ResponseEntity<Errors> buildResponse(HttpStatus httpStatus, String reason) {
        LOGGER.error("Data access error (" + httpStatus.value() + "): " + reason);
        return ResponseEntity.status((HttpStatus)httpStatus).contentType(MediaType.APPLICATION_JSON).body((Object)ImmutableErrors.builder().error(httpStatus.getReasonPhrase()).status(Integer.valueOf(httpStatus.value())).message(reason).build());
    }
}

