/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.sp;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.db.assets.AssetFormDatabase;
import io.dialob.db.assets.repository.AssetRepository;
import io.dialob.db.assets.repository.GenericAssetRepository;
import io.dialob.db.assets.serialization.AssetFormDeserializer;
import io.dialob.db.assets.serialization.AssetFormMetadataRowDeserializer;
import io.dialob.db.assets.serialization.AssetFormSerializer;
import io.dialob.db.dialob.api.DialobApiDbSettings;
import io.dialob.db.dialob.api.DialobApiFormDatabase;
import io.dialob.db.dialob.api.DialobApiQuestionnaireDatabase;
import io.dialob.db.dialob.api.DialobApiTemplate;
import io.dialob.db.file.FormFileDatabase;
import io.dialob.db.file.QuestionnaireFileDatabase;
import io.dialob.db.jdbc.DatabaseHelper;
import io.dialob.db.jdbc.JdbcFormDatabase;
import io.dialob.db.jdbc.JdbcQuestionnaireDatabase;
import io.dialob.db.jdbc.JdbcVersionControlledFormDatabase;
import io.dialob.db.jdbc.MySQLDatabaseHelper;
import io.dialob.db.jdbc.PostgreSQLDatabaseHelper;
import io.dialob.db.mongo.MongoQuestionnaireIdObfuscator;
import io.dialob.db.mongo.database.MongoDbFormDatabase;
import io.dialob.db.mongo.database.MongoDbQuestionnaireDatabase;
import io.dialob.db.mongo.repository.FormRepository;
import io.dialob.db.mongo.repository.QuestionnaireRepository;
import io.dialob.db.s3.FormS3Database;
import io.dialob.db.s3.QuestionnaireS3Database;
import io.dialob.db.sp.ConditionalOnDatabaseType;
import io.dialob.db.spi.spring.DatabaseExceptionMapper;
import io.dialob.form.service.api.FormDatabase;
import io.dialob.form.service.api.FormVersionControlDatabase;
import io.dialob.questionnaire.service.api.QuestionnaireDatabase;
import io.dialob.settings.DialobSettings;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.lang.NonNull;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;
import software.amazon.awssdk.services.s3.S3Client;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={DialobSettings.class})
@Import(value={DatabaseExceptionMapper.class})
public class DialobDbSpAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnDatabaseType(value=DialobSettings.DatabaseType.ASSETS)
    public class DialobDbAssetsAutoConfiguration {
        @Bean
        public FormDatabase assetFormDatabase(ObjectMapper objectMapper, DialobSettings settings) {
            RestTemplate restTemplate = new RestTemplate();
            GenericAssetRepository assetRepository = new GenericAssetRepository(restTemplate, settings, objectMapper);
            AssetFormSerializer assetFormSerializer = new AssetFormSerializer(objectMapper);
            AssetFormDeserializer assetFormDeserializer = new AssetFormDeserializer(objectMapper);
            AssetFormMetadataRowDeserializer assetFormMetadataRowDeserializer = new AssetFormMetadataRowDeserializer(objectMapper);
            return new AssetFormDatabase((AssetRepository)assetRepository, assetFormSerializer, assetFormDeserializer, assetFormMetadataRowDeserializer);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnDatabaseType(value=DialobSettings.DatabaseType.DIALOBAPIDB)
    @EnableConfigurationProperties(value={DialobApiDbSettings.class})
    public class DialobDbDialobApiAutoConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={DialobApiTemplate.class})
        public DialobApiTemplate dialobApiTemplate(DialobApiDbSettings settings) {
            RestTemplate restTemplate = new RestTemplate();
            return new DialobApiTemplate(restTemplate, settings);
        }

        @Bean
        @ConditionalOnProperty(prefix="dialob.formDatabase", name={"database-type"}, havingValue="DIALOBAPIDB", matchIfMissing=true)
        public FormDatabase formDatabase(DialobApiTemplate dialobApiTemplate) {
            return new DialobApiFormDatabase(dialobApiTemplate);
        }

        @Bean
        @ConditionalOnProperty(prefix="dialob.questionnaireDatabase", name={"database-type"}, havingValue="DIALOBAPIDB", matchIfMissing=true)
        public QuestionnaireDatabase questionnaireDatabase(DialobApiTemplate dialobApiTemplate) {
            return new DialobApiQuestionnaireDatabase(dialobApiTemplate);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnDatabaseType(value=DialobSettings.DatabaseType.S3)
    public static class DialobDbS3AutoConfiguration {
        @Bean
        @ConditionalOnProperty(prefix="dialob.formDatabase", name={"database-type"}, havingValue="S3", matchIfMissing=true)
        public FormDatabase formDatabase(S3Client s3Client, ObjectMapper objectMapper, DialobSettings settings) {
            return new FormS3Database(s3Client, objectMapper, Objects.requireNonNull(settings.getFormDatabase().getS3().getBucket(), "Define S3 bucket for forms"), StringUtils.defaultString((String)settings.getFormDatabase().getS3().getPrefix(), (String)"forms/"));
        }

        @Bean
        @ConditionalOnProperty(prefix="dialob.questionnaireDatabase", name={"database-type"}, havingValue="S3", matchIfMissing=true)
        public QuestionnaireDatabase questionnaireDatabase(S3Client s3Client, ObjectMapper objectMapper, DialobSettings settings) {
            return new QuestionnaireS3Database(s3Client, objectMapper, Objects.requireNonNull(settings.getFormDatabase().getS3().getBucket(), "Define S3 bucket for questionnaires"), StringUtils.defaultString((String)settings.getQuestionnaireDatabase().getS3().getPrefix(), (String)"questionnaires/"));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnDatabaseType(value=DialobSettings.DatabaseType.FILEDB)
    public static class DialobDbFileAutoConfiguration {
        private String directory(@NonNull String baseDirectory, @NonNull String type) {
            File directory = new File(baseDirectory);
            Assert.isTrue((boolean)directory.exists(), (String)("File db directory " + baseDirectory + " do not exists"));
            Assert.isTrue((boolean)directory.isDirectory(), (String)("File db directory " + baseDirectory + " is not directory"));
            return directory.toPath().resolve(type).toString();
        }

        @Bean
        @ConditionalOnProperty(prefix="dialob.formDatabase", name={"database-type"}, havingValue="FILEDB", matchIfMissing=true)
        public FormDatabase formDatabase(ObjectMapper objectMapper, DialobSettings dialobSettings) {
            return new FormFileDatabase(this.directory(dialobSettings.getDb().getFile().getDirectory(), "forms"), objectMapper);
        }

        @Bean
        @ConditionalOnProperty(prefix="dialob.questionnaireDatabase", name={"database-type"}, havingValue="FILEDB", matchIfMissing=true)
        public QuestionnaireDatabase questionnaireDatabase(ObjectMapper objectMapper, DialobSettings dialobSettings) {
            return new QuestionnaireFileDatabase(this.directory(dialobSettings.getDb().getFile().getDirectory(), "questionnaires"), objectMapper);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnDatabaseType(value=DialobSettings.DatabaseType.JDBC)
    public static class DialobDbJdbcAutoConfiguration {
        private final JdbcVersionControlledFormDatabase versionControlledFormDatabase;
        private final JdbcQuestionnaireDatabase jdbcQuestionnaireDatabase;
        private final String schema;

        public DialobDbJdbcAutoConfiguration(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, ObjectMapper objectMapper, DialobSettings settings) {
            DatabaseHelper databaseHelper = this.databaseHandler(jdbcTemplate.getDataSource(), settings.getDb().getJdbc().getSchema());
            this.schema = settings.getDb().getJdbc().getSchema();
            Predicate<String> isAnyTenantPredicate = tenantId -> false;
            if (settings.getTenant().getMode() == DialobSettings.TenantSettings.Mode.FIXED) {
                isAnyTenantPredicate = tenantId -> settings.getTenant().getFixedId().equals(tenantId);
            }
            this.versionControlledFormDatabase = new JdbcVersionControlledFormDatabase(jdbcTemplate, this.schema, databaseHelper, transactionTemplate, (FormDatabase)new JdbcFormDatabase(jdbcTemplate, databaseHelper, transactionTemplate, objectMapper, this.schema, isAnyTenantPredicate), isAnyTenantPredicate, objectMapper);
            this.jdbcQuestionnaireDatabase = new JdbcQuestionnaireDatabase(jdbcTemplate, databaseHelper, transactionTemplate, objectMapper, this.schema, Optional.of(this.versionControlledFormDatabase), isAnyTenantPredicate);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        DatabaseHelper databaseHandler(DataSource dataSource, String schema) {
            try (Connection connection = dataSource.getConnection();){
                String databaseProductName;
                switch (databaseProductName = connection.getMetaData().getDatabaseProductName()) {
                    case "PostgreSQL": {
                        PostgreSQLDatabaseHelper postgreSQLDatabaseHelper = new PostgreSQLDatabaseHelper(schema);
                        return postgreSQLDatabaseHelper;
                    }
                    case "MySQL": {
                        MySQLDatabaseHelper mySQLDatabaseHelper = new MySQLDatabaseHelper(schema);
                        return mySQLDatabaseHelper;
                    }
                }
                throw new IllegalStateException("Unsupported database " + databaseProductName);
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }

        @Bean
        @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
        public static PlatformTransactionManager platformTransactionManager(DataSource dataSource) {
            return new DataSourceTransactionManager(dataSource);
        }

        @Bean
        @ConditionalOnMissingBean(value={TransactionTemplate.class})
        public static TransactionTemplate transactionTemplate(PlatformTransactionManager platformTransactionManager) {
            return new TransactionTemplate(platformTransactionManager);
        }

        @Bean
        @ConditionalOnProperty(prefix="dialob.formDatabase", name={"database-type"}, havingValue="JDBC", matchIfMissing=true)
        public FormVersionControlDatabase formVersionControlDatabase() {
            return (FormVersionControlDatabase)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{FormVersionControlDatabase.class}, (o, method, objects) -> {
                try {
                    return method.invoke((Object)this.versionControlledFormDatabase, objects);
                }
                catch (InvocationTargetException ite) {
                    if (ite.getTargetException() instanceof RuntimeException) {
                        throw ite.getTargetException();
                    }
                    throw ite;
                }
            });
        }

        @Bean
        @ConditionalOnProperty(prefix="dialob.formDatabase", name={"database-type"}, havingValue="JDBC", matchIfMissing=true)
        public FormDatabase formDatabase() {
            return (FormDatabase)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{FormDatabase.class}, (o, method, objects) -> {
                try {
                    return method.invoke((Object)this.versionControlledFormDatabase, objects);
                }
                catch (InvocationTargetException ite) {
                    if (ite.getTargetException() instanceof RuntimeException) {
                        throw ite.getTargetException();
                    }
                    throw ite;
                }
            });
        }

        @Bean
        public QuestionnaireDatabase questionnaireDatabase() {
            return this.jdbcQuestionnaireDatabase;
        }
    }

    @ConditionalOnDatabaseType(value=DialobSettings.DatabaseType.MONGODB)
    @EnableMongoRepositories
    public static class DialobDbMongoAutoConfiguration {
        @Bean
        @ConditionalOnProperty(prefix="dialob.formDatabase", name={"database-type"}, havingValue="MONGODB", matchIfMissing=true)
        public FormDatabase formDatabase(FormRepository repository) {
            return new MongoDbFormDatabase(repository);
        }

        @Bean
        @ConditionalOnProperty(prefix="dialob.questionnaireDatabase", name={"database-type"}, havingValue="MONGODB", matchIfMissing=true)
        public QuestionnaireDatabase questionnaireDatabase(QuestionnaireRepository repository, MongoQuestionnaireIdObfuscator mongoQuestionnaireIdObfuscator) {
            return new MongoDbQuestionnaireDatabase(repository, mongoQuestionnaireIdObfuscator);
        }

        @Bean
        @ConditionalOnMissingBean(value={MongoQuestionnaireIdObfuscator.class})
        public MongoQuestionnaireIdObfuscator mongoQuestionnaireIdObfuscator() {
            return new MongoQuestionnaireIdObfuscator();
        }
    }
}

