/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.s3;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.api.questionnaire.ImmutableQuestionnaire;
import io.dialob.api.questionnaire.ImmutableQuestionnaireMetadata;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.db.s3.AbstractS3Database;
import io.dialob.questionnaire.service.api.ImmutableMetadataRow;
import io.dialob.questionnaire.service.api.QuestionnaireDatabase;
import java.util.Date;
import java.util.function.Consumer;
import org.springframework.lang.NonNull;
import software.amazon.awssdk.services.s3.S3Client;

public class QuestionnaireS3Database
extends AbstractS3Database<Questionnaire>
implements QuestionnaireDatabase {
    public QuestionnaireS3Database(S3Client s3Client, ObjectMapper objectMapper, String bucketName, String prefix) {
        super(s3Client, Questionnaire.class, objectMapper, bucketName, prefix);
    }

    public void findAllMetadata(String tenantId, String ownerId, String formId, String formName, String formTag, Questionnaire.Metadata.Status status, @NonNull Consumer<QuestionnaireDatabase.MetadataRow> consumer) {
        this.forAllObjects(tenantId, object -> {
            String id = this.extractObjectName(object.key());
            consumer.accept((QuestionnaireDatabase.MetadataRow)ImmutableMetadataRow.of((String)id, (Questionnaire.Metadata)ImmutableQuestionnaireMetadata.builder().lastAnswer(new Date(object.lastModified().toEpochMilli())).build()));
        });
    }

    @NonNull
    protected Questionnaire updateDocumentId(@NonNull Questionnaire document, String id) {
        return ImmutableQuestionnaire.builder().from(document).id(id).build();
    }

    @NonNull
    protected Questionnaire updateDocumentRev(@NonNull Questionnaire document, String rev) {
        return ImmutableQuestionnaire.builder().from(document).rev(rev).build();
    }

    @Override
    protected String tenantPrefix(String tenantId) {
        return "questionnaires/" + tenantId;
    }
}

