/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.s3;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.db.s3.VersionConflictException;
import io.dialob.db.spi.exceptions.DocumentCorruptedException;
import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import io.dialob.db.spi.spring.AbstractDocumentDatabase;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;

public abstract class AbstractS3Database<F>
extends AbstractDocumentDatabase<F> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractS3Database.class);
    private final S3Client s3Client;
    private final ObjectMapper objectMapper;
    private final String bucketName;
    private final String prefix;

    public AbstractS3Database(@NonNull S3Client s3Client, @NonNull Class<F> documentClass, @NonNull ObjectMapper objectMapper, @NonNull String bucketName, @NonNull String prefix) {
        super(documentClass);
        this.s3Client = s3Client;
        this.objectMapper = objectMapper;
        this.bucketName = bucketName;
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    protected abstract String tenantPrefix(String var1);

    protected String objectName(String tenantId, String id) {
        return this.tenantPrefix(tenantId) + "/" + id;
    }

    protected String extractObjectName(String key) {
        return key.substring(key.lastIndexOf("/") + 1);
    }

    @NonNull
    public F findOne(String tenantId, @NonNull String id, String rev) {
        try {
            String objectName = this.objectName(tenantId, id);
            ResponseInputStream s3Object = this.s3Client.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName).key(objectName).build());
            return this.loadFile(objectName, (InputStream)s3Object);
        }
        catch (NoSuchKeyException e) {
            throw new DocumentNotFoundException("No form document \"" + id + "\"");
        }
        catch (S3Exception e) {
            LOGGER.error("err", (Throwable)e);
            throw e;
        }
    }

    public F loadFile(String objectName, InputStream inputStream) {
        try {
            return (F)this.objectMapper.readValue(inputStream, this.getDocumentClass());
        }
        catch (IOException e) {
            LOGGER.error("Object " + objectName + " is corrupted.", (Throwable)e);
            return null;
        }
    }

    @NonNull
    public F findOne(String tenantId, @NonNull String id) {
        return this.findOne(tenantId, id, null);
    }

    protected void forAllObjects(String tenantId, @NonNull Consumer<S3Object> fileConsumer) {
        ListObjectsV2Response result;
        String continuationToken = null;
        do {
            result = this.s3Client.listObjectsV2((ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucketName).prefix(this.tenantPrefix(tenantId)).continuationToken(continuationToken).build());
            result.contents().forEach(fileConsumer::accept);
        } while (StringUtils.isNotBlank((CharSequence)(continuationToken = result.nextContinuationToken())));
    }

    public boolean exists(String tenantId, @NonNull String id) {
        try {
            HeadObjectResponse response = this.s3Client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucketName).key(this.objectName(tenantId, id)).build());
            return response.sdkHttpResponse().isSuccessful();
        }
        catch (NoSuchKeyException e) {
            return false;
        }
    }

    public boolean delete(String tenantId, @NonNull String id) {
        if (this.exists(tenantId, id)) {
            this.s3Client.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucketName).key(this.objectName(tenantId, id)).build());
            return true;
        }
        return false;
    }

    @NonNull
    public F save(String tenantId, @NonNull F document) {
        String id = this.id(document);
        String rev = this.rev(document);
        if (!StringUtils.isBlank((CharSequence)id)) {
            try {
                F previousVersion = this.findOne(tenantId, id);
                if (rev == null || !rev.equals(this.rev(previousVersion))) {
                    throw new VersionConflictException(id + " revision " + this.rev(previousVersion) + " do not match with " + rev);
                }
                document = this.updateDocumentRev(document, Integer.toString(Integer.parseInt(rev) + 1));
            }
            catch (DocumentNotFoundException e) {
                document = this.initNewDocument(document);
                id = this.id(document);
            }
        } else {
            document = this.initNewDocument(document);
            id = this.id(document);
        }
        try {
            this.s3Client.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName).key(this.objectName(tenantId, id)).build(), RequestBody.fromBytes((byte[])this.objectMapper.writeValueAsBytes(document)));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to write document " + id, (Throwable)e);
            throw new DocumentCorruptedException("Cannot update document " + id);
        }
        catch (SdkClientException e) {
            LOGGER.error("Failed to write document " + id, (Throwable)e);
            throw new DocumentCorruptedException("Cannot update document " + id);
        }
        return document;
    }

    private F initNewDocument(F document) {
        document = this.updateDocumentId(document, this.createUuid());
        document = this.updateDocumentRev(document, "1");
        return document;
    }

    protected String createUuid() {
        return UUID.randomUUID().toString().replace("-", "");
    }
}

