/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.mongo.database;

import io.dialob.api.questionnaire.ModifiableQuestionnaire;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.db.mongo.MongoQuestionnaireIdObfuscator;
import io.dialob.db.mongo.database.BaseMongoDbDatabase;
import io.dialob.db.mongo.repository.QuestionnaireRepository;
import io.dialob.questionnaire.service.api.ImmutableMetadataRow;
import io.dialob.questionnaire.service.api.QuestionnaireDatabase;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class MongoDbQuestionnaireDatabase
extends BaseMongoDbDatabase<Questionnaire, ModifiableQuestionnaire, QuestionnaireRepository>
implements QuestionnaireDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbQuestionnaireDatabase.class);
    private final MongoQuestionnaireIdObfuscator mongoQuestionnaireIdObfuscator;

    public MongoDbQuestionnaireDatabase(QuestionnaireRepository repository, MongoQuestionnaireIdObfuscator mongoQuestionnaireIdObfuscator) {
        super(repository);
        this.mongoQuestionnaireIdObfuscator = mongoQuestionnaireIdObfuscator;
    }

    @Override
    protected String toPublicId(String id) {
        return this.mongoQuestionnaireIdObfuscator.toPublicId(id);
    }

    @Override
    protected String toMongoId(String id) {
        return this.mongoQuestionnaireIdObfuscator.toMongoId(id);
    }

    @Override
    protected ModifiableQuestionnaire toMongo(Questionnaire document) {
        String extId = document.getId();
        String id = null;
        if (StringUtils.isBlank((CharSequence)extId)) {
            extId = null;
        }
        if (extId != null && (id = this.toMongoId(extId)) == null) {
            LOGGER.warn("DATA CORRUPT: Cannot convert external Id '{}' to mongo.", (Object)extId);
            return null;
        }
        return ModifiableQuestionnaire.create().from(document).setId(id);
    }

    @Override
    protected Questionnaire toPublic(Questionnaire document) {
        return document;
    }

    @Override
    @NonNull
    public Questionnaire findOne(String tenantId, @NonNull String id) {
        return (Questionnaire)super.findOne("none", id);
    }

    @Override
    public boolean exists(String tenantId, @NonNull String id) {
        return super.exists("none", id);
    }

    @Override
    public boolean delete(String tenantId, @NonNull String id) {
        return super.delete("none", id);
    }

    public void findAllMetadata(String tenantId, String ownerId, String formId, String formName, String formTag, Questionnaire.Metadata.Status status, @NonNull Consumer<QuestionnaireDatabase.MetadataRow> consumer) {
        this.doMongo(repository -> {
            repository.findAllMetadata().stream().forEach(document -> consumer.accept((QuestionnaireDatabase.MetadataRow)ImmutableMetadataRow.of((String)this.toPublicId(document.getId()), (Questionnaire.Metadata)document.getMetadata())));
            return null;
        });
    }
}

