/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.mongo.database;

import com.mongodb.Function;
import io.dialob.db.spi.exceptions.DatabaseServiceDownException;
import io.dialob.db.spi.exceptions.DatabaseUnauthorizedException;
import io.dialob.db.spi.exceptions.DocumentConflictException;
import io.dialob.db.spi.exceptions.DocumentCorruptedException;
import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.lang.NonNull;

public abstract class BaseMongoDbDatabase<T, M extends T, R extends MongoRepository<M, String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseMongoDbDatabase.class);
    protected final R repository;

    BaseMongoDbDatabase(R repository) {
        this.repository = repository;
    }

    <A> A doMongo(Function<R, A> action) {
        try {
            return (A)action.apply(this.repository);
        }
        catch (PermissionDeniedDataAccessException e) {
            throw new DatabaseUnauthorizedException("Could not access: " + e.getMessage());
        }
        catch (ConcurrencyFailureException e) {
            throw new DocumentConflictException(e.getMessage());
        }
        catch (NonTransientDataAccessException e) {
            LOGGER.error("Database access failure.", (Throwable)e);
            throw new DatabaseServiceDownException("Database access failure: " + e.getMessage());
        }
    }

    protected String toMongoId(String id) {
        return id;
    }

    protected String toPublicId(String id) {
        return id;
    }

    protected T toPublic(T document) {
        return document;
    }

    protected abstract M toMongo(T var1);

    @NonNull
    public T findOne(String tenantId, @NonNull String id, String rev) {
        return (T)this.doMongo(repository -> {
            String mongoId = this.toMongoId(id);
            Optional document = Optional.empty();
            if (mongoId != null) {
                document = repository.findById((Object)mongoId);
            }
            if (!document.isPresent()) {
                throw new DocumentNotFoundException("not_found");
            }
            return document.get();
        });
    }

    @NonNull
    public T findOne(String tenantId, @NonNull String id) {
        return this.findOne(tenantId, id, null);
    }

    public boolean exists(String tenantId, @NonNull String id) {
        return (Boolean)this.doMongo(repository -> {
            String mongoId = this.toMongoId(id);
            if (mongoId == null) {
                return false;
            }
            return repository.existsById((Object)mongoId);
        });
    }

    public boolean delete(String tenantId, @NonNull String id) {
        return (Boolean)this.doMongo(repository -> {
            String mongoId = this.toMongoId(id);
            if (mongoId == null) {
                throw new DocumentNotFoundException("not_found");
            }
            repository.deleteById((Object)mongoId);
            return true;
        });
    }

    @NonNull
    public T save(String tenantId, @NonNull T document) {
        return (T)this.doMongo(repository -> {
            M mongoDocument = this.toMongo(document);
            if (mongoDocument == null) {
                throw new DocumentCorruptedException("invalid_id");
            }
            return this.toPublic(repository.save(mongoDocument));
        });
    }
}

