/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.jdbc;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.api.form.Form;
import io.dialob.api.form.FormTag;
import io.dialob.api.form.ImmutableForm;
import io.dialob.api.form.ImmutableFormMetadata;
import io.dialob.api.form.ImmutableFormTag;
import io.dialob.db.jdbc.DatabaseHelper;
import io.dialob.db.jdbc.JdbcDatabase;
import io.dialob.db.jdbc.Utils;
import io.dialob.db.spi.exceptions.DocumentConflictException;
import io.dialob.db.spi.exceptions.DocumentCorruptedException;
import io.dialob.db.spi.exceptions.DocumentLockedException;
import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import io.dialob.db.spi.exceptions.TenantContextRequiredException;
import io.dialob.form.service.api.FormDatabase;
import io.dialob.form.service.api.FormVersionControlDatabase;
import io.dialob.form.service.api.ImmutableFormMetadataRow;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionTemplate;

public class JdbcVersionControlledFormDatabase
implements FormDatabase,
FormVersionControlDatabase,
JdbcDatabase {
    public static final String LATEST = "LATEST";
    protected final JdbcTemplate jdbcTemplate;
    protected final TransactionTemplate transactionTemplate;
    protected final FormDatabase formDatabase;
    protected String formTableName;
    protected String formRevTableName;
    protected final DatabaseHelper databaseHelper;
    protected final Predicate<String> isAnyTenantPredicate;
    protected final ObjectMapper objectMapper;
    private final RowMapper<FormTag> formTagRowMapper = (rs, rowNum) -> ImmutableFormTag.builder().formName(rs.getString(1)).name(rs.getString(2)).description(rs.getString(3)).created((Date)rs.getTimestamp(4)).formId(Utils.toString(this.getDatabaseHelper().fromJdbcId(rs.getBytes(5)))).type(FormTag.Type.valueOf((String)rs.getString(6).trim())).refName(rs.getString(7)).build();

    public JdbcVersionControlledFormDatabase(JdbcTemplate jdbcTemplate, String schema, DatabaseHelper databaseHelper, TransactionTemplate transactionTemplate, FormDatabase formDatabase, Predicate<String> isAnyTenantPredicate, ObjectMapper objectMapper) {
        this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate);
        this.databaseHelper = Objects.requireNonNull(databaseHelper);
        this.transactionTemplate = Objects.requireNonNull(transactionTemplate);
        this.formDatabase = Objects.requireNonNull(formDatabase);
        this.formTableName = this.databaseHelper.tableName(schema, "form");
        this.formRevTableName = this.databaseHelper.tableName(schema, "form_rev");
        this.isAnyTenantPredicate = Objects.requireNonNull(isAnyTenantPredicate);
        this.objectMapper = objectMapper;
    }

    private boolean notAnyTenant(String tenantId) {
        return !this.isAnyTenantPredicate.test(tenantId);
    }

    private void assertTenantContextDefined(String tenantId) {
        if (tenantId == null) {
            throw new TenantContextRequiredException("Service requires tenant context.");
        }
    }

    public boolean formNameExists(String tenantId, String formName) {
        this.assertTenantContextDefined(tenantId);
        return this.doTransaction(template -> {
            Integer count = (Integer)template.queryForObject("select count(*) from " + this.formTableName + " where name = ? and tenant_id = ?", Integer.class, new Object[]{formName, tenantId});
            return count != null && count > 0;
        });
    }

    public boolean isFormDocumentTagged(String tenantId, String formDocumentId) {
        this.assertTenantContextDefined(tenantId);
        return this.doTransaction(template -> {
            Integer count = (Integer)template.queryForObject("select count(*) from " + this.formRevTableName + " where form_document_id = ? and tenant_id = ?", Integer.class, new Object[]{this.toJdbcId(Utils.toOID(formDocumentId)), tenantId});
            return count != null && count > 0;
        });
    }

    public boolean createControlledForm(String tenantId, String formName, String formDocumentId, String label) {
        this.assertTenantContextDefined(tenantId);
        return this.doTransaction(template -> {
            byte[] oid = Utils.toOID(formDocumentId);
            int updated = template.update("insert into " + this.formTableName + " (tenant_id,name,latest_form_id,label) values (?,?,?,?)", new Object[]{tenantId, formName, this.toJdbcId(oid), label});
            return updated > 0;
        });
    }

    public Optional<FormTag> createTag(@NonNull String tenantId, @NonNull String formName, String newTag, String description, String formDocumentIdOrRefName, @NonNull FormTag.Type type) {
        this.assertTenantContextDefined(tenantId);
        try {
            String resolvedFormDocumentId = null;
            String resolvedRefName = null;
            if (type == FormTag.Type.NORMAL) {
                resolvedFormDocumentId = formDocumentIdOrRefName;
                resolvedRefName = null;
                if (!this.exists(tenantId, resolvedFormDocumentId)) {
                    return Optional.empty();
                }
            } else {
                resolvedRefName = formDocumentIdOrRefName;
                resolvedFormDocumentId = this.findTag(tenantId, formName, resolvedRefName).map(FormTag::getFormId).orElse(null);
                if (resolvedFormDocumentId == null) {
                    return Optional.empty();
                }
            }
            String formDocumentId = resolvedFormDocumentId;
            String refName = resolvedRefName;
            return this.doTransaction(template -> {
                ArrayList<Object> sqlParameters = new ArrayList<Object>();
                sqlParameters.add(newTag);
                sqlParameters.add(description);
                sqlParameters.add(this.toJdbcId(Utils.toOID(formDocumentId)));
                sqlParameters.add(type.name());
                sqlParameters.add(refName);
                StringBuilder where = new StringBuilder(" where name = ?");
                sqlParameters.add(formName);
                where.append(" and tenant_id = ?");
                sqlParameters.add(tenantId);
                int updated = template.update("insert into " + this.formRevTableName + " (tenant_id,form_name, name, description, form_document_id, type, ref_name) select tenant_id, name, ?, ?, ?, ?, ? from " + this.formTableName + where.toString(), sqlParameters.toArray());
                if (updated > 0) {
                    return this.findTag(tenantId, formName, newTag);
                }
                return Optional.empty();
            });
        }
        catch (DuplicateKeyException exception) {
            throw new DocumentConflictException("Form \"" + formName + "\" tag \"" + newTag + "\" exists already.");
        }
    }

    public Optional<FormTag> createTagOnLatest(String tenantId, @NonNull String formName, String tag, String description, boolean snapshot) {
        this.assertTenantContextDefined(tenantId);
        if (snapshot) {
            String latestFormId = this.findTag(tenantId, formName, LATEST).map(FormTag::getFormId).orElse(null);
            if (latestFormId == null) {
                return Optional.empty();
            }
            latestFormId = this.createSnapshot(tenantId, latestFormId);
            return this.createTag(tenantId, formName, tag, description, latestFormId, FormTag.Type.NORMAL);
        }
        try {
            return this.doTransaction(template -> {
                ArrayList<String> sqlParameters = new ArrayList<String>();
                sqlParameters.add(tag);
                sqlParameters.add(description);
                sqlParameters.add(FormTag.Type.NORMAL.name());
                StringBuilder where = new StringBuilder(" where name = ?");
                sqlParameters.add(formName);
                where.append(" and tenant_id = ?");
                sqlParameters.add(tenantId);
                int updated = template.update("insert into " + this.formRevTableName + " (tenant_id, form_name, name, description, type, form_document_id) select tenant_id, name, ?, ?, ?, latest_form_id from " + this.formTableName + where, sqlParameters.toArray());
                if (updated > 0) {
                    return this.findTag(tenantId, formName, tag);
                }
                return Optional.empty();
            });
        }
        catch (DuplicateKeyException exception) {
            throw new DocumentConflictException("Form \"" + formName + "\" tag \"" + tag + "\" exists already.");
        }
    }

    public boolean deleteTag(String tenantId, @NonNull String formName, String tag) {
        this.assertTenantContextDefined(tenantId);
        return this.doTransaction(template -> {
            int updated = template.update("delete from " + this.formRevTableName + " where name = ? and form_name = ? and tenant_id = ? and type = 'MUTABLE'", new Object[]{tag, formName, tenantId});
            return updated > 0;
        });
    }

    public boolean updateLabel(String tenantId, @NonNull String formName, String label) {
        this.assertTenantContextDefined(tenantId);
        return this.doTransaction(template -> {
            int updated = template.update("update " + this.formTableName + " set label = ?, updated = current_timestamp where name = ? and tenant_id = ?", new Object[]{label, formName, tenantId});
            return updated > 0;
        });
    }

    public String createSnapshot(String tenantId, @NonNull String formId) {
        this.assertTenantContextDefined(tenantId);
        Form form = this.getFormDatabase().findOne(tenantId, formId);
        form = this.formDatabase.save(tenantId, (Form)ImmutableForm.builder().from(form).id(null).rev(null).build());
        return form.getId();
    }

    public boolean updateLatest(String tenantId, @NonNull String formId, @NonNull FormTag tag) {
        this.assertTenantContextDefined(tenantId);
        if (!LATEST.equalsIgnoreCase(tag.getName()) || tag.getFormId() == null) {
            return false;
        }
        if (!this.getFormDatabase().exists(tenantId, tag.getFormId())) {
            return false;
        }
        return this.doTransaction(template -> {
            byte[] oid = Utils.toOID(tag.getFormId());
            int updated = template.update("update " + this.formTableName + " set latest_form_id = ?, updated = current_timestamp where name = ? and tenant_id = ?", new Object[]{this.toJdbcId(oid), formId, tenantId});
            return updated > 0;
        });
    }

    public boolean isName(String tenantId, @NonNull String formId) {
        this.assertTenantContextDefined(tenantId);
        return this.doTransaction(template -> {
            Integer count = (Integer)template.queryForObject("select count(*) from " + this.formTableName + " where name = ? and tenant_id = ?", Integer.class, new Object[]{formId, tenantId});
            return count != null && count > 0;
        });
    }

    @NonNull
    public List<FormTag> findTags(String tenantId, @NonNull String formId, FormTag.Type type) {
        this.assertTenantContextDefined(tenantId);
        return this.doTransaction(template -> {
            byte[] oid = null;
            try {
                oid = Utils.toOID(formId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ArrayList<Object> sqlParameters = new ArrayList<Object>();
            Object where = "form_name = ?";
            sqlParameters.add(formId);
            if (oid != null) {
                where = (String)where + " or form_document_id = ?";
                sqlParameters.add(this.toJdbcId(oid));
            }
            where = "(" + (String)where + ")";
            if (type != null) {
                where = (String)where + " and type = ?";
                sqlParameters.add(type.name());
            }
            where = (String)where + " and tenant_id = ?";
            sqlParameters.add(tenantId);
            return template.query("select form_name, name, description, created, form_document_id, type, ref_name from " + this.formRevTableName + " where " + (String)where, this.formTagRowMapper, sqlParameters.toArray());
        });
    }

    public Optional<FormTag> findTag(String tenantId, @NonNull String formName, @Nullable String name) {
        this.assertTenantContextDefined(tenantId);
        return this.doTransaction(template -> {
            try {
                if (name == null || name.equalsIgnoreCase(LATEST)) {
                    return Optional.ofNullable((FormTag)template.queryForObject("select name, 'LATEST', null, created, latest_form_id, 'NORMAL', null from " + this.formTableName + " where name = ? and tenant_id = ?", this.formTagRowMapper, new Object[]{formName, tenantId}));
                }
                return Optional.ofNullable((FormTag)template.queryForObject("select form_name, name, description, created, form_document_id, type, ref_name from " + this.formRevTableName + " where form_name = ? and name = ? and tenant_id = ?", this.formTagRowMapper, new Object[]{formName, name, tenantId}));
            }
            catch (EmptyResultDataAccessException e) {
                return Optional.empty();
            }
        });
    }

    @NonNull
    public List<FormTag> queryTags(String tenantId, String formName, String formId, String name, FormTag.Type type) {
        this.assertTenantContextDefined(tenantId);
        return this.doTransaction(template -> {
            ArrayList<Object> params = new ArrayList<Object>();
            ArrayList<String> terms = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)formName)) {
                params.add(formName);
                terms.add("form_name = ?");
            }
            if (StringUtils.isNotBlank((CharSequence)formId)) {
                params.add(this.toJdbcId(Utils.toOID(formId)));
                terms.add("form_document_id = ?");
            }
            if (StringUtils.isNotBlank((CharSequence)name)) {
                params.add(name);
                terms.add("name = ?");
            }
            if (type != null) {
                params.add(type.name());
                terms.add("type = ?");
            }
            terms.add("tenant_id = ?");
            params.add(tenantId);
            Object where = "";
            if (!terms.isEmpty()) {
                where = " where " + String.join((CharSequence)" and ", terms);
            }
            return template.query("select form_name, name, description, created, form_document_id, type, ref_name from " + this.formRevTableName + (String)where, this.formTagRowMapper, params.toArray(new Object[0]));
        });
    }

    public Optional<FormTag> moveTag(String tenantId, FormTag updateTag) {
        this.assertTenantContextDefined(tenantId);
        if (StringUtils.isBlank((CharSequence)updateTag.getRefName())) {
            return Optional.empty();
        }
        return this.doTransaction(template -> this.findTag(tenantId, updateTag.getFormName(), updateTag.getRefName()).map(tag -> {
            if (tag.getType() != FormTag.Type.NORMAL) {
                throw new DocumentCorruptedException(String.format("Referred tag must be immutable", updateTag.getFormName(), updateTag.getName()));
            }
            int count = template.update("update " + this.formRevTableName + " set updated = current_timestamp, form_document_id = ?, ref_name = ?, description = ? where type = 'MUTABLE' and form_name = ? and name = ? and tenant_id = ?", new Object[]{this.toJdbcId(Utils.toOID(tag.getFormId())), tag.getName(), updateTag.getDescription(), updateTag.getFormName(), updateTag.getName(), tenantId});
            if (count == 0) {
                throw new DocumentNotFoundException(String.format("Form %s mutable tag %s not found", updateTag.getFormName(), updateTag.getName()));
            }
            if (count > 1) {
                throw new DocumentConflictException(String.format("Form %s tag %s is not unique", updateTag.getFormName(), updateTag.getName()));
            }
            return ImmutableFormTag.builder().from(updateTag).formId(tag.getFormId()).refName(tag.getName()).build();
        }));
    }

    public String findFormDocumentId(String tenantId, String formName, String tag) {
        this.assertTenantContextDefined(tenantId);
        if (tag != null && !LATEST.equals(tag)) {
            return this.doTransaction(template -> {
                try {
                    Object oid = template.queryForObject("select form_document_id from " + this.formRevTableName + " where form_name = ? and name = ? and tenant_id = ?", byte[].class, new Object[]{formName, tag, tenantId});
                    return Utils.toString(this.getDatabaseHelper().fromJdbcId(oid));
                }
                catch (EmptyResultDataAccessException e) {
                    return formName;
                }
            });
        }
        return this.doTransaction(template -> {
            try {
                Object oid = template.queryForObject("select latest_form_id from " + this.formTableName + " where name = ? and tenant_id = ?", byte[].class, new Object[]{formName, tenantId});
                return Utils.toString(this.getDatabaseHelper().fromJdbcId(oid));
            }
            catch (EmptyResultDataAccessException e) {
                return formName;
            }
        });
    }

    @NonNull
    public FormDatabase getFormDatabase() {
        return this;
    }

    @NonNull
    public Form findOne(@Nonnull String tenantId, @Nonnull String id, String rev) {
        if (StringUtils.isBlank((CharSequence)rev)) {
            return this.findOne(tenantId, id);
        }
        return this.formDatabase.findOne(tenantId, this.findFormDocumentId(tenantId, id, rev));
    }

    @NonNull
    public Form findOne(@Nonnull String tenantId, @Nonnull String id) {
        return this.formDatabase.findOne(tenantId, this.findFormDocumentId(tenantId, id, null));
    }

    public boolean exists(@Nonnull String tenantId, @Nonnull String id) {
        this.assertTenantContextDefined(tenantId);
        boolean exists = this.doTransaction(template -> {
            Integer count = (Integer)template.queryForObject("select count(*) from " + this.formTableName + " where name = ? and tenant_id = ?", Integer.class, new Object[]{id, tenantId});
            return count != null && count > 0;
        });
        if (!exists) {
            return this.formDatabase.exists(tenantId, id);
        }
        return true;
    }

    public boolean delete(String tenantId, @NonNull String id) {
        this.assertTenantContextDefined(tenantId);
        return this.doTransaction(template -> {
            int count = template.update("delete from " + this.formTableName + " where name = ? and tenant_id = ?", new Object[]{id, tenantId});
            return count > 0;
        });
    }

    @NonNull
    public Form save(String tenantId, @NonNull Form document) {
        if (StringUtils.isNotBlank((CharSequence)document.getId())) {
            if (!this.isFormDocumentTagged(tenantId, document.getId())) {
                document = this.formDatabase.save(tenantId, document);
                this.updateLabel(tenantId, document.getName(), document.getMetadata().getLabel());
                return document;
            }
            throw new DocumentLockedException("form " + document.getId() + " is not editable");
        }
        this.validateNewForm(tenantId, document);
        document = this.formDatabase.save(tenantId, document);
        this.createControlledForm(tenantId, document.getName(), document.getId(), document.getMetadata().getLabel());
        return document;
    }

    public void findAllMetadata(String tenantId, Form.Metadata metadata, @NonNull Consumer<FormDatabase.FormMetadataRow> consumer) {
        this.doTransaction(template -> {
            Object where;
            ArrayList<Object> params = new ArrayList<Object>();
            ArrayList<String> conditions = new ArrayList<String>();
            if (this.notAnyTenant(tenantId)) {
                conditions.add("tenant_id = ?");
                params.add(tenantId);
            }
            if (metadata != null) {
                conditions.add("data->'metadata' @> ?");
                params.add(this.getDatabaseHelper().jsonObject(this.objectMapper, metadata));
            }
            if (StringUtils.isNotBlank((CharSequence)(where = conditions.stream().collect(Collectors.joining(" and "))))) {
                where = " where " + (String)where;
            }
            template.query("select tenant_id, name, created, updated, label from " + this.formTableName + (String)where, rs -> {
                while (rs.next()) {
                    String tId = rs.getString(1);
                    String name = rs.getString(2);
                    Timestamp created = rs.getTimestamp(3);
                    Timestamp updated = rs.getTimestamp(4);
                    String label = rs.getString(5);
                    consumer.accept((FormDatabase.FormMetadataRow)ImmutableFormMetadataRow.of((String)name, (Form.Metadata)ImmutableFormMetadata.builder().created(new Date(created.getTime())).lastSaved(new Date(updated.getTime())).label(label).tenantId(tId).build()));
                }
                return null;
            }, params.toArray());
            return null;
        });
    }

    protected <R> R doTransaction(Function<JdbcTemplate, R> operation) {
        return (R)this.transactionTemplate.execute(status -> operation.apply(this.jdbcTemplate));
    }

    @Override
    public DatabaseHelper getDatabaseHelper() {
        return this.databaseHelper;
    }

    private void validateNewForm(String tenantId, Form document) {
        if (StringUtils.isBlank((CharSequence)document.getName())) {
            throw new DocumentCorruptedException("form.name is required field.");
        }
        if (document.getName().length() > 128) {
            throw new DocumentCorruptedException("form.name is too long.");
        }
        if (!document.getName().matches("^[_\\-a-zA-Z\\d]+$")) {
            throw new DocumentCorruptedException("form.name is not valid.");
        }
        if (this.formNameExists(tenantId, document.getName())) {
            throw new DocumentConflictException("form with name " + document.getName() + " exists already.");
        }
    }
}

