/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.jdbc;

import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

final class Utils {
    private static final SecureRandom SECURE_RANDOM;

    private Utils() {
    }

    @NonNull
    static byte[] generateOID() {
        byte[] oid = new byte[16];
        SECURE_RANDOM.nextBytes(oid);
        return oid;
    }

    @NonNull
    static String toString(@NonNull byte[] oid) {
        return Hex.encodeHexString((byte[])oid);
    }

    @Nullable
    static byte[] toOID(@Nullable String id) {
        if (id == null) {
            return null;
        }
        try {
            id = id.replace("-", "");
            byte[] oidBytes = Hex.decodeHex((char[])id.toCharArray());
            if (oidBytes.length > 16) {
                throw new DocumentNotFoundException(id + " is too long ID");
            }
            if (oidBytes.length < 16) {
                oidBytes = Arrays.copyOf(oidBytes, 16);
            }
            return oidBytes;
        }
        catch (DecoderException e) {
            throw new DocumentNotFoundException(id + " is not valid ID: " + e.getMessage());
        }
    }

    @Nullable
    static Integer validateRevValue(@Nullable String rev) {
        if (rev == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)rev) || !StringUtils.isNumeric((CharSequence)rev)) {
            throw new IllegalArgumentException("rev must be numeric");
        }
        return Integer.parseInt(rev);
    }

    static {
        SecureRandom secureRandom;
        try {
            secureRandom = SecureRandom.getInstance("NativePRNGNonBlocking");
        }
        catch (NoSuchAlgorithmException e) {
            try {
                secureRandom = SecureRandom.getInstanceStrong();
            }
            catch (NoSuchAlgorithmException e1) {
                secureRandom = new SecureRandom();
            }
        }
        SECURE_RANDOM = secureRandom;
    }
}

