/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.db.spi.exceptions.DocumentCorruptedException;
import java.io.ByteArrayInputStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public interface DatabaseHelper {
    default public Object toJdbcId(byte[] oid) {
        return oid;
    }

    default public Object jsonObject(ObjectMapper objectMapper, Object document) {
        try {
            return new ByteArrayInputStream(objectMapper.writeValueAsBytes(document));
        }
        catch (JsonProcessingException e) {
            throw new DocumentCorruptedException("Could not write questionnaire");
        }
    }

    default public byte[] fromJdbcId(Object oid) {
        return (byte[])oid;
    }

    @NonNull
    default public String tableName(@Nullable String schema, @NonNull String tableName) {
        return StringUtils.isNotBlank((CharSequence)schema) ? schema + "." + tableName : tableName;
    }

    public String getSchema();

    public String jsonContains(String var1);
}

