/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.jdbc;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.api.form.FormTag;
import io.dialob.api.questionnaire.ImmutableQuestionnaire;
import io.dialob.api.questionnaire.ImmutableQuestionnaireMetadata;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.db.jdbc.DatabaseHelper;
import io.dialob.db.jdbc.JdbcBackendDatabase;
import io.dialob.db.jdbc.Utils;
import io.dialob.db.spi.exceptions.DocumentConflictException;
import io.dialob.db.spi.exceptions.DocumentCorruptedException;
import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import io.dialob.form.service.api.FormVersionControlDatabase;
import io.dialob.questionnaire.service.api.ImmutableMetadataRow;
import io.dialob.questionnaire.service.api.QuestionnaireDatabase;
import java.io.IOException;
import java.io.Reader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionTemplate;

public class JdbcQuestionnaireDatabase
extends JdbcBackendDatabase<Questionnaire, Questionnaire.Metadata>
implements QuestionnaireDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcQuestionnaireDatabase.class);
    private final FormVersionControlDatabase versionControlDatabase;
    private final String formIdToNameView;

    public JdbcQuestionnaireDatabase(JdbcTemplate jdbcTemplate, DatabaseHelper databaseHelper, TransactionTemplate transactionTemplate, ObjectMapper objectMapper, String schema, Optional<FormVersionControlDatabase> versionControlDatabase, Predicate<String> isAnyTenantPredicate) {
        super(transactionTemplate, jdbcTemplate, databaseHelper, objectMapper, schema, "questionnaire", Questionnaire.class, isAnyTenantPredicate);
        this.versionControlDatabase = versionControlDatabase.orElse(null);
        this.formIdToNameView = databaseHelper.viewName(schema, "form_id_to_name");
    }

    protected Questionnaire toObject(byte[] oid, int objectRev, String tenantId, byte[] formId, @NonNull String status, Timestamp created, Timestamp updated, Reader reader) {
        try {
            Questionnaire questionnaire = (Questionnaire)this.objectMapper.readValue(reader, Questionnaire.class);
            ImmutableQuestionnaire.Builder builder = ImmutableQuestionnaire.builder().from(questionnaire).id(this.toId(oid)).rev(Integer.toString(objectRev));
            Questionnaire.Metadata metadata = questionnaire.getMetadata();
            builder.metadata((Questionnaire.Metadata)ImmutableQuestionnaireMetadata.builder().from(metadata).created(new Date(created.getTime())).lastAnswer(new Date(updated.getTime())).formId(this.toId(formId)).tenantId(tenantId).status(Questionnaire.Metadata.Status.valueOf((String)status.trim())).build());
            return builder.build();
        }
        catch (IOException e) {
            throw new DocumentCorruptedException("Could not read document " + Utils.toString(oid) + ":" + e.getMessage());
        }
    }

    @Override
    @NonNull
    public Questionnaire findOne(@NonNull String tenantId, @NonNull String id, String rev) {
        Integer revision = Utils.validateRevValue(rev);
        byte[] oid = Utils.toOID(id);
        return this.doTransaction(template -> {
            RowMapper rowMapper = (resultSet, i) -> {
                int objectRev = resultSet.getInt(1);
                String rsTenantId = StringUtils.trim((String)resultSet.getString(2));
                byte[] formId = this.databaseHelper.fromJdbcId(resultSet.getBytes(3));
                String status = resultSet.getString(4);
                Timestamp created = resultSet.getTimestamp(5);
                Timestamp updated = resultSet.getTimestamp(6);
                Reader reader = this.getDatabaseHelper().extractStream(resultSet, 7);
                return this.toObject(oid, objectRev, rsTenantId, formId, status.trim(), created, updated, reader);
            };
            StringBuilder sql = new StringBuilder("select rev, tenant_id, form_document_id, status, created, updated, " + this.getDatabaseHelper().bsonToJson("data") + " from " + this.tableName + " where id = ?");
            ArrayList<Object> sqlParameters = new ArrayList<Object>();
            sqlParameters.add(this.toJdbcId(oid));
            if (revision != null) {
                sqlParameters.add(revision);
                sql.append(" and rev = ?");
            }
            if (this.notAnyTenant(tenantId)) {
                sqlParameters.add(tenantId);
                sql.append(" and tenant_id = ?");
            }
            try {
                return (Questionnaire)template.queryForObject(sql.toString(), sqlParameters.toArray(), rowMapper);
            }
            catch (EmptyResultDataAccessException e) {
                throw new DocumentNotFoundException(id + " not found");
            }
        });
    }

    @Override
    @NonNull
    public Questionnaire save(String tenantId, @NonNull Questionnaire document) {
        return this.doTransaction(template -> {
            int updated;
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            String dId = this.id(document);
            byte[] oid = Utils.toOID(dId);
            Integer revision = this.getRevision(document);
            Questionnaire.Metadata metadata = document.getMetadata();
            byte[] formId = this.mapToFormDocumentId(tenantId, metadata.getFormId(), metadata.getFormRev());
            String status = metadata.getStatus().toString();
            String owner = metadata.getOwner();
            ImmutableQuestionnaire documentNew = ImmutableQuestionnaire.builder().from(document).metadata((Questionnaire.Metadata)ImmutableQuestionnaireMetadata.builder().from(metadata).formId(Utils.toString(formId)).formRev(null).build()).build();
            if (this.isExistingQuestionnaire(oid, revision)) {
                Integer n = revision;
                Integer n2 = revision = Integer.valueOf(revision + 1);
                int prevRevision = n;
                LOGGER.debug("{} - persisting existing document {} to rev {} -> {}", new Object[]{tenantId, dId, prevRevision, revision});
                documentNew = this.updatedDocument((Questionnaire)documentNew, oid, revision, timestamp, (String)null);
                ArrayList<Object> sqlParameters = new ArrayList<Object>();
                sqlParameters.add(revision);
                sqlParameters.add(status);
                sqlParameters.add(timestamp);
                sqlParameters.add(this.getDatabaseHelper().jsonObject(this.objectMapper, documentNew));
                sqlParameters.add(owner);
                sqlParameters.add(this.toJdbcId(oid));
                sqlParameters.add(prevRevision);
                String where = "";
                if (this.notAnyTenant(tenantId)) {
                    where = " and tenant_id = ?";
                    sqlParameters.add(tenantId);
                }
                updated = template.update("update " + this.tableName + " set rev = ?, status = ?, updated = ?, data = " + this.getDatabaseHelper().jsonToBson("?") + ", owner = ? where id = ? and rev = ?" + where, sqlParameters.toArray());
            } else {
                revision = 1;
                if (oid == null) {
                    oid = Utils.generateOID();
                }
                LOGGER.debug("{} - persisting new document {} to rev {}", new Object[]{tenantId, dId, revision});
                documentNew = this.updatedDocument((Questionnaire)documentNew, oid, revision, timestamp, tenantId);
                updated = template.update("insert into " + this.tableName + " (id,rev,tenant_id,form_document_id,status,created,updated,owner,data) values (?,?,?,?,?,?,?,?," + this.getDatabaseHelper().jsonToBson("?") + ")", new Object[]{this.toJdbcId(oid), revision, tenantId, this.toJdbcId(formId), status, timestamp, timestamp, owner, this.getDatabaseHelper().jsonObject(this.objectMapper, documentNew)});
            }
            if (updated == 0) {
                throw new DocumentConflictException("concurrent document update");
            }
            return documentNew;
        });
    }

    private boolean isExistingQuestionnaire(byte[] oid, Integer revision) {
        return revision != null && oid != null;
    }

    private byte[] mapToFormDocumentId(String tenantId, @NonNull String formId, @Nullable String formRev) {
        if (this.versionControlDatabase != null) {
            String id = this.versionControlDatabase.findTag(tenantId, formId, formRev).map(FormTag::getFormId).orElse(formId);
            if (!this.versionControlDatabase.getFormDatabase().exists(tenantId, formId)) {
                throw new DocumentNotFoundException("Form " + formId + " dot not exists");
            }
            return Utils.toOID(id);
        }
        return Utils.toOID(formId);
    }

    @Override
    @NonNull
    protected Questionnaire updatedDocument(@NonNull Questionnaire document, @NonNull byte[] oid, @NonNull Integer revision, @NonNull Timestamp timestamp, @Nullable String tenantId) {
        ImmutableQuestionnaire.Builder builder = ImmutableQuestionnaire.builder().from(document).id(this.toId(oid)).rev(Integer.toString(revision));
        ImmutableQuestionnaireMetadata.Builder metadataBuilder = ImmutableQuestionnaireMetadata.builder().from(document.getMetadata());
        if (document.getMetadata().getCreated() == null) {
            metadataBuilder.created(new Date(timestamp.getTime()));
        }
        if (tenantId != null) {
            metadataBuilder.tenantId(tenantId);
        }
        builder.metadata((Questionnaire.Metadata)metadataBuilder.build());
        return builder.build();
    }

    public void findAllMetadata(String tenantId, String ownerId, String formId, String formName, String formTag, Questionnaire.Metadata.Status status, @NonNull Consumer<QuestionnaireDatabase.MetadataRow> consumer) {
        this.transactionTemplate.execute(transactionStatus -> {
            boolean distinct = false;
            ArrayList<Object> sqlConditions = new ArrayList<Object>();
            ArrayList<Object> sqlParameters = new ArrayList<Object>();
            Object from = this.tableName;
            Object where = "";
            if (tenantId != null && this.notAnyTenant(tenantId)) {
                sqlConditions.add(this.tableName + ".tenant_id = ?");
                sqlParameters.add(tenantId);
            }
            if (StringUtils.isNotBlank((CharSequence)formId)) {
                Object id = this.toJdbcId(Utils.toOID(formId));
                sqlConditions.add("form_document_id = ?");
                sqlParameters.add(id);
            }
            if (StringUtils.isNotBlank((CharSequence)formName)) {
                from = (String)from + " inner join " + this.formIdToNameView + " fid on form_document_id = fid.id and fid.tenant_id = " + this.tableName + ".tenant_id";
                sqlConditions.add("fid.name = ? and fid.deleted is null");
                sqlParameters.add(formName);
                if (StringUtils.isNotBlank((CharSequence)formTag)) {
                    sqlConditions.add("fid.label = ?");
                    sqlParameters.add(formTag);
                } else {
                    distinct = true;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)ownerId)) {
                sqlConditions.add("owner = ?");
                sqlParameters.add(ownerId);
            }
            if (status != null) {
                sqlConditions.add("status = ?");
                sqlParameters.add(status.name());
            }
            if (!sqlConditions.isEmpty()) {
                where = " where " + StringUtils.join(sqlConditions, (String)" and ");
            }
            this.metadataQuery(distinct, (String)from, (String)where, sqlParameters, consumer);
            return null;
        });
    }

    public QuestionnaireDatabase.MetadataRow findMetadata(String tenantId, String questionnaireId) {
        return this.doTransaction(template -> {
            ArrayList<Object> sqlParameters = new ArrayList<Object>();
            Object where = " where id = ?";
            sqlParameters.add(this.toJdbcId(Utils.toOID(questionnaireId)));
            if (tenantId != null && this.notAnyTenant(tenantId)) {
                where = (String)where + " and tenant_id = ?";
                sqlParameters.add(tenantId);
            }
            MutableObject metadata = new MutableObject();
            this.metadataQuery(false, this.tableName, (String)where, sqlParameters, arg_0 -> ((MutableObject)metadata).setValue(arg_0));
            if (metadata.getValue() == null) {
                throw new DocumentNotFoundException(questionnaireId + " not found");
            }
            return (QuestionnaireDatabase.MetadataRow)metadata.getValue();
        });
    }

    private void metadataQuery(boolean distinct, String from, String where, List<Object> sqlParameters, @NonNull Consumer<QuestionnaireDatabase.MetadataRow> consumer) {
        String select = distinct ? "select distinct " : "select ";
        this.jdbcTemplate.query(select + this.tableName + ".tenant_id, " + this.tableName + ".id, " + this.tableName + ".form_document_id, " + this.tableName + ".status, " + this.tableName + ".created, " + this.tableName + ".updated, " + this.tableName + ".owner from " + from + where, sqlParameters.toArray(), resultSet -> {
            String tId = StringUtils.trim((String)resultSet.getString(1));
            byte[] idBytes = this.databaseHelper.fromJdbcId(resultSet.getBytes(2));
            byte[] formIdBytes = this.databaseHelper.fromJdbcId(resultSet.getBytes(3));
            Questionnaire.Metadata.Status status = Questionnaire.Metadata.Status.valueOf((String)resultSet.getString(4).trim());
            Timestamp created = resultSet.getTimestamp(5);
            Timestamp updated = resultSet.getTimestamp(6);
            String owner = resultSet.getString(7);
            consumer.accept((QuestionnaireDatabase.MetadataRow)ImmutableMetadataRow.of((String)this.toId(idBytes), (Questionnaire.Metadata)ImmutableQuestionnaireMetadata.builder().created(new Date(created.getTime())).lastAnswer((Date)updated).formId(this.toId(formIdBytes)).status(status).owner(owner).tenantId(tId).build()));
        });
    }

    @NonNull
    protected Questionnaire updateDocumentId(@NonNull Questionnaire document, String id) {
        return ImmutableQuestionnaire.builder().from(document).id(id).build();
    }

    @NonNull
    protected Questionnaire updateDocumentRev(@NonNull Questionnaire document, String rev) {
        return ImmutableQuestionnaire.builder().from(document).rev(rev).build();
    }

    protected Integer getFormRevision(@NonNull Questionnaire document) {
        String rev = document.getMetadata().getFormRev();
        if (rev == null) {
            return null;
        }
        if ("LATEST".equals(rev)) {
            return 0;
        }
        return Integer.parseInt(rev);
    }

    protected String toFormRevision(int formRev) {
        return formRev == 0 ? "LATEST" : Integer.toString(formRev);
    }
}

