/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.db.jdbc.AbstractDatabaseHelper;
import io.dialob.db.spi.exceptions.DocumentCorruptedException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.postgresql.util.PGobject;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class PostgreSQLDatabaseHelper
extends AbstractDatabaseHelper {
    public PostgreSQLDatabaseHelper(String schema) {
        super(schema);
    }

    @Override
    public Object toJdbcId(byte[] oid) {
        if (oid == null) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(oid);
        long firstLong = bb.getLong();
        long secondLong = bb.getLong();
        return new UUID(firstLong, secondLong);
    }

    @Override
    public Object jsonObject(ObjectMapper objectMapper, Object document) {
        try {
            PGobject jsonObject = new PGobject();
            jsonObject.setType("jsonb");
            jsonObject.setValue(this.serializeJson(objectMapper, document));
            return jsonObject;
        }
        catch (JsonProcessingException | SQLException e) {
            throw new DocumentCorruptedException("Could not write questionnaire");
        }
    }

    @Override
    public byte[] fromJdbcId(Object oid) {
        UUID uuid;
        if (oid instanceof UUID) {
            uuid = (UUID)oid;
        } else if (oid instanceof byte[]) {
            byte[] bytes = (byte[])oid;
            if (bytes.length == 16) {
                return bytes;
            }
            uuid = UUID.fromString(new String(bytes));
        } else {
            throw new IllegalArgumentException("Cannot convert " + oid + " UUID bytes");
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    @Override
    @NonNull
    public String tableName(@Nullable String schema, @NonNull String tableName) {
        return "\"" + (String)(StringUtils.isNotBlank((CharSequence)schema) ? schema + "\".\"" + tableName : tableName) + "\"";
    }

    @Override
    public String jsonContains(String path) {
        return "data->'" + path + "' @> ?";
    }
}

