/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.jdbc;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.api.form.Form;
import io.dialob.api.form.ImmutableForm;
import io.dialob.api.form.ImmutableFormMetadata;
import io.dialob.db.jdbc.DatabaseHelper;
import io.dialob.db.jdbc.JdbcBackendDatabase;
import io.dialob.db.jdbc.Utils;
import io.dialob.db.spi.exceptions.DocumentConflictException;
import io.dialob.db.spi.exceptions.DocumentCorruptedException;
import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import io.dialob.form.service.api.FormDatabase;
import io.dialob.form.service.api.ImmutableFormMetadataRow;
import java.io.IOException;
import java.io.Reader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.NonNull;
import org.springframework.transaction.support.TransactionTemplate;

public class JdbcFormDatabase
extends JdbcBackendDatabase<Form, FormDatabase.FormMetadataRow>
implements FormDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcFormDatabase.class);

    public JdbcFormDatabase(JdbcTemplate jdbcTemplate, DatabaseHelper databaseHelper, TransactionTemplate transactionTemplate, ObjectMapper objectMapper, String schema, Predicate<String> isAnyTenantPredicate) {
        super(transactionTemplate, jdbcTemplate, databaseHelper, objectMapper, schema, "form_document", Form.class, isAnyTenantPredicate);
    }

    @Override
    @NonNull
    public Form findOne(@NonNull String tenantId, @NonNull String id, String rev) {
        Integer revision = Utils.validateRevValue(rev);
        byte[] oid = Utils.toOID(id);
        return this.doTransaction(template -> {
            RowMapper rowMapper = (resultSet, i) -> {
                int objectRev = resultSet.getInt(1);
                String rsTenantId = StringUtils.trim((String)resultSet.getString(2));
                Timestamp created = resultSet.getTimestamp(3);
                Timestamp updated = resultSet.getTimestamp(4);
                Reader reader = this.getDatabaseHelper().extractStream(resultSet, 5);
                return this.toObject(oid, objectRev, rsTenantId, created, updated, reader);
            };
            StringBuilder sql = new StringBuilder("select rev, tenant_id, created, updated, " + this.bsonToJson("data") + " from " + this.tableName + " where id = ?");
            ArrayList<Object> sqlParameters = new ArrayList<Object>();
            sqlParameters.add(this.toJdbcId(oid));
            if (revision != null) {
                sqlParameters.add(revision);
                sql.append(" and rev = ?");
            }
            if (this.notAnyTenant(tenantId)) {
                sqlParameters.add(tenantId);
                sql.append(" and tenant_id = ?");
            }
            try {
                return (Form)template.queryForObject(sql.toString(), sqlParameters.toArray(), rowMapper);
            }
            catch (EmptyResultDataAccessException e) {
                throw new DocumentNotFoundException(id + " not found");
            }
        });
    }

    @Override
    @NonNull
    public Form save(String tenantId, @NonNull Form document) {
        return this.doTransaction(template -> {
            int updated;
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            byte[] oid = Utils.toOID(this.id(document));
            Integer revision = this.getRevision(document);
            String label = this.getLabel(document);
            Object data = this.getDatabaseHelper().jsonObject(this.objectMapper, document);
            if (revision != null && oid != null) {
                Integer n = revision;
                Integer n2 = revision = Integer.valueOf(revision + 1);
                int prevRevision = n;
                updated = this.notAnyTenant(tenantId) ? template.update("update " + this.tableName + " set rev = ?, updated = ?, data = " + this.jsonToBson("?") + " where id = ? and rev = ? and tenant_id = ?", new Object[]{revision, timestamp, data, this.toJdbcId(oid), prevRevision, tenantId}) : template.update("update " + this.tableName + " set rev = ?, updated = ?, data = " + this.jsonToBson("?") + "  where id = ? and rev = ?", new Object[]{revision, timestamp, data, this.toJdbcId(oid), prevRevision});
            } else {
                revision = 1;
                if (oid == null) {
                    oid = Utils.generateOID();
                }
                updated = template.update("insert into " + this.tableName + " (id,rev,tenant_id,created,updated,data) values (?,?,?,?,?," + this.jsonToBson("?") + ")", new Object[]{this.toJdbcId(oid), revision, tenantId, timestamp, timestamp, data});
            }
            if (updated == 0) {
                throw new DocumentConflictException("concurrent document update");
            }
            return this.updatedDocument(document, oid, revision, timestamp, tenantId);
        });
    }

    protected String getLabel(@NonNull Form document) {
        return document.getMetadata().getLabel();
    }

    protected Form toObject(byte[] oid, int objectRev, String tenantId, Timestamp created, Timestamp updated, Reader reader) {
        try {
            Form form = (Form)this.objectMapper.readValue(reader, Form.class);
            return ImmutableForm.builder().from(form).id(this.toId(oid)).rev(Integer.toString(objectRev)).metadata((Form.Metadata)ImmutableFormMetadata.builder().from(form.getMetadata()).created(new Date(created.getTime())).tenantId(tenantId).build()).build();
        }
        catch (IOException e) {
            throw new DocumentCorruptedException("Could not read document " + oid + ":" + e.getMessage());
        }
    }

    @Override
    @NonNull
    protected Form updatedDocument(@NonNull Form form, @NonNull byte[] oid, @NonNull Integer revision, @NonNull Timestamp timestamp, String tenantId) {
        ImmutableFormMetadata.Builder builder = ImmutableFormMetadata.builder();
        if (form.getMetadata() != null) {
            builder = builder.from(form.getMetadata());
            builder = builder.created(new Date(timestamp.getTime()));
        }
        if (tenantId != null) {
            builder = builder.tenantId(tenantId);
        }
        return ImmutableForm.builder().from(form).id(this.toId(oid)).rev(Integer.toString(revision)).metadata((Form.Metadata)builder.build()).build();
    }

    public void findAllMetadata(String tenantId, Form.Metadata metadata, @NonNull Consumer<FormDatabase.FormMetadataRow> consumer) {
        this.transactionTemplate.execute(transactionStatus -> {
            Object where;
            ArrayList<Object> params = new ArrayList<Object>();
            ArrayList<String> conditions = new ArrayList<String>();
            if (this.notAnyTenant(tenantId)) {
                conditions.add("tenant_id = ?");
                params.add(tenantId);
            }
            if (metadata != null) {
                conditions.add(this.getDatabaseHelper().jsonContains("metadata"));
                params.add(this.getDatabaseHelper().jsonObject(this.objectMapper, metadata));
            }
            if (StringUtils.isNotBlank((CharSequence)(where = conditions.stream().collect(Collectors.joining(" and "))))) {
                where = " where " + (String)where;
            }
            this.jdbcTemplate.query("select tenant_id, id, created, updated from " + this.tableName + (String)where, resultSet -> {
                String tId = StringUtils.trim((String)resultSet.getString(1));
                byte[] id = this.getDatabaseHelper().fromJdbcId(resultSet.getBytes(2));
                Timestamp created = resultSet.getTimestamp(3);
                Timestamp updated = resultSet.getTimestamp(4);
                consumer.accept((FormDatabase.FormMetadataRow)ImmutableFormMetadataRow.of((String)this.toId(id), (Form.Metadata)ImmutableFormMetadata.builder().tenantId(tId).created(new Date(created.getTime())).lastSaved(new Date(updated.getTime())).build()));
            }, params.toArray());
            return null;
        });
    }

    @NonNull
    protected Form updateDocumentId(@NonNull Form document, String id) {
        return ImmutableForm.builder().from(document).id(id).build();
    }

    @NonNull
    protected Form updateDocumentRev(@NonNull Form document, String rev) {
        return ImmutableForm.builder().from(document).rev(rev).build();
    }
}

