/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.db.jdbc.AbstractDatabaseHelper;
import io.dialob.db.spi.exceptions.DocumentCorruptedException;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.support.SqlLobValue;

public class DB2DatabaseHelper
extends AbstractDatabaseHelper {
    private final Map<String, String> remap;

    public DB2DatabaseHelper(String schema, Map<String, String> remap) {
        super(schema);
        this.remap = remap != null ? remap : Collections.emptyMap();
    }

    @Override
    public String jsonContains(String path) {
        return "JSON_VAL(data, '" + path + "', 'u') is not null ?";
    }

    @Override
    public String jsonToBson(String attr) {
        return "SYSTOOLS.JSON2BSON(" + attr + ")";
    }

    @Override
    public String bsonToJson(String attr) {
        return "SYSTOOLS.BSON2JSON(" + attr + ")";
    }

    @Override
    public Object jsonObject(ObjectMapper objectMapper, Object document) {
        try {
            return new SqlParameterValue(2005, (Object)new SqlLobValue(this.serializeJson(objectMapper, document)));
        }
        catch (JsonProcessingException e) {
            throw new DocumentCorruptedException("Could not write JSON object");
        }
    }

    @Override
    public String remap(String name) {
        return this.remap.getOrDefault(name, name);
    }

    @Override
    public Reader extractStream(ResultSet rs, int i) throws SQLException {
        return rs.getClob(i).getCharacterStream();
    }
}

