/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.jdbc;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.db.jdbc.DatabaseHelper;
import io.dialob.db.jdbc.JdbcDatabase;
import io.dialob.db.jdbc.Utils;
import io.dialob.db.spi.spring.AbstractDocumentDatabase;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.lang.NonNull;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class JdbcBackendDatabase<T, M>
extends AbstractDocumentDatabase<T>
implements JdbcDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcBackendDatabase.class);
    protected final String tableName;
    protected final JdbcTemplate jdbcTemplate;
    protected final TransactionTemplate transactionTemplate;
    protected final ObjectMapper objectMapper;
    protected final DatabaseHelper databaseHelper;
    protected final Predicate<String> isAnyTenantPredicate;

    public JdbcBackendDatabase(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, DatabaseHelper databaseHelper, ObjectMapper objectMapper, String schema, String tableName, Class<? extends T> documentClass, Predicate<String> isAnyTenantPredicate) {
        super(documentClass);
        this.transactionTemplate = transactionTemplate;
        this.databaseHelper = databaseHelper;
        this.objectMapper = objectMapper;
        this.jdbcTemplate = jdbcTemplate;
        this.tableName = databaseHelper.tableName(schema, tableName);
        this.isAnyTenantPredicate = Objects.requireNonNull(isAnyTenantPredicate);
    }

    @Override
    public DatabaseHelper getDatabaseHelper() {
        return this.databaseHelper;
    }

    public abstract T findOne(@NonNull String var1, @NonNull String var2, String var3);

    protected String toId(byte[] oid) {
        return Hex.encodeHexString((byte[])oid);
    }

    protected boolean notAnyTenant(String tenantId) {
        return !this.isAnyTenantPredicate.test(tenantId);
    }

    @NonNull
    public T findOne(String tenantId, @NonNull String id) {
        return this.findOne(tenantId, id, null);
    }

    public boolean exists(@NonNull String tenantId, @NonNull String id) {
        byte[] oid = Utils.toOID(id);
        return this.doTransaction(template -> {
            Integer count = this.notAnyTenant(tenantId) ? (Integer)template.queryForObject("select count(*) from " + this.tableName + " where id = ? and tenant_id = ?", Integer.class, new Object[]{this.toJdbcId(oid), tenantId}) : (Integer)template.queryForObject("select count(*) from " + this.tableName + " where id = ?", Integer.class, new Object[]{this.toJdbcId(oid)});
            return count > 0;
        });
    }

    public boolean delete(@NonNull String tenantId, @NonNull String id) {
        byte[] oid = Utils.toOID(id);
        return this.doTransaction(template -> {
            if (this.notAnyTenant(tenantId)) {
                return template.update("delete from " + this.tableName + " where id = ? and tenant_id = ?", new Object[]{this.toJdbcId(oid), tenantId});
            }
            return template.update("delete from " + this.tableName + " where id = ?", new Object[]{this.toJdbcId(oid)});
        }) > 0;
    }

    @NonNull
    public abstract T save(String var1, @NonNull T var2);

    protected Integer getRevision(@NonNull T document) {
        String rev = this.rev(document);
        if (rev == null) {
            return null;
        }
        return Integer.parseInt(rev);
    }

    @NonNull
    protected abstract T updatedDocument(@NonNull T var1, @NonNull byte[] var2, @NonNull Integer var3, @NonNull Timestamp var4, String var5);

    protected <R> R doTransaction(Function<JdbcTemplate, R> operation) {
        return (R)this.transactionTemplate.execute(status -> operation.apply(this.jdbcTemplate));
    }
}

