/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.gcdatastore.repository.spi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.datastore.BaseEntity;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.EntityQuery;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import io.dialob.api.questionnaire.ImmutableQuestionnaire;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.db.gcdatastore.repository.QuestionnaireRepository;
import io.dialob.db.gcdatastore.repository.spi.BaseDatastoreRepository;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;

public class DatastoreQuestionnaireRepository
extends BaseDatastoreRepository<Questionnaire, String>
implements QuestionnaireRepository {
    String[] metadataProjection = new String[]{"metadata"};

    public DatastoreQuestionnaireRepository(Datastore datastore, ObjectMapper mapper, String namespace, String kind) {
        super(datastore, mapper, namespace, kind, Questionnaire.class);
    }

    @Override
    public List<Questionnaire> findAllMetadata() {
        LinkedList<Questionnaire> result = new LinkedList<Questionnaire>();
        EntityQuery.Builder entityQueryBuilder = Query.newEntityQueryBuilder();
        String namespace = this.getNamespace();
        if (!StringUtils.isEmpty((CharSequence)namespace)) {
            entityQueryBuilder = (EntityQuery.Builder)entityQueryBuilder.setNamespace(namespace);
        }
        EntityQuery query = ((EntityQuery.Builder)entityQueryBuilder.setKind(this.getKind())).build();
        QueryResults results = this.datastore.run((Query)query);
        results.forEachRemaining(entity -> result.add(this.convert((BaseEntity<Key>)entity, Questionnaire.class)));
        return result;
    }

    @Override
    protected Questionnaire convert(Entity entity) {
        return this.convert((BaseEntity<Key>)entity, Questionnaire.class);
    }

    @NonNull
    protected Questionnaire updateDocumentId(@NonNull Questionnaire document, String id) {
        return ImmutableQuestionnaire.builder().from(document).id(id).build();
    }

    @NonNull
    protected Questionnaire updateDocumentRev(@NonNull Questionnaire document, String rev) {
        return ImmutableQuestionnaire.builder().from(document).rev(rev).build();
    }
}

