/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.gcdatastore.repository.spi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.datastore.BaseEntity;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.EntityQuery;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import io.dialob.api.form.Form;
import io.dialob.api.form.ImmutableForm;
import io.dialob.db.gcdatastore.repository.FormRepository;
import io.dialob.db.gcdatastore.repository.spi.BaseDatastoreRepository;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;

public class DatastoreFormRepository
extends BaseDatastoreRepository<Form, String>
implements FormRepository {
    public DatastoreFormRepository(Datastore datastore, ObjectMapper mapper, String namespace, String kind) {
        super(datastore, mapper, namespace, kind, Form.class);
    }

    @Override
    public List<Form> findAllMetadata() {
        LinkedList<Form> result = new LinkedList<Form>();
        EntityQuery.Builder entityQueryBuilder = Query.newEntityQueryBuilder();
        String namespace = this.getNamespace();
        if (!StringUtils.isEmpty((CharSequence)namespace)) {
            entityQueryBuilder = (EntityQuery.Builder)entityQueryBuilder.setNamespace(namespace);
        }
        EntityQuery query = ((EntityQuery.Builder)entityQueryBuilder.setKind(this.getKind())).build();
        QueryResults results = this.datastore.run((Query)query);
        results.forEachRemaining(entity -> result.add(this.convert((BaseEntity<Key>)entity, Form.class)));
        return result;
    }

    @Override
    protected Form convert(Entity entity) {
        return this.convert((BaseEntity<Key>)entity, Form.class);
    }

    @NonNull
    protected Form updateDocumentId(@NonNull Form form, String id) {
        return ImmutableForm.builder().from(form).id(id).build();
    }

    @NonNull
    protected Form updateDocumentRev(@NonNull Form from, String rev) {
        return ImmutableForm.builder().from(from).rev(rev).build();
    }
}

