/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.gcdatastore.repository.spi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.cloud.datastore.BaseEntity;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import com.google.cloud.datastore.StringValue;
import com.google.cloud.datastore.Transaction;
import com.google.cloud.datastore.Value;
import io.dialob.db.gcdatastore.repository.DatastoreRepository;
import io.dialob.db.spi.exceptions.DocumentCorruptedException;
import io.dialob.db.spi.spring.AbstractDocumentDatabase;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;

public abstract class BaseDatastoreRepository<T, ID extends Serializable>
extends AbstractDocumentDatabase<T>
implements DatastoreRepository<T, ID> {
    private static final String REV_PROPERTY_NAME = "_rev";
    protected final Datastore datastore;
    private final ObjectMapper mapper;
    private final String kind;
    private final String namespace;
    private Set<String> indexedProperties = new HashSet<String>(Arrays.asList("_id", "_rev"));

    protected BaseDatastoreRepository(Datastore datastore, ObjectMapper mapper, String namespace, String kind, Class<? extends T> documentClass) {
        super(documentClass);
        this.datastore = datastore;
        this.mapper = mapper;
        this.namespace = namespace;
        this.kind = kind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T save(T document) {
        Transaction transaction = this.datastore.newTransaction();
        try {
            this.checkDocumentRevision(document, transaction);
            Entity entity = this.convert(document, this.getNextDocumentRev(document));
            Entity putEntity = transaction.put((FullEntity)entity);
            transaction.commit();
            T savedDocument = this.convert(putEntity);
            document = this.updateDocumentId(document, this.id(savedDocument));
            Object object = document = this.updateDocumentRev(document, this.rev(savedDocument));
            return object;
        }
        finally {
            if (transaction.isActive()) {
                transaction.rollback();
            }
        }
    }

    private String getNextDocumentRev(T document) {
        String rev = this.rev(document);
        String newRev = rev != null ? Integer.toString(Integer.parseInt(rev) + 1) : "1";
        return newRev;
    }

    private void checkDocumentRevision(T document, Transaction transaction) {
        T previousVersion;
        String id = this.id(document);
        String rev = this.rev(document);
        if (!StringUtils.isBlank((CharSequence)id) && (previousVersion = this.convert(transaction.get(this.getKey(Long.valueOf(id))))) != null && !StringUtils.equals((CharSequence)this.rev(previousVersion), (CharSequence)rev)) {
            throw new ConcurrentModificationException(id + " revision " + rev + " is out of date by newer version " + this.rev(previousVersion));
        }
    }

    @Override
    public T findOne(@NonNull ID id) {
        Entity entity = this.datastore.get(this.getKey(Long.valueOf(id.toString())));
        return this.convert(entity);
    }

    @Override
    public boolean exists(@NonNull ID id) {
        Entity entity = this.datastore.get(this.getKey(Long.valueOf(id.toString())));
        return entity != null;
    }

    @Override
    public void delete(@NonNull ID id) {
        this.datastore.delete(new Key[]{this.getKey(Long.valueOf(id.toString()))});
    }

    private Key getKey(@NonNull Long key) {
        return this.getKeyFactory().newKey(key.longValue());
    }

    protected Entity convert(@NonNull T document, String rev) {
        KeyFactory keyFactory = this.getKeyFactory();
        Key key = !StringUtils.isEmpty((CharSequence)this.id(document)) ? this.getKey(Long.valueOf(this.id(document))) : this.datastore.allocateId(keyFactory.newKey());
        Entity.Builder builder = Entity.newBuilder((Key)key);
        return this.convert(document, builder, rev);
    }

    private KeyFactory getKeyFactory() {
        KeyFactory keyFactory = this.datastore.newKeyFactory();
        if (this.getNamespace() != null) {
            keyFactory = (KeyFactory)keyFactory.setNamespace(this.getNamespace());
        }
        keyFactory = (KeyFactory)keyFactory.setKind(this.getKind());
        return keyFactory;
    }

    protected T convert(BaseEntity<Key> entity, Class<T> type) {
        Object result = null;
        if (entity != null) {
            try {
                ObjectNode root = this.mapper.createObjectNode();
                for (String name : entity.getNames()) {
                    root.set(name, this.mapper.readTree(entity.getString(name)));
                }
                result = this.mapper.treeToValue((TreeNode)root, type);
                result = this.updateDocumentId(result, ((Key)entity.getKey()).getNameOrId().toString());
            }
            catch (IOException e) {
                throw new DocumentCorruptedException(e.getMessage());
            }
        }
        return (T)result;
    }

    protected Entity convert(T document, Entity.Builder builder, String rev) {
        Entity result;
        try {
            JsonNode tree = this.mapper.valueToTree(document);
            Iterator fields = tree.fields();
            while (fields.hasNext()) {
                Map.Entry val = (Map.Entry)fields.next();
                String fieldStringValue = this.mapper.writeValueAsString(val.getValue());
                if (this.isIndexed((String)val.getKey(), fieldStringValue)) {
                    builder.set((String)val.getKey(), fieldStringValue);
                    continue;
                }
                builder.set((String)val.getKey(), (Value)((StringValue.Builder)StringValue.newBuilder((String)fieldStringValue).setExcludeFromIndexes(true)).build());
            }
            builder.set(REV_PROPERTY_NAME, rev);
            result = builder.build();
        }
        catch (JsonProcessingException e) {
            throw new DocumentCorruptedException(e.getMessage());
        }
        return result;
    }

    private boolean isIndexed(String key, String fieldStringValue) {
        return this.indexedProperties.contains(key);
    }

    protected String getKind() {
        return this.kind;
    }

    protected abstract T convert(Entity var1);

    protected String getNamespace() {
        return this.namespace;
    }
}

