/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.gcdatastore.database;

import com.google.cloud.datastore.DatastoreException;
import io.dialob.db.gcdatastore.repository.DatastoreRepository;
import io.dialob.db.spi.exceptions.DatabaseServiceDownException;
import io.dialob.db.spi.exceptions.DatabaseUnauthorizedException;
import io.dialob.db.spi.exceptions.DocumentConflictException;
import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import java.util.ConcurrentModificationException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class BaseDatastoreDatabase<T, R extends DatastoreRepository<T, String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDatastoreDatabase.class);
    protected final R repository;

    public BaseDatastoreDatabase(R repository) {
        this.repository = repository;
    }

    protected <A> A handleAction(Function<R, A> action) {
        try {
            return action.apply(this.repository);
        }
        catch (DatastoreException e) {
            LOGGER.warn("Datastore operation exception:", (Throwable)e);
            switch (e.getCode()) {
                case 6: {
                    throw new DocumentConflictException(e.getMessage());
                }
                case 7: 
                case 16: {
                    throw new DatabaseUnauthorizedException("Could not access: " + e.getMessage());
                }
            }
            throw new DatabaseServiceDownException("Database access failure: " + e.getMessage());
        }
        catch (ConcurrentModificationException e) {
            LOGGER.info("Datastore concurrent update:", (Object)e.getMessage());
            throw new DocumentConflictException(e.getMessage());
        }
    }

    @NonNull
    public T findOne(String tenantId, @NonNull String id, String rev) {
        return (T)this.handleAction(repository -> {
            Object document = repository.findOne(id);
            if (document == null) {
                throw new DocumentNotFoundException("not_found");
            }
            return document;
        });
    }

    @NonNull
    public T findOne(String tenantId, @NonNull String id) {
        return this.findOne(tenantId, id, null);
    }

    public boolean exists(String tenantId, @NonNull String id) {
        return this.handleAction(repository -> repository.exists(id));
    }

    public boolean delete(String tenantId, @NonNull String id) {
        return this.handleAction(repository -> {
            repository.delete(id);
            return true;
        });
    }

    @NonNull
    public T save(String tenantId, @NonNull T document) {
        return (T)this.handleAction(repository -> repository.save(document));
    }
}

