/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.file;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.db.file.VersionConflictException;
import io.dialob.db.spi.exceptions.DocumentCorruptedException;
import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import io.dialob.db.spi.spring.AbstractDocumentDatabase;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public abstract class AbstractFileDatabase<F>
extends AbstractDocumentDatabase<F> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileDatabase.class);
    private final Path path;
    private final ObjectMapper objectMapper;

    public AbstractFileDatabase(Class<F> documentClass, String directory, ObjectMapper objectMapper) {
        super(documentClass);
        File pathFile = new File(directory);
        if (pathFile.exists()) {
            if (pathFile.isFile()) {
                throw new RuntimeException(pathFile.getAbsolutePath() + " is file");
            }
        } else {
            pathFile.mkdirs();
        }
        this.path = pathFile.toPath();
        this.objectMapper = objectMapper;
    }

    protected File fileRef(String id) {
        return this.path.resolve(id + ".json").toFile();
    }

    @NonNull
    public F findOne(String tenantId, @NonNull String id, String rev) {
        File file = this.fileRef(id);
        if (!file.exists()) {
            throw new DocumentNotFoundException("document " + id + " do not exists");
        }
        return this.loadFile(file);
    }

    public F loadFile(File file) {
        try {
            return (F)this.objectMapper.readValue(file, this.getDocumentClass());
        }
        catch (IOException e) {
            LOGGER.error("File " + file.getAbsoluteFile() + " is corrupted.", (Throwable)e);
            return null;
        }
    }

    @NonNull
    public F findOne(String tenantId, @NonNull String id) {
        return this.findOne(tenantId, id, null);
    }

    protected void forAllFiles(@NonNull Consumer<File> fileConsumer) {
        ArrayList files = new ArrayList();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.path);){
            directoryStream.forEach(p -> fileConsumer.accept(p.toFile()));
        }
        catch (IOException e) {
            LOGGER.error("failed to read directory ", (Throwable)e);
        }
    }

    public String fileBaseName(File file) {
        String name = file.getName();
        if (name.endsWith(".json")) {
            return name.substring(0, name.length() - 5);
        }
        return name;
    }

    public boolean exists(String tenantId, @NonNull String id) {
        File file = this.fileRef(id);
        return file.exists();
    }

    public boolean delete(String tenantId, @NonNull String id) {
        return this.fileRef(id).delete();
    }

    @NonNull
    public F save(String tenantId, @NonNull F document) {
        String id = this.id(document);
        String rev = this.rev(document);
        if (!StringUtils.isBlank((CharSequence)id)) {
            try {
                F previousVersion = this.findOne(tenantId, id);
                if (rev == null || !rev.equals(this.rev(previousVersion))) {
                    throw new VersionConflictException(id + " revision " + this.rev(previousVersion) + " do not match with " + rev);
                }
                this.updateDocumentRev(document, Integer.toString(Integer.parseInt(rev) + 1));
            }
            catch (DocumentNotFoundException e) {
                this.initNewDocument(document);
            }
        } else {
            this.initNewDocument(document);
        }
        try {
            this.objectMapper.writeValue(this.fileRef(this.id(document)), document);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write document " + id, (Throwable)e);
            throw new DocumentCorruptedException("Cannot update document " + id);
        }
        return document;
    }

    private void initNewDocument(F document) {
        this.updateDocumentId(document, this.createUuid());
        this.updateDocumentRev(document, "1");
    }

    protected String createUuid() {
        return UUID.randomUUID().toString().replace("-", "");
    }
}

